/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.Token;
import org.apache.uima.ruta.ide.parser.ast.AbstractFactory;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;

public class ConditionFactory
extends AbstractFactory {
    public static final String IMPLICIT = "Implicit";

    public static RutaCondition createCondition(Token type, List exprs) {
        Expression lastExpr;
        int[] wholeConditionBounds = ConditionFactory.getBounds(type);
        int nameStart = wholeConditionBounds[0];
        int nameEnd = wholeConditionBounds[1];
        if (exprs == null) {
            exprs = new ArrayList<Expression>();
        }
        if (!exprs.isEmpty() && (lastExpr = (Expression)exprs.get(exprs.size() - 1)) != null) {
            wholeConditionBounds[1] = Math.max(wholeConditionBounds[1], lastExpr.sourceEnd());
        }
        return new RutaCondition(wholeConditionBounds[0], wholeConditionBounds[1], exprs, 10000 + type.getType(), type.getText(), nameStart, nameEnd);
    }

    public static RutaCondition createCondition(Expression ... exprsArray) {
        ArrayList<Expression> exprL = new ArrayList<Expression>();
        if (exprsArray != null) {
            for (int i = 0; i < exprsArray.length; ++i) {
                Expression expression = exprsArray[i];
                if (expression == null) continue;
                exprL.add(expression);
            }
        }
        int[] bounds = ConditionFactory.getBounds((ASTNode)exprL.get(0), (ASTNode)exprL.get(exprL.size() - 1));
        return new RutaCondition(bounds[0], bounds[1], exprL, 10000, IMPLICIT, bounds[0], bounds[1]);
    }

    public static RutaCondition createCondition(Token type, Expression ... exprsArray) {
        ArrayList<Expression> exprL = new ArrayList<Expression>();
        if (exprsArray != null) {
            for (int i = 0; i < exprsArray.length; ++i) {
                Expression expression = exprsArray[i];
                if (expression == null) continue;
                exprL.add(expression);
            }
        }
        return ConditionFactory.createCondition(type, exprL);
    }

    public static RutaCondition createEmptyCondition(Token token) {
        if (token != null && token.getText().equals("->")) {
            return null;
        }
        int[] bounds = ConditionFactory.getBounds(token);
        return new RutaCondition(bounds[0], bounds[1], new ArrayList<Expression>(), 10000, "", bounds[0], bounds[1]);
    }
}

