/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.transport.TransportListener;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.aae.AsynchAECasManager;
import org.apache.uima.aae.UIDGenerator;
import org.apache.uima.aae.UimaSerializer;
import org.apache.uima.aae.client.UimaASProcessStatus;
import org.apache.uima.aae.client.UimaASProcessStatusImpl;
import org.apache.uima.aae.client.UimaASStatusCallbackListener;
import org.apache.uima.aae.client.UimaAsBaseCallbackListener;
import org.apache.uima.aae.client.UimaAsynchronousEngine;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController_impl;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.error.InvalidMessageException;
import org.apache.uima.aae.error.MessageTimeoutException;
import org.apache.uima.aae.error.ServiceShutdownException;
import org.apache.uima.aae.error.UimaASCollectionProcessCompleteTimeout;
import org.apache.uima.aae.error.UimaASMetaRequestTimeout;
import org.apache.uima.aae.error.UimaASPingTimeout;
import org.apache.uima.aae.error.UimaASProcessCasTimeout;
import org.apache.uima.aae.error.UimaEEServiceException;
import org.apache.uima.aae.jmx.UimaASClientInfo;
import org.apache.uima.aae.jmx.UimaASClientInfoMBean;
import org.apache.uima.aae.monitor.statistics.AnalysisEnginePerformanceMetrics;
import org.apache.uima.adapter.jms.ConnectionValidator;
import org.apache.uima.adapter.jms.client.ClientServiceDelegate;
import org.apache.uima.adapter.jms.client.MessageSender;
import org.apache.uima.adapter.jms.client.UimaAsClientStoppingException;
import org.apache.uima.adapter.jms.message.PendingMessage;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.cas.impl.AllowPreexistingFS;
import org.apache.uima.cas.impl.BinaryCasSerDes6;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.jms.error.handler.BrokerConnectionException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.impl.ProcessTrace_impl;

public abstract class BaseUIMAAsynchronousEngineCommon_impl
implements UimaAsynchronousEngine,
MessageListener {
    private static final Class<BaseUIMAAsynchronousEngineCommon_impl> CLASS_NAME = BaseUIMAAsynchronousEngineCommon_impl.class;
    protected ClientState state = ClientState.INITIALIZING;
    protected String brokerURI = null;
    protected static final String SHADOW_CAS_POOL = "ShadowCasPool";
    protected static final int MetadataTimeout = 1;
    protected static final int CpCTimeout = 2;
    protected static final int ProcessTimeout = 3;
    protected static final int PingTimeout = 4;
    protected volatile boolean initialized;
    protected List listeners = new ArrayList();
    protected AsynchAECasManager asynchManager;
    protected boolean remoteService = false;
    protected CollectionReader collectionReader = null;
    protected volatile boolean running = false;
    protected ProcessingResourceMetaData resourceMetadata;
    protected CAS sendAndReceiveCAS = null;
    protected UIDGenerator idGenerator = new UIDGenerator();
    protected ConcurrentHashMap<String, ClientRequest> clientCache = new ConcurrentHashMap();
    protected ConcurrentHashMap<Long, ThreadMonitor> threadMonitorMap = new ConcurrentHashMap();
    protected int processTimeout = 0;
    protected int metadataTimeout = 60000;
    protected int cpcTimeout = 0;
    protected volatile boolean abort = false;
    protected static final String uniqueIdentifier = String.valueOf(System.nanoTime());
    protected Exception exc;
    protected AtomicLong outstandingCasRequests = new AtomicLong();
    protected AtomicLong totalCasRequestsSentBetweenCpCs = new AtomicLong();
    protected ConcurrentHashMap springContainerRegistry = new ConcurrentHashMap();
    protected MessageConsumer consumer = null;
    protected SerialFormat serialFormat = SerialFormat.XMI;
    protected TypeSystemImpl remoteTypeSystem;
    protected UimaASClientInfoMBean clientSideJmxStats = new UimaASClientInfo();
    private UimaSerializer uimaSerializer = new UimaSerializer();
    protected ClientServiceDelegate serviceDelegate = null;
    private Object stopMux = new Object();
    private Object sendMux = new Object();
    private BlockingQueue<CasQueueEntry> threadQueue = new LinkedBlockingQueue<CasQueueEntry>();
    private ConcurrentHashMap<Long, CasQueueEntry> threadRegistrar = new ConcurrentHashMap();
    private volatile boolean casQueueProducerReady;
    private Object casProducerMux = new Object();
    protected BlockingQueue<PendingMessage> pendingMessageQueue = new LinkedBlockingQueue<PendingMessage>();
    protected Semaphore producerSemaphore = new Semaphore(1);
    protected Semaphore cpcSemaphore = new Semaphore(1);
    protected Semaphore getMetaSemaphore = new Semaphore(0, true);
    protected Semaphore cpcReadySemaphore = new Semaphore(1);
    protected Semaphore cpcReplySemaphore = new Semaphore(1);
    protected volatile boolean producerInitialized;
    protected static ConcurrentHashMap<String, SharedConnection> sharedConnections = new ConcurrentHashMap();
    protected Thread shutdownHookThread = null;
    private ExecutorService exec = Executors.newFixedThreadPool(1);
    private volatile boolean casMultiplierDelegate;
    protected volatile boolean timerPerCAS = false;

    public abstract String getEndPointName() throws Exception;

    protected abstract TextMessage createTextMessage() throws Exception;

    protected abstract BytesMessage createBytesMessage() throws Exception;

    protected abstract void setMetaRequestMessage(Message var1) throws Exception;

    protected abstract void setCASMessage(String var1, CAS var2, Message var3) throws Exception;

    protected abstract void setCASMessage(String var1, String var2, Message var3) throws Exception;

    protected abstract void setCASMessage(String var1, byte[] var2, Message var3) throws Exception;

    protected abstract void setFreeCasMessage(Message var1, String var2, String var3) throws Exception;

    protected abstract void setStopMessage(Message var1, String var2) throws Exception;

    protected abstract void setCPCMessage(Message var1) throws Exception;

    public abstract void initialize(Map var1) throws ResourceInitializationException;

    protected abstract void cleanup() throws Exception;

    public abstract String deploy(String[] var1, Map var2) throws Exception;

    protected abstract String deploySpringContainer(String[] var1) throws ResourceInitializationException;

    protected abstract MessageSender getDispatcher();

    protected abstract void initializeConsumer(String var1, Connection var2) throws Exception;

    protected abstract SharedConnection validateConnection(String var1) throws Exception;

    protected abstract void dispatchFreeCasRequest(String var1, Message var2) throws Exception;

    protected void setBrokeryURI(String brokerURI) {
        this.brokerURI = brokerURI;
    }

    protected String getBrokerURI() {
        return this.brokerURI;
    }

    public void addStatusCallbackListener(UimaAsBaseCallbackListener aListener) {
        if (this.running) {
            throw new UIMA_IllegalStateException("jms_adapter_messages", "UIMAJMS_listener_added_after_initialize__WARNING", new Object[0]);
        }
        this.listeners.add(aListener);
    }

    public SerialFormat getSerialFormat() {
        return this.serialFormat;
    }

    protected void setSerialFormat(SerialFormat aSerialFormat) {
        this.serialFormat = aSerialFormat;
    }

    public TypeSystemImpl getRemoteTypeSystem() {
        return this.remoteTypeSystem;
    }

    protected void setRemoteTypeSystem(TypeSystemImpl remoteTypeSystem) {
        this.remoteTypeSystem = remoteTypeSystem;
    }

    protected String serializeCAS(CAS aCAS, XmiSerializationSharedData serSharedData) throws Exception {
        return this.uimaSerializer.serializeCasToXmi(aCAS, serSharedData);
    }

    protected String serializeCAS(CAS aCAS) throws Exception {
        XmiSerializationSharedData serSharedData = new XmiSerializationSharedData();
        return this.uimaSerializer.serializeCasToXmi(aCAS, serSharedData);
    }

    public void removeStatusCallbackListener(UimaAsBaseCallbackListener aListener) {
        this.listeners.remove(aListener);
    }

    public void onBeforeMessageSend(UimaASProcessStatus status) {
        try {
            for (int i = 0; this.listeners != null && i < this.listeners.size(); ++i) {
                UimaAsBaseCallbackListener statCL = (UimaAsBaseCallbackListener)this.listeners.get(i);
                statCL.onBeforeMessageSend(status);
            }
        }
        catch (Throwable t) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "onBeforeMessageSend", "uimaee_messages", "UIMAEE_exception__WARNING", t);
        }
    }

    public void onBeforeProcessCAS(UimaASProcessStatus status, String nodeIP, String pid) {
        for (int i = 0; this.listeners != null && i < this.listeners.size(); ++i) {
            UimaAsBaseCallbackListener statCL = (UimaAsBaseCallbackListener)this.listeners.get(i);
            try {
                statCL.onBeforeProcessCAS(status, nodeIP, pid);
                continue;
            }
            catch (Throwable t) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "onBeforeProcessCAS", "uimaee_messages", "UIMAEE_exception__WARNING", t);
            }
        }
    }

    public void onBeforeProcessMeta(String nodeIP, String pid) {
        for (int i = 0; this.listeners != null && i < this.listeners.size(); ++i) {
            UimaAsBaseCallbackListener statCL = (UimaAsBaseCallbackListener)this.listeners.get(i);
            try {
                statCL.onBeforeProcessMeta(nodeIP, pid);
                continue;
            }
            catch (Throwable t) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "onBeforeProcessMeta", "uimaee_messages", "UIMAEE_exception__WARNING", t);
            }
        }
    }

    public synchronized void setCollectionReader(CollectionReader aCollectionReader) throws ResourceInitializationException {
        if (this.initialized) {
            throw new ResourceInitializationException();
        }
        this.collectionReader = aCollectionReader;
    }

    private void addMessage(PendingMessage msg) {
        this.pendingMessageQueue.add(msg);
    }

    protected void acquireCpcReadySemaphore() {
        block2: {
            try {
                this.cpcReadySemaphore.acquire();
            }
            catch (InterruptedException e) {
                if (!UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) break block2;
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "collectionProcessingComplete", "jms_adapter_messages", "UIMAJMS_client_interrupted_while_acquiring_cpcReadySemaphore__WARNING", new Object[0]);
            }
        }
    }

    public synchronized void collectionProcessingComplete() throws ResourceProcessException {
        try {
            block14: {
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "collectionProcessingComplete", "jms_adapter_messages", "UIMAJMS_app_cpc_request_FINEST", new Object[0]);
                }
                if (this.outstandingCasRequests.get() > 0L) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "collectionProcessingComplete", "jms_adapter_messages", "UIMAJMS_in_cpc_INFO", new Object[]{this.outstandingCasRequests.get(), this.totalCasRequestsSentBetweenCpCs.get()});
                }
                if (this.totalCasRequestsSentBetweenCpCs.get() == 0L && !this.serviceDelegate.isAwaitingPingReply()) {
                    this.cpcReadySemaphore.release();
                }
                this.acquireCpcReadySemaphore();
                this.serviceDelegate.cancelDelegateTimer();
                if (!this.running) {
                    if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "collectionProcessingComplete", "jms_adapter_messages", "UIMAJMS_cpc_request_not_done_INFO", new Object[0]);
                    }
                    return;
                }
                ClientRequest requestToCache = new ClientRequest(uniqueIdentifier, this);
                requestToCache.setIsRemote(this.remoteService);
                requestToCache.setCPCRequest(true);
                requestToCache.setCpcTimeout(this.cpcTimeout);
                requestToCache.setEndpoint(this.getEndPointName());
                this.clientCache.put(uniqueIdentifier, requestToCache);
                PendingMessage msg = new PendingMessage(2002);
                if (this.cpcTimeout > 0) {
                    requestToCache.startTimer();
                    msg.put("CpcTimeout", String.valueOf(this.cpcTimeout));
                }
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "collectionProcessingComplete", "jms_adapter_messages", "UIMAJMS_started_cpc_request_timer_FINEST", new Object[0]);
                }
                this.addMessage(msg);
                try {
                    this.cpcReplySemaphore.acquire();
                }
                catch (InterruptedException ex) {
                    if (!UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) break block14;
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "collectionProcessingComplete", "jms_adapter_messages", "UIMAJMS_client_interrupted_while_acquiring_cpcReplySemaphore__WARNING", new Object[0]);
                }
            }
            this.waitForCpcReply();
            this.totalCasRequestsSentBetweenCpCs.set(0L);
            this.cancelTimer(uniqueIdentifier);
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "collectionProcessingComplete", "jms_adapter_messages", "UIMAJMS_cancelled_cpc_request_timer_FINEST", new Object[0]);
            }
            if (this.running) {
                for (int i = 0; this.listeners != null && i < this.listeners.size(); ++i) {
                    ((UimaASStatusCallbackListener)this.listeners.get(i)).collectionProcessComplete(null);
                }
            }
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    private void releaseCacheEntries() {
        Iterator it = ((ConcurrentHashMap.KeySetView)this.clientCache.keySet()).iterator();
        while (it.hasNext()) {
            ClientRequest entry = this.clientCache.get((String)it.next());
            if (entry == null || entry.getCAS() == null) continue;
            entry.getCAS().release();
        }
    }

    private void clearThreadRegistrar() {
        for (Long key : this.threadRegistrar.keySet()) {
            CasQueueEntry entry = this.threadRegistrar.get(key);
            if (entry == null) continue;
            entry.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() {
        Object object = this.stopMux;
        synchronized (object) {
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "stop", "jms_adapter_messages", "UIMAJMS_stopping_as_client_INFO", new Object[0]);
            }
            if (!this.running) {
                return;
            }
            this.exec.shutdownNow();
            this.casQueueProducerReady = false;
            if (this.serviceDelegate != null) {
                this.serviceDelegate.cancelDelegateTimer();
                this.serviceDelegate.cancelDelegateGetMetaTimer();
            }
            try {
                block25: {
                    try {
                        this.clearThreadRegistrar();
                        this.releaseCacheEntries();
                    }
                    catch (Exception ex) {
                        if (!UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) break block25;
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "stop", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)ex);
                    }
                }
                if (this.threadMonitorMap.size() > 0) {
                    Iterator it = ((ConcurrentHashMap.KeySetView)this.threadMonitorMap.keySet()).iterator();
                    while (it.hasNext()) {
                        long key = (Long)it.next();
                        ThreadMonitor threadMonitor = this.threadMonitorMap.get(key);
                        if (threadMonitor == null || threadMonitor.getMonitor() == null) continue;
                        threadMonitor.calledFromStopMethod();
                        threadMonitor.getMonitor().release();
                    }
                }
                this.cpcReadySemaphore.release();
                this.outstandingCasRequests.set(0L);
                this.cpcReplySemaphore.release();
                this.getMetaSemaphore.release();
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "stop", "jms_adapter_messages", "UIMAJMS_stopped_as_client_INFO", new Object[0]);
                }
                for (Map.Entry entry : this.springContainerRegistry.entrySet()) {
                    Object key = entry.getKey();
                    this.undeploy((String)key);
                }
                this.asynchManager = null;
                this.springContainerRegistry.clear();
                this.listeners.clear();
                this.clientCache.clear();
                this.threadQueue.clear();
                this.threadQueue.add(new CasQueueEntry());
                this.threadRegistrar.clear();
            }
            catch (Exception e) {
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "stop", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
            finally {
                if (this.shutdownHookThread != null) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveCASes() {
        Object object = this.casProducerMux;
        synchronized (object) {
            if (this.casQueueProducerReady) {
                return;
            }
            this.casQueueProducerReady = true;
        }
        new Thread(){

            @Override
            public void run() {
                while (BaseUIMAAsynchronousEngineCommon_impl.this.running) {
                    try {
                        CasQueueEntry entry = (CasQueueEntry)BaseUIMAAsynchronousEngineCommon_impl.this.threadQueue.take();
                        CAS cas = null;
                        long startTime = System.nanoTime();
                        if (!BaseUIMAAsynchronousEngineCommon_impl.this.running || BaseUIMAAsynchronousEngineCommon_impl.this.asynchManager == null) {
                            return;
                        }
                        cas = BaseUIMAAsynchronousEngineCommon_impl.this.remoteService ? BaseUIMAAsynchronousEngineCommon_impl.this.asynchManager.getNewCas("ApplicationCasPoolContext") : BaseUIMAAsynchronousEngineCommon_impl.this.asynchManager.getNewCas();
                        long waitingTime = System.nanoTime() - startTime;
                        BaseUIMAAsynchronousEngineCommon_impl.this.clientSideJmxStats.incrementTotalTimeWaitingForCas(waitingTime);
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "serveCASes.run()", "jms_adapter_messages", "UIMAJMS_new_cas_FINEST", new Object[]{"Time Waiting for CAS", (double)waitingTime / 1000000.0});
                        }
                        if (BaseUIMAAsynchronousEngineCommon_impl.this.running) {
                            entry.setCas(cas);
                            continue;
                        }
                        return;
                    }
                    catch (Exception e) {
                        if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) continue;
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "serveCASes.run()", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                    }
                }
            }
        }.start();
    }

    public CAS getCAS() throws Exception {
        if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "getCAS", "jms_adapter_messages", "UIMAJMS_request_for_cas_FINEST", new Object[0]);
        }
        if (!this.running) {
            throw new RuntimeException("Uima AS Client Is Stopping");
        }
        if (!this.initialized) {
            throw new ResourceInitializationException();
        }
        if (!this.casQueueProducerReady) {
            this.serveCASes();
        }
        CasQueueEntry entry = this.getQueueEntry(Thread.currentThread().getId());
        this.threadQueue.add(entry);
        if (entry != null && this.running) {
            CAS cas = null;
            cas = entry.getCas();
            if (cas != null && this.running) {
                return cas;
            }
        }
        return null;
    }

    private CasQueueEntry getQueueEntry(long aThreadId) {
        CasQueueEntry entry = null;
        if (this.threadRegistrar.containsKey(aThreadId)) {
            entry = this.threadRegistrar.get(aThreadId);
        } else {
            entry = new CasQueueEntry();
            this.threadRegistrar.put(aThreadId, entry);
        }
        return entry;
    }

    protected void reset() {
    }

    protected void sendMetaRequest() throws Exception {
        PendingMessage msg = new PendingMessage(2001);
        ClientRequest requestToCache = new ClientRequest(uniqueIdentifier, this);
        requestToCache.setIsRemote(this.remoteService);
        requestToCache.setMetaRequest(true);
        requestToCache.setMetadataTimeout(this.metadataTimeout);
        requestToCache.setEndpoint(this.getEndPointName());
        this.clientCache.put(uniqueIdentifier, requestToCache);
        this.addMessage(msg);
    }

    protected void waitForCpcReply() {
        try {
            this.cpcReplySemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.cpcReplySemaphore.release();
        }
    }

    protected void waitForMetadataReply() {
        try {
            this.getMetaSemaphore.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String getPerformanceReport() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process() throws ResourceProcessException {
        if (!this.initialized) {
            throw new ResourceProcessException();
        }
        if (this.collectionReader == null) {
            throw new ResourceProcessException();
        }
        if (!this.casQueueProducerReady) {
            this.serveCASes();
        }
        CAS cas = null;
        boolean hasNext = true;
        while (this.initialized && this.running) {
            try {
                hasNext = this.collectionReader.hasNext();
                if (!hasNext) break;
                cas = this.getCAS();
                this.collectionReader.getNext(cas);
                String targetStringSelector = System.getProperty("TargetServiceId");
                if (targetStringSelector != null && targetStringSelector.trim().length() > 0) {
                    this.sendCAS(cas, targetStringSelector);
                    continue;
                }
                this.sendCAS(cas);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ResourceProcessException((Throwable)e);
            }
        }
        if (!hasNext) {
            Object mObject = new Object();
            while (this.running && this.serviceDelegate.getCasPendingReplyListSize() > 0) {
                Object object = mObject;
                synchronized (object) {
                    try {
                        mObject.wait(100L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new ResourceProcessException((Throwable)e);
                    }
                }
            }
            this.collectionProcessingComplete();
        }
    }

    protected ConcurrentHashMap<String, ClientRequest> getCache() {
        return this.clientCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendCAS(CAS aCAS, ClientRequest requestToCache, String targetServiceId) throws ResourceProcessException {
        Object object = this.sendMux;
        synchronized (object) {
            if (requestToCache == null) {
                throw new ResourceProcessException((Throwable)new Exception("Invalid Process Request. Cache Entry is Null"));
            }
            String casReferenceId = requestToCache.getCasReferenceId();
            if (targetServiceId != null) {
                requestToCache.setTargetServiceId(targetServiceId);
            }
            try {
                SharedConnection sharedConnection;
                if (!this.running) {
                    if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "sendCAS", "jms_adapter_messages", "UIMAJMS_not_sending_cas_INFO", new Object[]{"Asynchronous Client is Stopping"});
                    }
                    return null;
                }
                this.clientCache.put(casReferenceId, requestToCache);
                PendingMessage msg = new PendingMessage(2000);
                long t1 = System.nanoTime();
                switch (this.serialFormat) {
                    case XMI: {
                        XmiSerializationSharedData serSharedData = new XmiSerializationSharedData();
                        String serializedCAS = this.serializeCAS(aCAS, serSharedData);
                        msg.put("CAS", serializedCAS);
                        if (!this.remoteService) break;
                        requestToCache.setCAS(serializedCAS);
                        requestToCache.setXmiSerializationSharedData(serSharedData);
                        break;
                    }
                    case BINARY: {
                        byte[] serializedBinaryCAS = this.uimaSerializer.serializeCasToBinary(aCAS);
                        msg.put("CAS", serializedBinaryCAS);
                        break;
                    }
                    case COMPRESSED_FILTERED: {
                        BinaryCasSerDes6 bcs = new BinaryCasSerDes6((AbstractCas)aCAS, this.getRemoteTypeSystem());
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                        bcs.serialize((Object)baos);
                        requestToCache.setCompress6ReuseInfo(bcs.getReuseInfo());
                        msg.put("CAS", baos.toByteArray());
                        break;
                    }
                    default: {
                        throw new UIMARuntimeException((Throwable)new Exception("Internal Error"));
                    }
                }
                requestToCache.setCAS(aCAS);
                requestToCache.setSerializationTime(System.nanoTime() - t1);
                msg.put("CasReference", casReferenceId);
                requestToCache.setIsRemote(this.remoteService);
                requestToCache.setEndpoint(this.getEndPointName());
                requestToCache.setProcessTimeout(this.processTimeout);
                requestToCache.clearTimeoutException();
                if (this.serviceDelegate.getState() == 2) {
                    sharedConnection = this.lookupConnection(this.getBrokerURI());
                    if (sharedConnection != null && !this.serviceDelegate.isAwaitingPingReply() && sharedConnection.isOpen()) {
                        this.serviceDelegate.setAwaitingPingReply();
                        this.serviceDelegate.addCasToPendingDispatchList(requestToCache.getCasReferenceId(), aCAS.hashCode(), this.timerPerCAS);
                        if (this.cpcReadySemaphore.availablePermits() > 0) {
                            this.acquireCpcReadySemaphore();
                        }
                        this.sendMetaRequest();
                        this.serviceDelegate.startGetMetaRequestTimer(casReferenceId);
                        if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "sendCAS", "jms_adapter_messages", "UIMAJMS_client_sending_ping__FINE", new Object[]{this.serviceDelegate.getKey()});
                        }
                        return casReferenceId;
                    }
                    if (!requestToCache.isSynchronousInvocation() && !sharedConnection.isOpen()) {
                        BrokerConnectionException exception = new BrokerConnectionException("Unable To Deliver CAS:" + requestToCache.getCasReferenceId() + " To Destination. Connection To Broker " + this.getBrokerURI() + " Has Been Lost");
                        this.handleException(exception, requestToCache.getCasReferenceId(), null, requestToCache, true);
                        return casReferenceId;
                    }
                    this.serviceDelegate.addCasToPendingDispatchList(requestToCache.getCasReferenceId(), aCAS.hashCode(), this.timerPerCAS);
                    return casReferenceId;
                }
                sharedConnection = this.lookupConnection(this.getBrokerURI());
                if (sharedConnection != null && !sharedConnection.isOpen()) {
                    if (requestToCache != null && !requestToCache.isSynchronousInvocation() && aCAS != null) {
                        aCAS.release();
                    }
                    throw new ResourceProcessException((Throwable)new BrokerConnectionException("Unable To Deliver Message To Destination. Connection To Broker " + sharedConnection.getBroker() + " Has Been Lost"));
                }
                this.outstandingCasRequests.incrementAndGet();
                this.totalCasRequestsSentBetweenCpCs.incrementAndGet();
                this.addMessage(msg);
            }
            catch (ResourceProcessException e) {
                this.clientCache.remove(casReferenceId);
                throw e;
            }
            catch (Exception e) {
                this.clientCache.remove(casReferenceId);
                throw new ResourceProcessException((Throwable)e);
            }
            return casReferenceId;
        }
    }

    public boolean delayCasIfDelegateInTimedOutState(String aCasReferenceId, long casHashcode) throws AsynchAEException {
        if (this.serviceDelegate != null && this.serviceDelegate.getState() == 2) {
            this.serviceDelegate.addCasToPendingDispatchList(aCasReferenceId, casHashcode, this.timerPerCAS);
            return true;
        }
        return false;
    }

    private ClientRequest produceNewClientRequestObject() {
        String casReferenceId = this.idGenerator.nextId();
        return new ClientRequest(casReferenceId, this);
    }

    public synchronized String sendCAS(CAS aCAS) throws ResourceProcessException {
        if (!this.running) {
            throw new ResourceProcessException((Throwable)new UimaEEServiceException("Uima AS Client Has Been Stopped. Rejecting Request to Process CAS"));
        }
        return this.sendCAS(aCAS, this.produceNewClientRequestObject(), null);
    }

    public synchronized String sendCAS(CAS aCAS, String targetServiceId) throws ResourceProcessException {
        if (!this.running) {
            throw new ResourceProcessException((Throwable)new UimaEEServiceException("Uima AS Client Has Been Stopped. Rejecting Request to Process CAS"));
        }
        return this.sendCAS(aCAS, this.produceNewClientRequestObject(), targetServiceId);
    }

    protected void handleCollectionProcessCompleteReply(Message message) throws Exception {
        int payload = message.getIntProperty("Payload");
        try {
            if (1003 == payload) {
                ProcessTrace_impl pt = new ProcessTrace_impl();
                UimaASProcessStatusImpl status = new UimaASProcessStatusImpl((ProcessTrace)pt);
                Exception exception = this.retrieveExceptionFromMessage(message);
                status.addEventStatus("CpC", "Failed", (Throwable)exception);
                this.notifyListeners(null, (EntityProcessStatus)status, 2002);
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleCollectionProcessCompleteReply", "jms_adapter_messages", "UIMAJMS_received_exception_msg_INFO", new Object[]{message.getStringProperty("MessageFrom"), this.getBrokerURI(), message.getStringProperty("CasReference"), exception});
                }
            } else {
                this.cleanup();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.cpcReplySemaphore.release();
        }
    }

    protected void handleMetadataReply(Message message) throws Exception {
        this.serviceDelegate.cancelDelegateGetMetaTimer();
        this.serviceDelegate.setState(1);
        if (message.getJMSReplyTo() != null) {
            this.serviceDelegate.setFreeCasDestination(message.getJMSReplyTo());
        }
        if (this.serviceDelegate.isAwaitingPingReply()) {
            System.out.println("------------------------ Client Received GetMeta Ping Reply");
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleMetadataReply", "jms_adapter_messages", "UIMAJMS_rcvd_ping_reply__INFO", new Object[]{message.getStringProperty("MessageFrom"), message.getStringProperty("ServerIP")});
            }
            this.serviceDelegate.resetAwaitingPingReply();
            String casReferenceId = null;
            if (this.serviceDelegate.getCasPendingReplyListSize() > 0 || this.serviceDelegate.getCasPendingDispatchListSize() > 0) {
                this.serviceDelegate.restartTimerForOldestCasInOutstandingList();
                while (this.serviceDelegate.getState() == 1 && (casReferenceId = this.serviceDelegate.removeOldestFromPendingDispatchList()) != null) {
                    ClientRequest cachedRequest = this.clientCache.get(casReferenceId);
                    if (cachedRequest == null) continue;
                    if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleMetadataReply", "jms_adapter_messages", "UIMAJMS_dispatch_delayed_cas__INFO", new Object[]{casReferenceId, String.valueOf(cachedRequest.cas.hashCode())});
                    }
                    this.sendCAS(cachedRequest.getCAS(), cachedRequest, null);
                }
            } else {
                ProcessTrace_impl pt = new ProcessTrace_impl();
                UimaASProcessStatusImpl status = new UimaASProcessStatusImpl((ProcessTrace)pt);
                this.notifyListeners(null, (EntityProcessStatus)status, 2001);
            }
            return;
        }
        int payload = message.getIntProperty("Payload");
        this.removeFromCache(uniqueIdentifier);
        try {
            if (1003 == payload) {
                ProcessTrace_impl pt = new ProcessTrace_impl();
                UimaASProcessStatusImpl status = new UimaASProcessStatusImpl((ProcessTrace)pt);
                Exception exception = this.retrieveExceptionFromMessage(message);
                this.clientSideJmxStats.incrementMetaErrorCount();
                status.addEventStatus("GetMeta", "Failed", (Throwable)exception);
                this.notifyListeners(null, (EntityProcessStatus)status, 2001);
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleMetadataReply", "jms_adapter_messages", "UIMAJMS_received_exception_msg_INFO", new Object[]{message.getStringProperty("MessageFrom"), this.getBrokerURI(), message.getStringProperty("CasReference"), exception});
                }
                this.abort = true;
                this.initialized = false;
            } else {
                if (!message.propertyExists("Serialization")) {
                    if (this.getSerialFormat() != SerialFormat.XMI) {
                        this.setSerialFormat(SerialFormat.XMI);
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleMetadataReply", "jms_adapter_messages", "UIMAJMS_client_serialization_ovveride__WARNING", new Object[0]);
                    }
                } else {
                    int c = message.getIntProperty("Serialization");
                    if (this.getSerialFormat() != SerialFormat.XMI) {
                        this.setSerialFormat(c == 0x1000000 ? SerialFormat.XMI : (c == 0x1000001 ? SerialFormat.BINARY : SerialFormat.COMPRESSED_FILTERED));
                    }
                }
                String meta = ((TextMessage)message).getText();
                ByteArrayInputStream bis = new ByteArrayInputStream(meta.getBytes());
                XMLInputSource in1 = new XMLInputSource((InputStream)bis, null);
                this.resourceMetadata = (ProcessingResourceMetaData)UIMAFramework.getXMLParser().parseResourceMetaData(in1);
                if (!this.brokerURI.startsWith("vm:")) {
                    this.setRemoteTypeSystem(AggregateAnalysisEngineController_impl.getTypeSystemImpl((ProcessingResourceMetaData)this.resourceMetadata));
                }
                this.casMultiplierDelegate = this.resourceMetadata.getOperationalProperties().getOutputsNewCASes();
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "handleMetadataReply", "jms_adapter_messages", "UIMAJMS_handling_meta_reply_FINEST", new Object[]{message.getStringProperty("MessageFrom"), meta});
                }
                if (this.running && this.asynchManager != null) {
                    this.asynchManager.addMetadata(this.resourceMetadata);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.getMetaSemaphore.release();
        }
    }

    protected void notifyListeners(CAS aCAS, EntityProcessStatus aStatus, int aCommand, List<AnalysisEnginePerformanceMetrics> ml) {
        if (aCommand == 2000) {
            ((UimaASProcessStatusImpl)aStatus).setPerformanceMetrics(ml);
            for (int i = 0; this.listeners != null && i < this.listeners.size(); ++i) {
                UimaAsBaseCallbackListener statCL = (UimaAsBaseCallbackListener)this.listeners.get(i);
                statCL.entityProcessComplete(aCAS, aStatus);
            }
        }
    }

    protected void notifyListeners(CAS aCAS, EntityProcessStatus aStatus, int aCommand) {
        block5: for (int i = 0; this.listeners != null && i < this.listeners.size(); ++i) {
            UimaAsBaseCallbackListener statCL = (UimaAsBaseCallbackListener)this.listeners.get(i);
            switch (aCommand) {
                case 2001: {
                    statCL.initializationComplete(aStatus);
                    continue block5;
                }
                case 2002: {
                    statCL.collectionProcessComplete(aStatus);
                    continue block5;
                }
                case 2000: 
                case 2007: {
                    statCL.entityProcessComplete(aCAS, aStatus);
                }
            }
        }
    }

    protected void cancelTimer(String identifier) {
        ClientRequest request = null;
        if (this.clientCache.containsKey(identifier) && (request = this.clientCache.get(identifier)) != null) {
            request.cancelTimer();
        }
    }

    private boolean isException(Message message) throws Exception {
        if (!message.propertyExists("Payload")) {
            throw new InvalidMessageException("Message Does not Contain Payload property");
        }
        int payload = message.getIntProperty("Payload");
        return 1003 == payload;
    }

    private Exception retrieveExceptionFromMessage(Message message) throws Exception {
        Exception exception = null;
        try {
            if (message instanceof ObjectMessage && ((ObjectMessage)message).getObject() instanceof Exception) {
                exception = (Exception)((ObjectMessage)message).getObject();
            } else if (message instanceof TextMessage) {
                exception = new UimaEEServiceException(((TextMessage)message).getText());
            }
        }
        catch (Exception e) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "retrieveExceptionFromMessage", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            exception = new UimaEEServiceException("UIMA AS client is unable to de-serialize Exception from a remote service", (Throwable)e);
        }
        return exception;
    }

    private void handleProcessReplyFromSynchronousCall(ClientRequest cachedRequest, Message message) throws Exception {
        cachedRequest.setMessage(message);
        this.wakeUpSendThread(cachedRequest);
    }

    protected void wakeUpSendThread(ClientRequest cachedRequest) throws Exception {
        ThreadMonitor threadMonitor;
        if (this.threadMonitorMap.containsKey(cachedRequest.getThreadId()) && (threadMonitor = this.threadMonitorMap.get(cachedRequest.getThreadId())) != null) {
            cachedRequest.setReceivedProcessCasReply();
            threadMonitor.getMonitor().release();
        }
    }

    protected void handleServiceInfo(Message message) throws Exception {
        String casReferenceId = message.getStringProperty("CasReference");
        ClientRequest casCachedRequest = null;
        if (casReferenceId != null) {
            casCachedRequest = this.clientCache.get(casReferenceId);
        }
        try {
            if (casCachedRequest != null) {
                this.notifyApplication(casCachedRequest, (ProcessTrace)new ProcessTrace_impl(), casReferenceId, message.getStringProperty("InputCasReference"), message.getStringProperty("ServerIP"), message.getStringProperty("ProcessPID"));
                if (message.getJMSReplyTo() != null && this.serviceDelegate.isCasOutstanding(casReferenceId)) {
                    casCachedRequest.setFreeCasNotificationQueue(message.getJMSReplyTo());
                }
            } else {
                ClientRequest requestToCache = this.clientCache.get(uniqueIdentifier);
                if (requestToCache != null && requestToCache.isMetaRequest()) {
                    String nodeIP = message.getStringProperty("ServerIP");
                    String pid = message.getStringProperty("ProcessPID");
                    if (pid != null && nodeIP != null) {
                        this.onBeforeProcessMeta(nodeIP, pid);
                    }
                }
            }
        }
        catch (Exception e) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleServiceInfo", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
        }
    }

    protected void decrementOutstandingCasCounter() {
        long outstandingCasCount = this.outstandingCasRequests.decrementAndGet();
        if (outstandingCasCount == 0L) {
            this.cpcReadySemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyApplication(ClientRequest cachedRequest, ProcessTrace pt, String casReferenceId, String parentCasReferenceId, String hostIP, String processPID) {
        ClientRequest clientRequest = cachedRequest;
        synchronized (clientRequest) {
            if (!cachedRequest.receivedServiceACK) {
                cachedRequest.setReceivedServiceACK(true);
                cachedRequest.setHostIpProcessingCAS(hostIP);
                cachedRequest.setServicePID(processPID);
                UimaASProcessStatusImpl status = parentCasReferenceId != null && parentCasReferenceId.equals(cachedRequest.getCasReferenceId()) ? new UimaASProcessStatusImpl(pt, cachedRequest.getCAS(), casReferenceId, parentCasReferenceId) : new UimaASProcessStatusImpl(pt, cachedRequest.getCAS(), casReferenceId);
                try {
                    this.onBeforeProcessCAS((UimaASProcessStatus)status, cachedRequest.getHostIpProcessingCAS(), cachedRequest.getServicePID());
                }
                catch (Exception uex) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "notifyApplication", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)uex);
                }
            }
        }
    }

    protected void handleProcessReply(Message message, boolean doNotify, ProcessTrace pt) throws Exception {
        if (!this.running) {
            return;
        }
        int payload = -1;
        String casReferenceId = message.getStringProperty("CasReference");
        if (message.propertyExists("Payload")) {
            payload = message.getIntProperty("Payload");
        }
        ClientRequest cachedRequest = null;
        if (casReferenceId != null) {
            cachedRequest = this.clientCache.get(casReferenceId);
            if (cachedRequest != null && casReferenceId.equals(cachedRequest.getCasReferenceId())) {
                this.notifyApplication(cachedRequest, pt, casReferenceId, message.getStringProperty("InputCasReference"), message.getStringProperty("ServerIP"), message.getStringProperty("ProcessPID"));
                this.decrementOutstandingCasCounter();
            }
            this.serviceDelegate.removeCasFromOutstandingList(casReferenceId);
        }
        if (1003 == payload) {
            this.handleException(message, cachedRequest, true);
            return;
        }
        if (cachedRequest == null && !this.casMultiplierDelegate) {
            return;
        }
        if (casReferenceId == null) {
            return;
        }
        if (message instanceof TextMessage && UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "handleProcessReply", "jms_adapter_messages", "UIMAJMS_handling_process_reply_FINEST", new Object[]{message.getStringProperty("MessageFrom"), message.getStringProperty("CasReference"), message.toString() + ((TextMessage)message).getText()});
        }
        if (cachedRequest != null) {
            cachedRequest.setTimeWaitingForReply(System.nanoTime() - cachedRequest.getCASDepartureTime());
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "handleProcessReply", "jms_adapter_messages", "UIMAJMS_cas_reply_rcvd_FINE", new Object[]{casReferenceId, String.valueOf(cachedRequest.getCAS().hashCode())});
            }
            if (cachedRequest.isSynchronousInvocation()) {
                this.handleProcessReplyFromSynchronousCall(cachedRequest, message);
            } else {
                this.deserializeAndCompleteProcessingReply(casReferenceId, message, cachedRequest, pt, doNotify);
            }
        } else if (message.propertyExists("InputCasReference")) {
            int command = message.getIntProperty("Command");
            if (2008 != command) {
                this.handleProcessReplyFromCasMultiplier(message, casReferenceId, payload);
            }
        } else if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleProcessReply", "jms_adapter_messages", "UIMAJMS_received_expired_msg_INFO", new Object[]{message.getStringProperty("MessageFrom"), message.getStringProperty("CasReference")});
        }
    }

    private void handleProcessReplyFromCasMultiplier(Message message, String casReferenceId, int payload) throws Exception {
        String inputCasReferenceId;
        block10: {
            inputCasReferenceId = message.getStringProperty("InputCasReference");
            try {
                String nodeIP = message.getStringProperty("ServerIP");
                String pid = message.getStringProperty("ProcessPID");
                if (message.getStringProperty("TargetingSelector") != null) {
                    this.serviceDelegate.setFreeCasSelector(message.getStringProperty("TargetingSelector"));
                    System.out.println("+++++++++++++++++ Client Received Service Targeting Selector:" + message.getStringProperty("TargetingSelector"));
                }
                this.dispatchFreeCasRequest(casReferenceId, message);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) break block10;
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleProcessReplyFromCasMultiplier", "jms_adapter_messages", "UIMAJMS_error_while_sending_msg__WARNING", new Object[]{"Free Cas Temp Destination", e});
            }
        }
        ClientRequest inputCasCachedRequest = this.clientCache.get(inputCasReferenceId);
        if (inputCasCachedRequest == null) {
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleProcessReplyFromCasMultiplier", "jms_adapter_messages", "UIMAJMS_received_expired_msg_INFO", new Object[]{message.getStringProperty("MessageFrom"), message.getStringProperty("CasReference")});
            }
            return;
        }
        if (inputCasCachedRequest.isSynchronousInvocation()) {
            if (casReferenceId.equals(inputCasCachedRequest.getCasReferenceId())) {
                this.handleProcessReplyFromSynchronousCall(inputCasCachedRequest, message);
            } else {
                return;
            }
        }
        CAS cas = null;
        if (message instanceof TextMessage) {
            cas = this.deserializeCAS(((TextMessage)message).getText(), SHADOW_CAS_POOL);
        } else {
            long bodyLength = ((BytesMessage)message).getBodyLength();
            byte[] serializedCas = new byte[(int)bodyLength];
            ((BytesMessage)message).readBytes(serializedCas);
            cas = this.deserializeCAS(serializedCas, SHADOW_CAS_POOL);
        }
        this.completeProcessingReply(cas, casReferenceId, payload, true, message, inputCasCachedRequest, null);
    }

    private boolean isShutdownException(Exception exception) throws Exception {
        return exception != null && (exception instanceof ServiceShutdownException || exception.getCause() != null && exception.getCause() instanceof ServiceShutdownException);
    }

    protected void handleNonProcessException(Exception exception) throws Exception {
        ProcessTrace_impl pt = new ProcessTrace_impl();
        UimaASProcessStatusImpl status = new UimaASProcessStatusImpl((ProcessTrace)pt);
        this.clientSideJmxStats.incrementMetaErrorCount();
        status.addEventStatus("GetMeta", "Failed", (Throwable)exception);
        this.notifyListeners(null, (EntityProcessStatus)status, 2001);
    }

    protected void handleException(Exception exception, String casReferenceId, String inputCasReferenceId, ClientRequest cachedRequest, boolean doNotify) throws Exception {
        this.handleException(exception, casReferenceId, inputCasReferenceId, cachedRequest, doNotify, true);
    }

    protected void handleException(Exception exception, String casReferenceId, String inputCasReferenceId, ClientRequest cachedRequest, boolean doNotify, boolean rethrow) throws Exception {
        if (!this.isShutdownException(exception)) {
            this.clientSideJmxStats.incrementProcessErrorCount();
        }
        if (exception != null && cachedRequest != null) {
            cachedRequest.setException(exception);
            cachedRequest.setProcessException();
        }
        this.cpcReadySemaphore.release();
        if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleException", "jms_adapter_messages", "UIMAJMS_received_exception_msg_INFO", new Object[]{this.serviceDelegate.getComponentName(), this.getBrokerURI(), casReferenceId, exception});
        }
        try {
            if (doNotify) {
                ProcessTrace_impl pt = new ProcessTrace_impl();
                if (inputCasReferenceId != null) {
                    this.serviceDelegate.removeCasFromOutstandingList(inputCasReferenceId);
                } else if (casReferenceId != null) {
                    this.serviceDelegate.removeCasFromOutstandingList(casReferenceId);
                }
                UimaASProcessStatusImpl status = cachedRequest != null ? new UimaASProcessStatusImpl((ProcessTrace)pt, cachedRequest.getCAS(), casReferenceId, inputCasReferenceId) : new UimaASProcessStatusImpl((ProcessTrace)pt, null, casReferenceId, inputCasReferenceId);
                status.addEventStatus("Process", "Failed", (Throwable)exception);
                if (cachedRequest != null && !cachedRequest.isSynchronousInvocation() && cachedRequest.getCAS() != null) {
                    this.notifyListeners(cachedRequest.getCAS(), (EntityProcessStatus)status, 2000);
                } else {
                    this.notifyListeners(null, (EntityProcessStatus)status, 2000);
                }
                return;
            }
            if (rethrow) {
                throw new ResourceProcessException((Throwable)exception);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (cachedRequest != null) {
                if (cachedRequest.isSynchronousInvocation() && cachedRequest.isProcessException()) {
                    this.wakeUpSendThread(cachedRequest);
                }
                if (!cachedRequest.isSynchronousInvocation() && cachedRequest.getCAS() != null) {
                    cachedRequest.getCAS().release();
                }
            }
            this.removeFromCache(casReferenceId);
            this.serviceDelegate.removeCasFromOutstandingList(casReferenceId);
            this.decrementOutstandingCasCounter();
        }
    }

    protected void handleException(Message message, ClientRequest cachedRequest, boolean doNotify) throws Exception {
        Exception exception = this.retrieveExceptionFromMessage(message);
        String casReferenceId = message.getStringProperty("CasReference");
        String inputCasReferenceId = message.getStringProperty("InputCasReference");
        this.handleException(exception, casReferenceId, inputCasReferenceId, cachedRequest, doNotify);
    }

    private void dumpMetrics(List<AnalysisEnginePerformanceMetrics> ml, String casReferenceId) {
        StringBuffer sb = new StringBuffer();
        sb.append(">>>> Client performance metrics Deserialized by XStream CAS ID:").append(casReferenceId).append("\n\t");
        for (AnalysisEnginePerformanceMetrics met : ml) {
            sb.append("AE:").append(met.getUniqueName()).append(" AnalysisTime:").append(met.getAnalysisTime()).append("\n\t");
        }
        System.out.println(sb.toString());
    }

    private List<AnalysisEnginePerformanceMetrics> getMetrics(String metrics, String casReferenceId, boolean dump) {
        if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "getMetrics", "jms_adapter_messages", "UIMAJMS_dump_metrics__FINEST", new Object[]{casReferenceId, metrics});
        }
        List ml = UimaSerializer.deserializePerformanceMetrics((String)metrics);
        if (dump) {
            this.dumpMetrics(ml, casReferenceId);
        }
        return ml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeProcessingReply(CAS cas, String casReferenceId, int payload, boolean doNotify, Message message, ClientRequest cachedRequest, ProcessTrace pt) throws Exception {
        if (1000 == payload || 1006 == payload || 1001 == payload) {
            if (pt == null) {
                pt = new ProcessTrace_impl();
            }
            try {
                this.logTimingInfo(message, pt, cachedRequest);
                if (doNotify) {
                    String inputCasReferenceId = message.getStringProperty("InputCasReference");
                    UimaASProcessStatusImpl status = inputCasReferenceId != null && inputCasReferenceId.equals(cachedRequest.getCasReferenceId()) ? new UimaASProcessStatusImpl(pt, cas, casReferenceId, inputCasReferenceId) : new UimaASProcessStatusImpl(pt, cas, casReferenceId);
                    if (cachedRequest.getTargetServiceId() != null) {
                        status.setServiceTargetID(cachedRequest.getTargetServiceId());
                    }
                    if (message.propertyExists("CASPerComponentMetrics")) {
                        List<AnalysisEnginePerformanceMetrics> ml = this.getMetrics(message.getStringProperty("CASPerComponentMetrics"), casReferenceId, UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST));
                        this.notifyListeners(cas, (EntityProcessStatus)status, 2000, ml);
                    } else {
                        this.notifyListeners(cas, (EntityProcessStatus)status, 2000);
                    }
                } else if (casReferenceId != null && message.propertyExists("CASPerComponentMetrics") && (cachedRequest = this.clientCache.get(casReferenceId)) != null && cachedRequest.getComponentMetricsList() != null) {
                    List<AnalysisEnginePerformanceMetrics> ml = this.getMetrics(message.getStringProperty("CASPerComponentMetrics"), casReferenceId, false);
                    cachedRequest.getComponentMetricsList().clear();
                    cachedRequest.getComponentMetricsList().addAll(ml);
                    if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                        this.dumpMetrics(cachedRequest.getComponentMetricsList(), casReferenceId);
                    }
                }
            }
            finally {
                if (this.remoteService && !cachedRequest.isSynchronousInvocation() && cas != null) {
                    cas.release();
                }
                this.removeFromCache(casReferenceId);
            }
        }
    }

    private void logTimingInfo(Message message, ProcessTrace pt, ClientRequest cachedRequest) throws Exception {
        String casReferenceId;
        this.clientSideJmxStats.incrementTotalNumberOfCasesProcessed();
        if (message.getStringProperty("CasReference") != null && this.clientCache.containsKey(casReferenceId = message.getStringProperty("CasReference"))) {
            ClientRequest cacheEntry = this.clientCache.get(casReferenceId);
            if (cacheEntry == null) {
                return;
            }
            long timeWaitingForReply = cacheEntry.getTimeWaitingForReply();
            this.clientSideJmxStats.incrementTotalTimeWaitingForReply(timeWaitingForReply);
            long responseLatencyTime = cacheEntry.getSerializationTime() + timeWaitingForReply + cacheEntry.getDeserializationTime();
            this.clientSideJmxStats.incrementTotalResponseLatencyTime(responseLatencyTime);
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "handleProcessReply", "jms_adapter_messages", "UIMAJMS_timer_detail_FINEST", new Object[]{message.getStringProperty("MessageFrom"), "Total Time Waiting For Reply", Float.valueOf((float)timeWaitingForReply / 1000000.0f)});
            }
            pt.addEvent("UimaEE", "process", "Total Time Waiting For Reply", (int)(timeWaitingForReply / 1000000L), "");
        }
        if (message.propertyExists("TimeToSerializeCAS")) {
            long timeToSerializeCAS = message.getLongProperty("TimeToSerializeCAS");
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "handleProcessReply", "jms_adapter_messages", "UIMAJMS_timer_detail_FINEST", new Object[]{message.getStringProperty("MessageFrom"), "Time To Serialize Cas", Float.valueOf((float)timeToSerializeCAS / 1000000.0f)});
            }
            pt.addEvent("UimaEE", "process", "Time To Serialize Cas", (int)(timeToSerializeCAS / 1000000L), "");
            this.clientSideJmxStats.incrementTotalSerializationTime(timeToSerializeCAS += cachedRequest.getSerializationTime());
        }
        if (message.propertyExists("TimeToDeserializeCAS")) {
            long timeToDeserializeCAS = message.getLongProperty("TimeToDeserializeCAS");
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "handleProcessReply", "jms_adapter_messages", "UIMAJMS_timer_detail_FINEST", new Object[]{message.getStringProperty("MessageFrom"), "Time To Deserialize Cas", Float.valueOf((float)timeToDeserializeCAS / 1000000.0f)});
            }
            pt.addEvent("UimaEE", "process", "Time To Deserialize Cas", (int)(timeToDeserializeCAS / 1000000L), "");
            this.clientSideJmxStats.incrementTotalDeserializationTime(timeToDeserializeCAS += cachedRequest.getDeserializationTime());
        }
        if (message.propertyExists("TimeWaitingForCAS")) {
            long timeWaitingForCAS = message.getLongProperty("TimeWaitingForCAS");
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "handleProcessReply", "jms_adapter_messages", "UIMAJMS_timer_detail_FINEST", new Object[]{message.getStringProperty("MessageFrom"), "Time to Wait for CAS", Float.valueOf((float)timeWaitingForCAS / 1000000.0f)});
            }
            pt.addEvent("UimaEE", "process", "Time to Wait for CAS", (int)(timeWaitingForCAS / 1000000L), "");
        }
        if (message.propertyExists("TimeInService")) {
            long ttimeInService = message.getLongProperty("TimeInService");
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "handleProcessReply", "jms_adapter_messages", "UIMAJMS_timer_detail_FINEST", new Object[]{message.getStringProperty("MessageFrom"), "Time In Service", Float.valueOf((float)ttimeInService / 1000000.0f)});
            }
            pt.addEvent("UimaEE", "process", "Time In Service", (int)(ttimeInService / 1000000L), "");
        }
        if (message.propertyExists("TimeInAnalytic")) {
            long totaltimeInService = message.getLongProperty("TimeInAnalytic");
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "handleProcessReply", "jms_adapter_messages", "UIMAJMS_timer_detail_FINEST", new Object[]{message.getStringProperty("MessageFrom"), "Total Time In Service", Float.valueOf((float)totaltimeInService / 1000000.0f)});
            }
            pt.addEvent("UimaEE", "process", "Total Time In Service", (int)(totaltimeInService / 1000000L), "");
        }
        if (message.propertyExists("TimeInProcessCAS")) {
            long totaltimeInProcessCAS = message.getLongProperty("TimeInProcessCAS");
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "handleProcessReply", "jms_adapter_messages", "UIMAJMS_timer_detail_FINEST", new Object[]{message.getStringProperty("MessageFrom"), "Total Time In Process CAS", Float.valueOf((float)totaltimeInProcessCAS / 1000000.0f)});
            }
            float timeInMillis = (float)totaltimeInProcessCAS / 1000000.0f;
            pt.addEvent("UimaEE", "process", "Total Time In Process CAS", (int)timeInMillis, "");
            this.clientSideJmxStats.incrementTotalTimeToProcess(totaltimeInProcessCAS);
        }
        if (message.propertyExists("IdleTime")) {
            long totalIdletime = message.getLongProperty("IdleTime");
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "handleProcessReply", "jms_adapter_messages", "UIMAJMS_timer_detail_FINEST", new Object[]{message.getStringProperty("MessageFrom"), "Idle Time Waiting For CAS", Float.valueOf((float)totalIdletime / 1000000.0f)});
            }
            pt.addEvent("UimaEE", "process", "Idle Time Waiting For CAS", (int)(totalIdletime / 1000000L), "");
            this.clientSideJmxStats.incrementTotalIdleTime(totalIdletime);
        }
        if (message.propertyExists("ServerIP")) {
            pt.addEvent("UimaEE", "process", "Service IP", 0, message.getStringProperty("ServerIP"));
        }
    }

    protected void removeFromCache(String aCasReferenceId) {
        if (aCasReferenceId == null) {
            return;
        }
        this.clientCache.remove(aCasReferenceId);
    }

    protected CAS deserialize(String aSerializedCAS, CAS aCAS) throws Exception {
        XmiSerializationSharedData deserSharedData = new XmiSerializationSharedData();
        this.uimaSerializer.deserializeCasFromXmi(aSerializedCAS, aCAS, deserSharedData, true, -1);
        return aCAS;
    }

    protected CAS deserialize(String aSerializedCAS, CAS aCAS, XmiSerializationSharedData deserSharedData, boolean deltaCas) throws Exception {
        if (deltaCas) {
            this.uimaSerializer.deserializeCasFromXmi(aSerializedCAS, aCAS, deserSharedData, true, deserSharedData.getMaxXmiId(), AllowPreexistingFS.allow);
        } else {
            this.uimaSerializer.deserializeCasFromXmi(aSerializedCAS, aCAS, deserSharedData, true, -1);
        }
        return aCAS;
    }

    protected CAS deserialize(byte[] binaryData, ClientRequest cachedRequest) throws Exception {
        CAS cas = cachedRequest.getCAS();
        this.uimaSerializer.deserializeCasFromBinary(binaryData, cas);
        return cas;
    }

    protected CAS deserializeCAS(String aSerializedCAS, ClientRequest cachedRequest) throws Exception {
        CAS cas = cachedRequest.getCAS();
        return this.deserialize(aSerializedCAS, cas);
    }

    protected CAS deserializeCAS(byte[] aSerializedCAS, ClientRequest cachedRequest) throws Exception {
        CAS cas = cachedRequest.getCAS();
        BinaryCasSerDes6.ReuseInfo reuseInfo = cachedRequest.getCompress6ReuseInfo();
        ByteArrayInputStream bais = new ByteArrayInputStream(aSerializedCAS);
        if (reuseInfo != null) {
            Serialization.deserializeCAS((CAS)cas, (InputStream)bais, null, (BinaryCasSerDes6.ReuseInfo)reuseInfo);
        } else {
            ((CASImpl)cas).reinit((InputStream)bais);
        }
        return cas;
    }

    protected CAS deserializeCAS(byte[] aSerializedCAS, CAS aCas) throws Exception {
        this.uimaSerializer.deserializeCasFromBinary(aSerializedCAS, aCas);
        return aCas;
    }

    protected CAS deserializeCAS(String aSerializedCAS, ClientRequest cachedRequest, boolean deltaCas) throws Exception {
        CAS cas = cachedRequest.getCAS();
        return this.deserialize(aSerializedCAS, cas, cachedRequest.getXmiSerializationSharedData(), deltaCas);
    }

    protected CAS deserializeCAS(String aSerializedCAS, String aCasPoolName) throws Exception {
        CAS cas = this.asynchManager.getNewCas(aCasPoolName);
        return this.deserialize(aSerializedCAS, cas);
    }

    protected CAS deserializeCAS(byte[] aSerializedCAS, String aCasPoolName) throws Exception {
        CAS cas = this.asynchManager.getNewCas(aCasPoolName);
        this.uimaSerializer.deserializeCasFromBinary(aSerializedCAS, cas);
        return cas;
    }

    public void onMessage(final Message message) {
        if (!this.running) {
            return;
        }
        this.exec.execute(new Runnable(){

            @Override
            public void run() {
                block15: {
                    try {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_received_msg_FINEST", new Object[]{message.getStringProperty("MessageFrom")});
                        }
                        if (!message.propertyExists("Command")) {
                            return;
                        }
                        int command = message.getIntProperty("Command");
                        if (2002 == command) {
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_received_cpc_reply_FINE", new Object[]{message.getStringProperty("MessageFrom")});
                            }
                            BaseUIMAAsynchronousEngineCommon_impl.this.handleCollectionProcessCompleteReply(message);
                        } else if (2001 == command) {
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_received_meta_reply_FINE", new Object[]{message.getStringProperty("MessageFrom")});
                            }
                            BaseUIMAAsynchronousEngineCommon_impl.this.handleMetadataReply(message);
                        } else if (2000 == command) {
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_received_process_reply_FINE", new Object[]{message.getStringProperty("MessageFrom")});
                            }
                            BaseUIMAAsynchronousEngineCommon_impl.this.handleProcessReply(message, true, null);
                        } else if (2008 == command) {
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_received_service_info_FINEST", new Object[]{message.getStringProperty("MessageFrom")});
                            }
                            BaseUIMAAsynchronousEngineCommon_impl.this.handleServiceInfo(message);
                        }
                    }
                    catch (Exception e) {
                        if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block15;
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "onMessage", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                    }
                }
            }
        });
    }

    public ProcessingResourceMetaData getMetaData() throws ResourceInitializationException {
        return this.resourceMetadata;
    }

    public String sendAndReceiveCAS(CAS aCAS) throws ResourceProcessException {
        return this.sendAndReceiveCAS(aCAS, null, null);
    }

    public String sendAndReceiveCAS(CAS aCAS, ProcessTrace pt) throws ResourceProcessException {
        return this.sendAndReceiveCAS(aCAS, pt, null, null);
    }

    public String sendAndReceiveCAS(CAS aCAS, List<AnalysisEnginePerformanceMetrics> componentMetricsList) throws ResourceProcessException {
        return this.sendAndReceiveCAS(aCAS, null, componentMetricsList, null);
    }

    public String sendAndReceiveCAS(CAS aCAS, List<AnalysisEnginePerformanceMetrics> componentMetricsList, String targetServiceId) throws ResourceProcessException {
        return this.sendAndReceiveCAS(aCAS, null, componentMetricsList, targetServiceId);
    }

    public String sendAndReceiveCAS(CAS aCAS, ProcessTrace pt, List<AnalysisEnginePerformanceMetrics> componentMetricsList, String targetServiceId) throws ResourceProcessException {
        if (!this.running) {
            throw new ResourceProcessException((Throwable)new Exception("Uima EE Client Not In Running State"));
        }
        if (!this.serviceDelegate.isSynchronousAPI()) {
            this.serviceDelegate.setSynchronousAPI();
        }
        String casReferenceId = null;
        this.sendAndReceiveCAS = aCAS;
        ThreadMonitor threadMonitor = null;
        if (this.threadMonitorMap.containsKey(Thread.currentThread().getId())) {
            threadMonitor = this.threadMonitorMap.get(Thread.currentThread().getId());
        } else {
            threadMonitor = new ThreadMonitor(Thread.currentThread().getId());
            this.threadMonitorMap.put(Thread.currentThread().getId(), threadMonitor);
        }
        ClientRequest cachedRequest = this.produceNewClientRequestObject();
        cachedRequest.setSynchronousInvocation();
        cachedRequest.setComponentMetricsList(componentMetricsList);
        if (threadMonitor != null && threadMonitor.getMonitor() != null) {
            try {
                threadMonitor.getMonitor().acquire();
            }
            catch (InterruptedException e) {
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "sendAndReceiveCAS", "jms_adapter_messages", "UIMAJMS_client_interrupted_INFO", new Object[]{casReferenceId, String.valueOf(aCAS.hashCode())});
                }
                this.serviceDelegate.cancelTimerForCasOrPurge(casReferenceId);
                throw new ResourceProcessException((Throwable)e);
            }
        }
        try {
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "sendAndReceiveCAS", "jms_adapter_messages", "UIMAJMS_cas_submitting_FINE", new Object[]{casReferenceId, String.valueOf(aCAS.hashCode()), Thread.currentThread().getId()});
            }
            casReferenceId = this.sendCAS(aCAS, cachedRequest, targetServiceId);
        }
        catch (ResourceProcessException e) {
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendAndReceiveCAS", "jms_adapter_messages", "UIMAJMS_exception__WARNING", new Object[]{e});
            }
            threadMonitor.getMonitor().release();
            this.removeFromCache(casReferenceId);
            throw e;
        }
        if (threadMonitor != null && threadMonitor.getMonitor() != null) {
            while (this.running) {
                try {
                    threadMonitor.getMonitor().acquire();
                    if (threadMonitor.wasCalledFromStopMethod()) {
                        throw new ResourceProcessException((Throwable)new UimaAsClientStoppingException("Client is stopping - sendAndReceive() has been interrupted"));
                    }
                    if (cachedRequest.isTimeoutException() || cachedRequest.isProcessException()) {
                        if (!UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) break;
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "sendAndReceiveCAS", "jms_adapter_messages", "UIMAJMS_process_exception_handler5__WARNING", new Object[]{String.valueOf(aCAS.hashCode()), Thread.currentThread().getId()});
                        break;
                    }
                    if (!this.running || this.serviceDelegate.getState() != 1 || !this.serviceDelegate.removeCasFromPendingDispatchList(casReferenceId)) break;
                    this.sendCAS(aCAS, cachedRequest, targetServiceId);
                }
                catch (InterruptedException e) {
                    if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "sendAndReceiveCAS", "jms_adapter_messages", "UIMAJMS_client_interrupted_INFO", new Object[]{Thread.currentThread().getId(), casReferenceId, String.valueOf(aCAS.hashCode())});
                    }
                    if (!this.serviceDelegate.removeCasFromPendingDispatchList(casReferenceId)) {
                        this.serviceDelegate.removeCasFromOutstandingList(casReferenceId);
                    }
                    this.serviceDelegate.cancelTimerForCasOrPurge(casReferenceId);
                    if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "sendAndReceiveCAS", "jms_adapter_messages", "UIMAJMS_client_canceled_timer_INFO", new Object[]{Thread.currentThread().getId(), casReferenceId, String.valueOf(aCAS.hashCode())});
                    }
                    this.removeFromCache(casReferenceId);
                    throw new ResourceProcessException((Throwable)e);
                }
                finally {
                    threadMonitor.getMonitor().release();
                }
            }
        }
        if (this.abort) {
            throw new ResourceProcessException((Throwable)new RuntimeException("Uima AS Client API Stopping"));
        }
        if (cachedRequest.isTimeoutException()) {
            String qName = "";
            try {
                qName = this.getEndPointName();
            }
            catch (Exception e) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendAndReceiveCAS", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
            throw new ResourceProcessException("jms_adapter_messages", "UIMAJMS_process_timeout_WARNING", new Object[]{qName, this.getBrokerURI(), cachedRequest.getHostIpProcessingCAS()}, (Throwable)new UimaASProcessCasTimeout("UIMA AS Client Timed Out Waiting for Reply From Service:" + qName + " Broker:" + this.getBrokerURI()));
        }
        if (cachedRequest.isProcessException()) {
            String qName = "";
            try {
                qName = this.getEndPointName();
            }
            catch (Exception e) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendAndReceiveCAS", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
            throw new ResourceProcessException("jms_adapter_messages", "UIMAJMS_received_exception_msg_INFO", new Object[]{qName, this.getBrokerURI(), casReferenceId}, (Throwable)cachedRequest.getException());
        }
        try {
            Message message = cachedRequest.getMessage();
            if (message != null) {
                this.deserializeAndCompleteProcessingReply(casReferenceId, message, cachedRequest, pt, false);
            }
        }
        catch (ResourceProcessException rpe) {
            throw rpe;
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
        return casReferenceId;
    }

    private void deserializeAndCompleteProcessingReply(String casReferenceId, Message message, ClientRequest cachedRequest, ProcessTrace pt, boolean doNotify) throws Exception {
        if (!this.running) {
            return;
        }
        int payload = message.getIntProperty("Payload");
        if (message.propertyExists("CasSequence")) {
            this.handleProcessReplyFromCasMultiplier(message, casReferenceId, payload);
        } else {
            long t1 = System.nanoTime();
            boolean deltaCas = false;
            if (message.propertyExists("SentDeltaCas")) {
                deltaCas = message.getBooleanProperty("SentDeltaCas");
            }
            CAS cas = null;
            if (message instanceof TextMessage) {
                cas = this.deserializeCAS(((TextMessage)message).getText(), cachedRequest, deltaCas);
            } else {
                long bodyLength = ((BytesMessage)message).getBodyLength();
                byte[] serializedCas = new byte[(int)bodyLength];
                ((BytesMessage)message).readBytes(serializedCas);
                cas = this.deserializeCAS(serializedCas, cachedRequest);
            }
            cachedRequest.setDeserializationTime(System.nanoTime() - t1);
            this.completeProcessingReply(cas, casReferenceId, payload, doNotify, message, cachedRequest, pt);
        }
    }

    protected void notifyOnTimout(CAS aCAS, String anEndpoint, int aTimeoutKind, String casReferenceId) {
        ProcessTrace_impl pt = new ProcessTrace_impl();
        UimaASProcessStatusImpl status = new UimaASProcessStatusImpl((ProcessTrace)pt, aCAS, casReferenceId);
        switch (aTimeoutKind) {
            case 1: {
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "notifyOnTimout", "jms_adapter_messages", "UIMAJMS_meta_timeout_WARNING", new Object[]{anEndpoint});
                }
                status.addEventStatus("GetMeta", "Failed", (Throwable)new UimaASMetaRequestTimeout("UIMA AS Client Timed Out Waiting For GetMeta Reply From a Service On Queue:" + anEndpoint));
                this.notifyListeners(null, (EntityProcessStatus)status, 2001);
                this.abort = true;
                this.getMetaSemaphore.release();
                break;
            }
            case 4: {
                ClientRequest anyCasRequest;
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "notifyOnTimout", "jms_adapter_messages", "UIMAJMS_meta_timeout_WARNING", new Object[]{anEndpoint});
                }
                status.addEventStatus("Ping", "Failed", (Throwable)new UimaASPingTimeout("UIMA AS Client Timed Out Waiting For Ping Reply From a Service On Queue:" + anEndpoint));
                this.notifyListeners(null, (EntityProcessStatus)status, 2007);
                if (!this.clientCache.isEmpty() && (anyCasRequest = this.clientCache.elements().nextElement()).getCAS() != null) {
                    anyCasRequest.getCAS().release();
                }
                this.abort = true;
                break;
            }
            case 2: {
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "notifyOnTimout", "jms_adapter_messages", "UIMAJMS_cpc_timeout_INFO", new Object[]{anEndpoint});
                }
                status.addEventStatus("CpC", "Failed", (Throwable)new UimaASCollectionProcessCompleteTimeout("UIMA AS Client Timed Out Waiting For CPC Reply From a Service On Queue:" + anEndpoint));
                this.cpcReplySemaphore.release();
                this.notifyListeners(null, (EntityProcessStatus)status, 2002);
                break;
            }
            case 3: {
                String nextOutstandingCasReferenceId;
                if (casReferenceId == null) break;
                ClientRequest cachedRequest = this.clientCache.get(casReferenceId);
                if (cachedRequest != null) {
                    if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "notifyOnTimout", "jms_adapter_messages", "UIMAJMS_process_timeout_WARNING", new Object[]{anEndpoint, this.getBrokerURI(), cachedRequest.getHostIpProcessingCAS()});
                    }
                } else {
                    if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "notifyOnTimout", "jms_adapter_messages", "UIMAJMS_received_expired_msg_INFO", new Object[]{anEndpoint, casReferenceId});
                    }
                    return;
                }
                cachedRequest.setTimeWaitingForReply(System.nanoTime() - cachedRequest.getCASDepartureTime());
                cachedRequest.setTimeoutException();
                if (cachedRequest.isSynchronousInvocation()) {
                    ThreadMonitor threadMonitor;
                    if (this.threadMonitorMap.containsKey(cachedRequest.getThreadId()) && (threadMonitor = this.threadMonitorMap.get(cachedRequest.getThreadId())) != null) {
                        threadMonitor.getMonitor().release();
                        cachedRequest.setReceivedProcessCasReply();
                    }
                } else {
                    if (this.serviceDelegate.isPingTimeout()) {
                        this.exc = new UimaASProcessCasTimeout((Throwable)new UimaASPingTimeout("UIMA AS Client Ping Time While Waiting For Reply From a Service On Queue:" + anEndpoint));
                        this.serviceDelegate.resetPingTimeout();
                    } else {
                        this.exc = new UimaASProcessCasTimeout("UIMA AS Client Timed Out Waiting For CAS:" + casReferenceId + " Reply From a Service On Queue:" + anEndpoint);
                    }
                    status.addEventStatus("Process", "Failed", (Throwable)this.exc);
                    this.notifyListeners(aCAS, (EntityProcessStatus)status, 2000);
                }
                boolean isSynchronousCall = cachedRequest.isSynchronousInvocation();
                cachedRequest.removeEntry(casReferenceId);
                this.serviceDelegate.removeCasFromOutstandingList(casReferenceId);
                long outstandingCasCount = this.outstandingCasRequests.decrementAndGet();
                if (outstandingCasCount <= 0L) {
                    this.cpcReadySemaphore.release();
                }
                System.out.println("isSynchronousCall=" + isSynchronousCall + " serviceDelegate.getCasPendingReplyListSize()=" + this.serviceDelegate.getCasPendingReplyListSize());
                if (isSynchronousCall || this.serviceDelegate.getCasPendingReplyListSize() <= 0 || (nextOutstandingCasReferenceId = this.serviceDelegate.getOldestCasIdFromOutstandingList()) == null || (cachedRequest = this.clientCache.get(nextOutstandingCasReferenceId)) == null || cachedRequest.getCAS() == null) break;
                try {
                    System.out.println("Sending CAS Again");
                    this.sendCAS(cachedRequest.getCAS());
                    break;
                }
                catch (Exception e) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "notifyOnTimout", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
        }
    }

    protected MessageProducer getMessageProducer(Destination destination) throws Exception {
        return null;
    }

    protected void onProducerInitialized() {
        this.producerInitialized = true;
    }

    public boolean connectionOpen() {
        SharedConnection sharedConnection = this.lookupConnection(this.getBrokerURI());
        if (sharedConnection != null) {
            return sharedConnection.isConnectionValid();
        }
        return false;
    }

    public boolean recoverSharedConnectionIfClosed() {
        if (!this.connectionOpen()) {
            SharedConnection sharedConnection = this.lookupConnection(this.getBrokerURI());
            while (sharedConnection != null && this.running) {
                try {
                    sharedConnection.retryConnectionUntilSuccessfull();
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (this.running && sharedConnection.getClientCount() > 0) {
                this.getDispatcher().setConnection(sharedConnection.getConnection());
                this.serviceDelegate.setAwaitingPingReply();
                try {
                    this.sendMetaRequest();
                    String cid = this.serviceDelegate.getOldestCasIdFromOutstandingList();
                    if (cid != null) {
                        this.serviceDelegate.startGetMetaRequestTimer(cid);
                    } else {
                        this.serviceDelegate.startGetMetaRequestTimer();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    public void onException(Exception aFailure, String aDestination) {
        if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "onException", "jms_adapter_messages", "UIMAJMS_error_while_sending_msg__WARNING", new Object[]{aDestination, aFailure});
        }
        try {
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setReleaseCASMessage(TextMessage msg, String aCasReferenceId) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SharedConnection lookupConnection(String brokerUrl) {
        SharedConnection sharedConnection = null;
        try {
            if (sharedConnections.containsKey(brokerUrl)) {
                return sharedConnections.get(brokerUrl);
            }
            boolean first = true;
            while (this.running) {
                try {
                    this.producerInitialized = false;
                    sharedConnection = this.validateConnection(brokerUrl);
                    sharedConnection.retryConnectionUntilSuccessfull();
                    break;
                }
                catch (Exception e) {
                    Object monitor = new Object();
                    try {
                        Object object = monitor;
                        synchronized (object) {
                            if (first) {
                                first = false;
                                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "onException", "jms_adapter_messages", "UIMAJMS_retrying_jms_connection__WARNING", new Object[]{brokerUrl});
                                }
                            }
                            monitor.wait(5000L);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        catch (Exception exx) {
            if (brokerUrl == null) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "onException", "jms_adapter_messages", "UIMAJMS_invalid_broker_url__WARNING", new Object[0]);
                Thread.dumpStack();
            }
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, SharedConnection> conn : sharedConnections.entrySet()) {
                sb.append("-- Shared Connection broker:" + conn.getKey() + " State:" + (Object)((Object)conn.getValue().getState()) + "\n");
            }
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "onException", "jms_adapter_messages", "UIMAJMS_shared_connections__INFO", new Object[]{sb.toString()});
            }
            throw new RuntimeException("Invalid State");
        }
        return sharedConnection;
    }

    public static class UimaASShutdownHook
    implements Runnable {
        UimaAsynchronousEngine asEngine = null;

        public UimaASShutdownHook(UimaAsynchronousEngine asEngine) {
            this.asEngine = asEngine;
        }

        @Override
        public void run() {
            try {
                if (this.asEngine != null) {
                    this.asEngine.stop();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static class UimaAsTransportListener
    implements TransportListener {
        public void onCommand(Object arg0) {
        }

        public void onException(IOException arg0) {
            System.out.println("!!!!!!!!!!!!!!!!!! UimaAsTransportListener.onException() - lost connectipon to broker");
        }

        public void transportInterupted() {
        }

        public void transportResumed() {
        }
    }

    public static class SharedConnection {
        private static final Class<SharedConnection> CLASS_NAME = SharedConnection.class;
        private volatile Connection connection;
        private volatile boolean stop = false;
        private ConnectionState state = ConnectionState.CLOSED;
        private Object stateMonitor = new Object();
        private Object mux = new Object();
        private String brokerURL;
        private ConnectionValidator connectionValidator;
        private ConnectionFactory connectionFactory = null;
        private Semaphore semaphore;
        private List<BaseUIMAAsynchronousEngineCommon_impl> clientList = new ArrayList<BaseUIMAAsynchronousEngineCommon_impl>();

        public void setConnectionFactory(ConnectionFactory cf) {
            this.connectionFactory = cf;
        }

        public Semaphore getSemaphore() {
            return this.semaphore;
        }

        public void setSemaphore(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        public SharedConnection(ConnectionFactory connectionFactory, String brokerURL) {
            this.connectionFactory = connectionFactory;
            this.brokerURL = brokerURL;
        }

        public String getBroker() {
            return this.brokerURL;
        }

        public void setConnectionValidator(ConnectionValidator validator) {
            this.connectionValidator = validator;
        }

        public boolean isOpen() {
            return this.state == ConnectionState.OPEN;
        }

        public boolean isConnectionValid() {
            if (this.connectionValidator == null) {
                return false;
            }
            return !this.connectionValidator.connectionClosedOrInvalid(this.connection);
        }

        public void create() throws Exception {
            if (this.connectionFactory == null) {
                throw new InstantiationException("UIMA AS Client Unable to Initialize SharedConnection Object. ConnectionFactory Has Not Been Provided");
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.connection = this.connectionFactory.createConnection();
            this.connection.setClientID("ClientListener-" + UIDGenerator.getGUID());
            this.state = ConnectionState.OPEN;
            this.stop = false;
        }

        private void reinitializeClientListeners() {
            for (BaseUIMAAsynchronousEngineCommon_impl client : this.clientList) {
                try {
                    client.initializeConsumer(this.brokerURL, this.connection);
                }
                catch (Exception e) {
                    if (!UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) continue;
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "reinitializeClientListeners", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
        }

        private void forceTimeout(List<Delegate.DelegateEntry> casList, BaseUIMAAsynchronousEngineCommon_impl client) throws Exception {
            MessageTimeoutException forcedTimeoutException = new MessageTimeoutException("Client Lost Connection To Broker. Forcing Timeout Exception");
            ArrayList<Delegate.DelegateEntry> copyOfPendingCasList = new ArrayList<Delegate.DelegateEntry>(casList);
            for (Delegate.DelegateEntry entry : copyOfPendingCasList) {
                try {
                    ClientRequest cachedRequest = client.clientCache.get(entry.getCasReferenceId());
                    client.handleException((Exception)forcedTimeoutException, entry.getCasReferenceId(), entry.getCasReferenceId(), cachedRequest, true);
                }
                catch (Exception e) {
                    if (!UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) continue;
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "forceTimeout", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void retryConnectionUntilSuccessfull() {
            if (this.isConnectionValid()) {
                return;
            }
            for (BaseUIMAAsynchronousEngineCommon_impl client : this.clientList) {
                client.state = ClientState.RECONNECTING;
                client.producerInitialized = false;
            }
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "retryConnectionUntilSuccessfull", "jms_adapter_messages", "UIMAJMS_client_lost_connection_to_broker__WARNING", new Object[]{this.brokerURL, this.stop});
            }
            boolean log = true;
            while (!this.stop) {
                BaseUIMAAsynchronousEngineCommon_impl c = null;
                if (this.clientList.size() == 0) break;
                c = this.clientList.get(0);
                if (!c.running) break;
                try {
                    this.create();
                    if (c != null && !c.running) break;
                    this.start();
                    if (c != null && !c.running) break;
                    this.reinitializeClientListeners();
                    Object object = this.stateMonitor;
                    synchronized (object) {
                        this.state = ConnectionState.OPEN;
                        break;
                    }
                }
                catch (Exception e) {
                    if (log) {
                        if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "retryConnectionUntilSuccessfull", "jms_adapter_messages", "UIMAJMS_client_connection_retry__INFO", new Object[]{this.brokerURL});
                        }
                        if (e instanceof JMSException && e.getMessage().indexOf("Connection refused") > 0) {
                            log = false;
                            System.out.println("Uima AS Client:" + e.getMessage() + " Retrying every 5 seconds until successfull");
                        } else {
                            e.printStackTrace();
                        }
                    }
                    Object object = this.stateMonitor;
                    synchronized (object) {
                        try {
                            this.stateMonitor.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (!this.stop && UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "retryConnectionUntilSuccessfull", "jms_adapter_messages", "UIMAJMS_client_recovered_connection__INFO", new Object[]{this.brokerURL});
            }
            for (BaseUIMAAsynchronousEngineCommon_impl client : this.clientList) {
                client.state = ClientState.RUNNING;
            }
        }

        public void stop() {
            this.stop = true;
        }

        public void start() throws Exception {
            if (this.connectionValidator != null && this.connectionValidator.connectionClosedOrInvalid(this.connection)) {
                throw new ResourceInitializationException((Throwable)new Exception("Unable to start JMS connection that is not open."));
            }
            this.connection.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectionState getState() {
            Object object = this.stateMonitor;
            synchronized (object) {
                return this.state;
            }
        }

        public synchronized Connection getConnection() {
            return this.connection;
        }

        public synchronized void setConnection(Connection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerClient(BaseUIMAAsynchronousEngineCommon_impl client) {
            Object object = this.mux;
            synchronized (object) {
                this.clientList.add(client);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterClient(BaseUIMAAsynchronousEngineCommon_impl client) {
            Object object = this.mux;
            synchronized (object) {
                this.clientList.remove(client);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getClientCount() {
            Object object = this.mux;
            synchronized (object) {
                return this.clientList.size();
            }
        }

        public boolean destroy() {
            return this.destroy(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean destroy(boolean doShutdown) {
            if (this.getClientCount() == 0 && this.connection != null && !((ActiveMQConnection)this.connection).isClosed() && !((ActiveMQConnection)this.connection).isClosing()) {
                try {
                    this.stop = true;
                    this.connection.stop();
                    this.connection.close();
                    Object closeMux = new Object();
                    while (!((ActiveMQConnection)this.connection).isClosed()) {
                        try {
                            Object object = closeMux;
                            synchronized (object) {
                                closeMux.wait(100L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    sharedConnections.remove(this.brokerURL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "destroy", "jms_adapter_messages", "UIMAJMS_client_connection_closed__INFO", new Object[0]);
                }
                return true;
            }
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "destroy", "jms_adapter_messages", "UIMAJMS_client_shared_connection_not_closed__INFO", new Object[]{this.getClientCount()});
            }
            return false;
        }

        public static enum ConnectionState {
            CLOSED,
            FAILED,
            WAITING_FOR_BROKER,
            OPEN;

        }
    }

    protected static class ThreadMonitor {
        private long threadId;
        private volatile boolean calledFromStop = false;
        private Semaphore monitor = new Semaphore(1);

        public ThreadMonitor(long aThreadId) {
            this.threadId = aThreadId;
        }

        public void calledFromStopMethod() {
            this.calledFromStop = true;
        }

        public boolean wasCalledFromStopMethod() {
            return this.calledFromStop;
        }

        public long getThreadId() {
            return this.threadId;
        }

        public Semaphore getMonitor() {
            return this.monitor;
        }
    }

    public class ClientRequest {
        private Timer timer = null;
        private long processTimeout = 0L;
        private long metadataTimeout = 0L;
        private long cpcTimeout = 0L;
        private String casReferenceId = null;
        private BaseUIMAAsynchronousEngineCommon_impl uimaEEEngine = null;
        private volatile boolean isSerializedCAS;
        private String serializedCAS;
        private CAS cas;
        private volatile boolean isMetaRequest = false;
        private volatile boolean isCPCRequest = false;
        private volatile boolean isRemote = true;
        private String endpoint;
        private long threadId = Thread.currentThread().getId();
        private Message message;
        private volatile boolean synchronousInvocation;
        private volatile boolean timeoutException;
        private long casDepartureTime;
        private long timeWaitingForReply;
        private long serializationTime;
        private long deserializationTime;
        private long metaTimeoutErrorCount;
        private long processTimeoutErrorCount;
        private long processErrorCount;
        private XmiSerializationSharedData sharedData;
        private BinaryCasSerDes6.ReuseInfo compress6ReuseInfo;
        private byte[] binaryCas = null;
        private volatile boolean isBinaryCas = false;
        private Exception exception;
        private volatile boolean processException;
        private Destination freeCasNotificationQueue = null;
        private String hostIpProcessingCAS;
        private String servicePID;
        List<AnalysisEnginePerformanceMetrics> componentMetricsList;
        private volatile boolean receivedServiceACK = false;
        private String targetServiceId;

        public String getTargetServiceId() {
            return this.targetServiceId;
        }

        public void setTargetServiceId(String serviceTargetId) {
            this.targetServiceId = serviceTargetId;
        }

        public boolean receivedServiceACK() {
            return this.receivedServiceACK;
        }

        public void setReceivedServiceACK(boolean receivedServiceACK) {
            this.receivedServiceACK = receivedServiceACK;
        }

        public String getServicePID() {
            return this.servicePID;
        }

        public void setServicePID(String servicePID) {
            this.servicePID = servicePID;
        }

        public List<AnalysisEnginePerformanceMetrics> getComponentMetricsList() {
            return this.componentMetricsList;
        }

        public void setComponentMetricsList(List<AnalysisEnginePerformanceMetrics> componentMetricsList) {
            this.componentMetricsList = componentMetricsList;
        }

        public String getHostIpProcessingCAS() {
            return this.hostIpProcessingCAS;
        }

        public void setHostIpProcessingCAS(String hostIpProcessingCAS) {
            this.hostIpProcessingCAS = hostIpProcessingCAS;
        }

        public Destination getFreeCasNotificationQueue() {
            return this.freeCasNotificationQueue;
        }

        public void setFreeCasNotificationQueue(Destination freeCasNotificationQueue) {
            this.freeCasNotificationQueue = freeCasNotificationQueue;
        }

        public boolean isProcessException() {
            return this.processException;
        }

        public void setProcessException() {
            this.processException = true;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public long getMetaTimeoutErrorCount() {
            return this.metaTimeoutErrorCount;
        }

        public void setMetaTimeoutErrorCount(long timeoutErrorCount) {
            this.metaTimeoutErrorCount = timeoutErrorCount;
        }

        public long getProcessTimeoutErrorCount() {
            return this.processTimeoutErrorCount;
        }

        public void setProcessTimeoutErrorCount(long timeoutErrorCount) {
            this.processTimeoutErrorCount = timeoutErrorCount;
        }

        public long getProcessErrorCount() {
            return this.processErrorCount;
        }

        public void setProcessErrorCount(long processErrorCount) {
            this.processErrorCount = processErrorCount;
        }

        public long getSerializationTime() {
            return this.serializationTime;
        }

        public void setSerializationTime(long serializationTime) {
            this.serializationTime = serializationTime;
        }

        public long getDeserializationTime() {
            return this.deserializationTime;
        }

        public void setDeserializationTime(long deserializationTime) {
            this.deserializationTime = deserializationTime;
        }

        public boolean isSynchronousInvocation() {
            return this.synchronousInvocation;
        }

        public void setSynchronousInvocation() {
            this.synchronousInvocation = true;
        }

        public boolean isTimeoutException() {
            return this.timeoutException;
        }

        public void setTimeoutException() {
            this.timeoutException = true;
        }

        public void clearTimeoutException() {
            this.timeoutException = false;
        }

        public Message getMessage() {
            return this.message;
        }

        public void setMessage(Message message) {
            this.message = message;
        }

        public ClientRequest(String aCasReferenceId, BaseUIMAAsynchronousEngineCommon_impl aUimaEEEngine) {
            this.uimaEEEngine = aUimaEEEngine;
            this.casReferenceId = aCasReferenceId;
            this.sharedData = null;
        }

        public String getCasReferenceId() {
            return this.casReferenceId;
        }

        public void setThreadId(long aThreadId) {
            this.threadId = aThreadId;
        }

        public long getThreadId() {
            return this.threadId;
        }

        public void setReceivedProcessCasReply() {
        }

        public void setMetadataTimeout(int aTimeout) {
            this.metadataTimeout = aTimeout;
        }

        public void setProcessTimeout(int aTimeout) {
            this.processTimeout = aTimeout;
        }

        public long getProcessTimeout() {
            return this.processTimeout;
        }

        public void setCpcTimeout(int aTimeout) {
            this.cpcTimeout = aTimeout;
        }

        public void setEndpoint(String anEndpoint) {
            this.endpoint = anEndpoint;
        }

        public void setIsRemote(boolean aRemote) {
            this.isRemote = aRemote;
        }

        public boolean isRemote() {
            return this.isRemote;
        }

        public void setCAS(CAS aCAS) {
            this.cas = aCAS;
        }

        public CAS getCAS() {
            return this.cas;
        }

        public void setCAS(String aSerializedCAS) {
            this.serializedCAS = aSerializedCAS;
            this.isSerializedCAS = true;
        }

        public void setBinaryCAS(byte[] aBinaryCas) {
            this.binaryCas = aBinaryCas;
            this.isBinaryCas = true;
        }

        public boolean isBinaryCAS() {
            return this.isBinaryCas;
        }

        public byte[] getBinaryCAS() {
            return this.binaryCas;
        }

        public String getXmiCAS() {
            return this.serializedCAS;
        }

        public void startTimer() {
            Date timeToRun = null;
            final ClientRequest _clientReqRef = this;
            timeToRun = this.isMetaRequest() ? new Date(System.currentTimeMillis() + this.metadataTimeout) : (this.isCPCRequest() ? new Date(System.currentTimeMillis() + this.cpcTimeout) : new Date(System.currentTimeMillis() + this.processTimeout));
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "startTimer", "jms_adapter_messages", "UIMAJMS_starting_timer_FINEST", new Object[]{this.endpoint});
            }
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    int timeOutKind;
                    CAS cas;
                    block12: {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "run", "jms_adapter_messages", "UIMAJMS_timer_expired_INFO", new Object[]{ClientRequest.this.endpoint, ClientRequest.this.casReferenceId});
                        }
                        cas = null;
                        if (ClientRequest.this.isSerializedCAS) {
                            try {
                                cas = ClientRequest.this.isRemote ? (ClientRequest.this.isBinaryCas ? BaseUIMAAsynchronousEngineCommon_impl.this.deserialize(ClientRequest.this.binaryCas, _clientReqRef) : BaseUIMAAsynchronousEngineCommon_impl.this.deserializeCAS(ClientRequest.this.serializedCAS, _clientReqRef)) : null;
                            }
                            catch (Exception e) {
                                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block12;
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "startTimer.run()", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                            }
                        }
                    }
                    if (ClientRequest.this.isMetaRequest()) {
                        timeOutKind = 1;
                        BaseUIMAAsynchronousEngineCommon_impl.this.initialized = false;
                        BaseUIMAAsynchronousEngineCommon_impl.this.abort = true;
                        ClientRequest.this.metaTimeoutErrorCount++;
                        BaseUIMAAsynchronousEngineCommon_impl.this.clientSideJmxStats.incrementMetaTimeoutErrorCount();
                        BaseUIMAAsynchronousEngineCommon_impl.this.getMetaSemaphore.release();
                    } else if (ClientRequest.this.isCPCRequest()) {
                        try {
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "startTimer.run()", "jms_adapter_messages", "UIMAJMS_client_timedout_waiting_for_CPC__WARNING", (Object)BaseUIMAAsynchronousEngineCommon_impl.this.getEndPointName());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        timeOutKind = 2;
                        BaseUIMAAsynchronousEngineCommon_impl.this.cpcReadySemaphore.release();
                    } else {
                        timeOutKind = 3;
                        ClientRequest.this.processTimeoutErrorCount++;
                        BaseUIMAAsynchronousEngineCommon_impl.this.clientSideJmxStats.incrementProcessTimeoutErrorCount();
                    }
                    System.out.println("calling notifyOnTimeout() - Got Process Timeout ");
                    ClientRequest.this.uimaEEEngine.notifyOnTimout(cas, ClientRequest.this.endpoint, timeOutKind, ClientRequest.this.getCasReferenceId());
                    ClientRequest.this.timer.cancel();
                    if (cas != null) {
                        cas.release();
                    }
                }
            }, timeToRun);
        }

        public void removeEntry(String aCasReferenceId) {
            if (this.uimaEEEngine.clientCache.containsKey(this.casReferenceId)) {
                this.uimaEEEngine.clientCache.remove(this.casReferenceId);
            }
        }

        public void cancelTimer() {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }

        public boolean isCPCRequest() {
            return this.isCPCRequest;
        }

        public void setCPCRequest(boolean isCPCRequest) {
            this.isCPCRequest = isCPCRequest;
        }

        public boolean isMetaRequest() {
            return this.isMetaRequest;
        }

        public void setMetaRequest(boolean isMetaRequest) {
            this.isMetaRequest = isMetaRequest;
        }

        public void setCASDepartureTime(long aDepartureTime) {
            this.casDepartureTime = aDepartureTime;
        }

        public long getCASDepartureTime() {
            return this.casDepartureTime;
        }

        public void setTimeWaitingForReply(long aTimeWaitingForReply) {
            this.timeWaitingForReply = aTimeWaitingForReply;
        }

        public long getTimeWaitingForReply() {
            return this.timeWaitingForReply;
        }

        public XmiSerializationSharedData getXmiSerializationSharedData() {
            return this.sharedData;
        }

        public void setXmiSerializationSharedData(XmiSerializationSharedData data) {
            this.sharedData = data;
        }

        public BinaryCasSerDes6.ReuseInfo getCompress6ReuseInfo() {
            return this.compress6ReuseInfo;
        }

        public void setCompress6ReuseInfo(BinaryCasSerDes6.ReuseInfo compress6ReuseInfo) {
            this.compress6ReuseInfo = compress6ReuseInfo;
        }
    }

    private static class CasQueueEntry {
        private CAS cas;
        private Semaphore semaphore = new Semaphore(1);

        public CasQueueEntry() {
            this.semaphore.acquireUninterruptibly();
        }

        public CAS getCas() {
            this.semaphore.acquireUninterruptibly();
            return this.cas;
        }

        public void setCas(CAS cas) {
            this.cas = cas;
            this.semaphore.release();
        }

        public void clear() {
            this.cas = null;
            this.semaphore.release();
        }
    }

    public static enum ClientState {
        INITIALIZING,
        RUNNING,
        FAILED,
        RECONNECTING,
        STOPPING,
        STOPPED;

    }
}

