/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.uima.util.Misc;

public class MultiThreadCoordination {
    private static final String MULTI_THREAD_COORD_TRACE = "uima.multi_thread_coord_trace";
    private static final boolean TRACE = Misc.getNoValueSystemProperty("uima.multi_thread_coord_trace");
    private static final boolean ASSERTS = true;
    private static final boolean USE_PRIORITY = false;
    private static final AtomicInteger TRACE_ID = TRACE ? new AtomicInteger(0) : null;
    public static final int HIGH_PRIORITY = Thread.currentThread().getPriority();
    private static final int LOW_PRIORITY = Thread.currentThread().getPriority() - 1;
    private static final Map<Thread, MultiThreadInfo> thread_to_multiThreadCoordination = Collections.synchronizedMap(new WeakHashMap());
    private final Map<String, BarrierInfo> barrier_starts = new HashMap<String, BarrierInfo>();
    private final Map<String, BarrierInfo> barrier_ends = new HashMap<String, BarrierInfo>();
    private final int baseNbrOfThreads;
    private final int barrierNbrOfThreads;
    private final AtomicInteger created_thread_number = new AtomicInteger(0);
    private final AtomicInteger nbr_started_threads = new AtomicInteger(0);
    private final LinkedBlockingDeque<MultiThreadInfo> wait_pool;
    private final LinkedBlockingDeque<MultiThreadInfo> run_pool;
    private int nbr_in_process = 0;
    private boolean isEndState = false;
    private final StringBuilder sb = new StringBuilder();
    private final StringBuilder thread_state_in_out = TRACE ? new StringBuilder() : null;
    private final StringBuilder thread_state = TRACE ? new StringBuilder() : null;
    private final StringBuilder thread_state_key = TRACE ? new StringBuilder() : null;
    private final ArrayList<MultiThreadInfo> multi_thread_infos = new ArrayList();
    private final AtomicInteger seq = new AtomicInteger(-1);
    private final ReentrantLock instance_lock = new ReentrantLock();
    private final Timer no_more_work_timer = new Timer("no_more_work_timer");
    private int debug_dump1 = 5;

    public MultiThreadCoordination(List<String> barrier_ids, int baseNbrOfThreads, int barrierNbrOfThreads, int timeout, TimeUnit tu) {
        this.baseNbrOfThreads = baseNbrOfThreads;
        this.barrierNbrOfThreads = barrierNbrOfThreads;
        for (int i = 0; i < barrier_ids.size(); ++i) {
            String start_key = barrier_ids.get(i++);
            String end_key = barrier_ids.get(i);
            BarrierInfo b = new BarrierInfo(start_key, end_key, barrierNbrOfThreads);
            this.barrier_starts.put(start_key, b);
            this.barrier_ends.put(end_key, b);
            if (!TRACE) continue;
            System.out.format("TrMTC setup adding barrier for start_key: \"%s\", end_key: \"%s\" with %d base threads, %d barrier count%n", start_key, end_key, baseNbrOfThreads, barrierNbrOfThreads);
        }
        this.wait_pool = TRACE ? new DebugDeque("wait", barrierNbrOfThreads + baseNbrOfThreads) : new LinkedBlockingDeque(barrierNbrOfThreads + baseNbrOfThreads);
        LinkedBlockingDeque linkedBlockingDeque = this.run_pool = TRACE ? new DebugDeque("run", baseNbrOfThreads) : new LinkedBlockingDeque(baseNbrOfThreads);
        if (TRACE) {
            System.out.println("ThreadState dump codes:\n  R - low-pri-run\n  W - low-pri-wait\n  P - pending-low-pri-wait\n  B - barrier-wait\n  H - hi-pri-run\n  Q - request work item\n  E = no-more-work\n  U = initial_wait (startup)  K - in pipeline\n  O - out-of-pipeline");
            System.out.format("TrMTC setup finished, baseNbr: %d%n", baseNbrOfThreads);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(null, new Runnable(){

            @Override
            public void run() {
                MultiThreadCoordination.this.instance_lock.lock();
                try {
                    for (MultiThreadInfo ti : MultiThreadCoordination.this.multi_thread_infos) {
                        ti.terminate = true;
                        ti.condition.signal();
                    }
                }
                finally {
                    MultiThreadCoordination.this.instance_lock.unlock();
                }
            }
        }, "stop threads"));
    }

    public static void start_of_pipeline() {
        MultiThreadInfo ti = thread_to_multiThreadCoordination.get(Thread.currentThread());
        if (ti == null) {
            return;
        }
        ti.mtc.start_of_pipeline(ti);
    }

    public static void end_of_pipeline() {
        MultiThreadInfo ti = thread_to_multiThreadCoordination.get(Thread.currentThread());
        if (ti == null) {
            return;
        }
        ti.mtc.end_of_pipeline_rotate_thread(ti);
    }

    static MultiThreadInfo at_call_primitive(String id, int casId, int casResets) {
        MultiThreadInfo ti = thread_to_multiThreadCoordination.get(Thread.currentThread());
        if (ti == null) {
            return null;
        }
        ti.mtc.at_call_primitive(ti, id, casId, casResets);
        return ti;
    }

    void at_call_primitive_exit(MultiThreadInfo ti, String key) {
        this.acquireLock_startTrace(ti, " prim_exit ", this.annot_short_name(key));
        try {
            BarrierInfo bi = this.barrier_ends.get(key);
            if (bi != null) {
                ti.reset_to_low_priority();
            }
            if (ti.isPendingLowPriWait) {
                ti.isPendingLowPriWait_inFront = true;
                ti.from_low_pri_pending_wait_to_wait___wa();
            }
        }
        catch (Throwable e) {
            System.out.println(this.sb.append(" Throwable caught"));
            e.printStackTrace();
            throw e;
        }
        finally {
            this.instance_lock.unlock();
        }
    }

    public void at_call_primitive(MultiThreadInfo ti, String barrier_id, int casId, int casResets) {
        this.acquireLock_startTrace(ti, " prim_start ", this.annot_short_name(barrier_id), "; id/rst:", Integer.toString(casId), "/", Integer.toString(casResets));
        try {
            if (ti.isPendingLowPriWait) {
                ti.from_low_pri_pending_wait_to_wait___wa();
            }
            ti.handle_possible_cas_change(casId, casResets);
            BarrierInfo bi = this.barrier_starts.get(barrier_id);
            if (bi == null) {
                if (ti.isPendingLowPriWait) {
                    ti.from_low_pri_pending_wait_to_wait___wa();
                }
                return;
            }
            this.arrive_at_barrier_wait_or_release(ti, bi);
        }
        catch (Throwable e) {
            System.out.println(this.sb.append(" Throwable caught"));
            e.printStackTrace();
            throw e;
        }
        finally {
            this.instance_lock.unlock();
        }
    }

    private void arrive_at_barrier_wait_or_release(MultiThreadInfo ti, BarrierInfo bi) {
        if (TRACE) {
            this.sb.append(" at Barrier ");
        }
        ti.currentBarrier = bi;
        boolean isHiPri = ti.isHiPriRun;
        if (isHiPri) {
            if (TRACE) {
                System.out.println(this.sb.append(", UNUSUAL hiPri arrived at barrier, ").append(ti.pipeline.isHiPriRun));
            }
            if (this.debug_dump1 > 0) {
                --this.debug_dump1;
                new Throwable().printStackTrace(System.out);
            }
            return;
        }
        if (bi.released) {
            if (ti.isPendingLowPriWait) {
                ti.from_low_pri_pending_wait_to_hi_prty_run();
            } else {
                ti.from_low_prty_run_to_high_prty_run___rr();
            }
            return;
        }
        int nbr_waiting_at_barrier = bi.barrier_wait_pool.size();
        if (nbr_waiting_at_barrier < this.barrierNbrOfThreads - 1 && this.wait_pool.size() > 0) {
            this.barrier_hold(bi, ti);
        } else {
            ti.from_low_prty_run_to_high_prty_run___rr();
            this.barrier_wakeup(bi);
        }
    }

    private void barrier_wakeup(BarrierInfo bi) {
        if (!bi.released) {
            int barrier_size = bi.barrier_wait_pool.size();
            bi.released = true;
            if (TRACE) {
                System.out.println(this.sb.append(" ***barrier_released(").append(barrier_size).append(")***"));
            }
            int nbr_to_initially_hold = Math.min(bi.barrier_wait_pool.size(), this.run_pool.size());
            this.hold_n_low_pri(nbr_to_initially_hold);
        } else if (TRACE) {
            System.out.println(this.sb.append(" UNUSUAL added thread to existing hi-pri released barrier"));
        }
    }

    private void hold_n_low_pri(int nbr_to_hold) {
        if (this.run_pool.isEmpty()) {
            return;
        }
        if (TRACE) {
            this.sb.append(", hold_low_pri: removing:");
        }
        for (int i = 0; i < nbr_to_hold; ++i) {
            MultiThreadInfo ti = this.run_pool.removeLast();
            if (TRACE) {
                this.sb.append("t#").append(ti.t_number).append(", ");
            }
            if (ti.isPendingLowPriWait) {
                throw new RuntimeException("debug ERROR setting pending wait - found a pending wait in run_pool");
            }
            ti.setPendingLowPriWait(true);
        }
        if (TRACE) {
            System.out.println(this.sb.append(" from run_pool"));
        }
    }

    private void barrier_hold(BarrierInfo bi, MultiThreadInfo ti) {
        if (ti.isPendingLowPriWait) {
            ti.from_low_pri_pending_wait_to_barrier_wait___ba();
        } else {
            ti.from_low_prty_run_to_barrier_waitb___rr_ba();
        }
    }

    private boolean wakeup_hi_or_low() {
        for (BarrierInfo bi : this.barrier_starts.values()) {
            if (!bi.released || bi.barrier_wait_pool.isEmpty()) continue;
            bi.from_barrier_wait_to_hi_prty_run___br();
            return true;
        }
        if (!this.wait_pool.isEmpty()) {
            return this.wakeUpLowPri_from_front();
        }
        return false;
    }

    private boolean wakeUpLowPri_from_front() {
        if (!this.wait_pool.isEmpty()) {
            MultiThreadInfo to_wakeup = this.wait_pool.removeFirst();
            if (!to_wakeup.isWithinPipeline) {
                throw new RuntimeException(this.sb.append(", error - wait pool has item not in pipeline").toString());
            }
            to_wakeup.from_low_prty_wait_to_low_prty_run___wr_ra();
            return true;
        }
        if (TRACE) {
            System.out.println(this.sb.append(" wakeupLowPri failed to find"));
        }
        return false;
    }

    public void addThread(Thread t) {
        int t_nbr = this.created_thread_number.getAndIncrement();
        MultiThreadInfo ti = new MultiThreadInfo(t, t_nbr, this);
        this.multi_thread_infos.add(ti);
        thread_to_multiThreadCoordination.put(t, ti);
        if (TRACE) {
            String tn = Integer.toString(t_nbr);
            this.thread_state_key.append(tn.charAt(tn.length() - 1));
            this.thread_state.append(' ');
            this.thread_state_in_out.append('O');
        }
        if (TRACE) {
            System.out.format("TrMTC setup added %d thread %s%n", t_nbr, t.getName());
        }
    }

    private void start_of_pipeline(MultiThreadInfo ti) {
        this.acquireLock_startTrace(ti, " start of pipeline");
        try {
            ti.isInProcess = true;
            TimerTask tt = ti.newWorkTimer;
            ti.newWorkTimer = null;
            if (tt != null) {
                tt.cancel();
            }
            ++this.nbr_in_process;
            ti.isWithinPipeline = true;
            if (TRACE) {
                ti.seq = this.seq.incrementAndGet();
                this.sb.append(" new seq#: ").append(ti.seq);
                this.thread_state_in_out.setCharAt(ti.t_number, 'K');
            }
            if (ti.pipeline.child != null) {
                ti.pipeline.child = null;
                if (TRACE) {
                    System.out.println(this.sb.append("; cleanup child pipelines"));
                }
            }
            if (TRACE) {
                this.show_thread_state();
            }
            if (ti.initial) {
                ti.initial = false;
                int n = this.nbr_started_threads.incrementAndGet();
                if (n <= this.baseNbrOfThreads) {
                    this.run_pool.addLast(ti);
                    ti.isLowPriRun = true;
                    if (TRACE) {
                        ti.set_thread_state('R');
                    }
                } else {
                    ti.setPendingLowPriWait(false);
                    ti.initialWait = true;
                    if (TRACE) {
                        ti.set_thread_state('P');
                    }
                    ti.from_low_pri_pending_wait_to_wait___wa();
                }
            }
            if (ti.hasNoWork) {
                throw new RuntimeException("not handled, should never happen");
            }
        }
        catch (Throwable e) {
            System.out.println(this.sb.append(" Throwable caught"));
            e.printStackTrace();
            throw e;
        }
        finally {
            this.instance_lock.unlock();
        }
    }

    private void start_of_inner_pipeline(Pipeline pipeline) {
        pipeline.ti.setLowPriRun();
        if (TRACE) {
            this.show_thread_state();
        }
    }

    private void end_of_pipeline_rotate_thread(MultiThreadInfo ti) {
        this.acquireLock_startTrace(ti, " end-of-pipeline");
        try {
            if (!ti.isInProcess) {
                return;
            }
            ti.isInProcess = false;
            boolean wasHighPri = ti.isHiPriRun;
            if (wasHighPri && !ti.pipeline.isHiPriRun) {
                throw new RuntimeException(this.sb.append(", inconsistent1").toString());
            }
            if (!wasHighPri && ti.pipeline.isHiPriRun) {
                throw new RuntimeException(this.sb.append(", inconsistent2").toString());
            }
            while (ti.pipeline.parent != null) {
                ti.pipeline = ti.pipeline.parent;
            }
            if (ti.isPendingLowPriWait) {
                ti.from_low_pri_pending_wait_to_wait___wa();
            }
            if (wasHighPri) {
                ti.reset_to_low_priority();
            } else {
                ti.from_low_prty_run_to_waitb___wa_rr();
            }
            if (TRACE) {
                System.out.println(this.sb.append(" req new work"));
                ti.set_thread_state('Q');
            }
            ti.hasNoWork = false;
            if (TRACE) {
                this.thread_state_in_out.setCharAt(ti.t_number, 'O');
            }
            ti.isWithinPipeline = false;
            --this.nbr_in_process;
            ti.newWorkTimer = this.createTimeOutNewWork(ti);
            this.no_more_work_timer.schedule(ti.newWorkTimer, 5000L);
        }
        catch (Throwable e) {
            System.out.println(this.sb.append(" Throwable caught"));
            e.printStackTrace();
            throw e;
        }
        finally {
            this.instance_lock.unlock();
        }
    }

    private void startTrace(MultiThreadInfo ti, String ... sa) {
        if (TRACE) {
            this.sb.setLength(0);
            this.sb.append(TRACE_ID.getAndIncrement()).append(" TrMTC t#").append(ti.t_number);
            MultiThreadCoordination.time_seq(this.sb, ti);
            for (String s : sa) {
                this.sb.append(s);
            }
        }
    }

    private void show_thread_state() {
        if (TRACE) {
            int running_high = 0;
            int running_low = 0;
            int barrier_wait = 0;
            int waiting_low = 0;
            int pending_low_wait = 0;
            int req = 0;
            int empty = 0;
            int init = 0;
            block11: for (int i = 0; i < this.thread_state.length(); ++i) {
                char c = this.thread_state.charAt(i);
                switch (c) {
                    case 'R': {
                        ++running_low;
                        continue block11;
                    }
                    case 'W': {
                        ++waiting_low;
                        continue block11;
                    }
                    case 'P': {
                        ++pending_low_wait;
                        continue block11;
                    }
                    case 'B': {
                        ++barrier_wait;
                        continue block11;
                    }
                    case 'H': {
                        ++running_high;
                        continue block11;
                    }
                    case 'Q': {
                        ++req;
                        continue block11;
                    }
                    case 'E': {
                        ++empty;
                        continue block11;
                    }
                    case 'U': {
                        ++init;
                        continue block11;
                    }
                    case 'X': {
                        continue block11;
                    }
                    default: {
                        throw new RuntimeException("never happen " + i);
                    }
                }
            }
            int[] depths = new int[this.multi_thread_infos.size()];
            int maxDepth = 0;
            int j = 0;
            for (MultiThreadInfo ti : this.multi_thread_infos) {
                int d = 0;
                Pipeline p = ti.pipeline;
                while (p.parent != null) {
                    ++d;
                    p = p.parent;
                }
                depths[j++] = d;
                maxDepth = Math.max(maxDepth, d);
            }
            System.out.println("TS: " + this.exp2(this.thread_state_key));
            System.out.format("TS: %s   --H: %d, R: %d--   ==B: %d, W: %d, P: %d==   Q: %d, E: %d, U: %d%n", this.exp2(this.thread_state), running_high, running_low, barrier_wait, waiting_low, pending_low_wait, req, empty, init);
        }
    }

    private String exp2(StringBuilder s) {
        StringBuilder sb = new StringBuilder(s.length() * 2);
        for (int i = 0; i < s.length(); ++i) {
            sb.append(s.charAt(i));
            if (i % 2 != 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    private static StringBuilder time_seq(StringBuilder sb, MultiThreadInfo ti) {
        sb.append(String.format(" %1$tH:%1$tM:%1$tS.%1$tL", new Date())).append(" s#").append(ti.seq);
        return sb;
    }

    private void acquireLock_startTrace(MultiThreadInfo ti, String ... s) {
        this.instance_lock.lock();
        this.startTrace(ti, s);
    }

    private TimerTask createTimeOutNewWork(final MultiThreadInfo ti) {
        return new TimerTask(){

            @Override
            public void run() {
                MultiThreadCoordination.this.acquireLock_startTrace(ti, new String[]{" time out - no more work"});
                try {
                    ti.from_low_prty_run_end___rr();
                }
                catch (Throwable e) {
                    if (TRACE) {
                        System.out.println(MultiThreadCoordination.this.sb.append(" Throwable caught, not being rethrown"));
                    }
                    e.printStackTrace();
                }
                finally {
                    MultiThreadCoordination.this.instance_lock.unlock();
                }
            }
        };
    }

    private String annot_short_name(String id) {
        String[] a = id.split("/");
        StringBuilder sb = new StringBuilder(id.length());
        for (String s : a) {
            if (s.length() <= 0) continue;
            sb.append(this.shorten(s, 16)).append('/');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private String shorten(String s, int len) {
        if (s.length() <= len + 1) {
            return s;
        }
        int l = len >> 1;
        return s.substring(0, l) + "." + s.substring(s.length() - l);
    }

    void wakeup_1_at_barrier() {
        for (BarrierInfo bi : this.barrier_starts.values()) {
            if (bi.barrier_wait_pool.size() == 0) continue;
            if (TRACE) {
                System.out.println(this.sb.append(", releasing from barrier at end"));
            }
            bi.from_barrier_wait_to_hi_prty_run___br();
            return;
        }
        if (TRACE) {
            System.out.println(this.sb.append(", all barriers empty, reducing active threads by 1"));
        }
    }

    private static class DebugDeque
    extends LinkedBlockingDeque<MultiThreadInfo> {
        private static final long serialVersionUID = 1L;
        final String name;

        DebugDeque(String name, int n) {
            super(n);
            this.name = name;
        }

        String x(MultiThreadInfo e, String ... sa) {
            StringBuilder sb = new StringBuilder();
            sb.append(TRACE_ID.getAndIncrement()).append(" TrMTC t#").append(e.t_number);
            MultiThreadCoordination.time_seq(sb, e);
            sb.append(" DebugDeque[").append(this.name).append("](").append(Integer.toString(this.size())).append(") ");
            for (String s : sa) {
                sb.append(s);
            }
            if (e != null) {
                sb.append(" ddt#").append(Integer.toString(e.t_number));
            }
            return sb.toString();
        }

        @Override
        public void addFirst(MultiThreadInfo e) {
            System.out.println(this.x(e, "adding First"));
            super.addFirst(e);
        }

        @Override
        public void addLast(MultiThreadInfo e) {
            System.out.println(this.x(e, "adding Last"));
            super.addLast(e);
        }

        @Override
        public MultiThreadInfo removeFirst() {
            MultiThreadInfo e = (MultiThreadInfo)super.removeFirst();
            System.out.println(this.x(e, "removing First"));
            return e;
        }

        @Override
        public MultiThreadInfo removeLast() {
            MultiThreadInfo e = (MultiThreadInfo)super.removeLast();
            System.out.println(this.x(e, "removing Last"));
            return e;
        }

        @Override
        public boolean remove(Object o) {
            System.out.println(this.x((MultiThreadInfo)o, "removing"));
            return super.remove(o);
        }
    }

    private class BarrierInfo {
        final LinkedBlockingDeque<MultiThreadInfo> barrier_wait_pool;
        boolean released = false;
        boolean keep_released = false;
        final String start_key;

        BarrierInfo(String start_key, String end_key, int barrierNbrOfThreads) {
            this.start_key = start_key;
            this.barrier_wait_pool = new LinkedBlockingDeque(barrierNbrOfThreads - 1);
        }

        public void from_barrier_wait_to_hi_prty_run___br() {
            MultiThreadInfo to_wakeup = this.barrier_wait_pool.removeFirst();
            to_wakeup.wakeup();
            this.maybeResetBarrier();
        }

        void maybeResetBarrier() {
            if (this.barrier_wait_pool.isEmpty() && !this.keep_released) {
                this.released = false;
                if (TRACE) {
                    MultiThreadCoordination.this.sb.append(" ***barrier_reset***");
                }
            }
        }
    }

    public class MultiThreadInfo
    implements StateChange {
        final Thread thread;
        final int t_number;
        int seq = -1;
        final Condition condition;
        final MultiThreadCoordination mtc;
        Pipeline pipeline;
        boolean isWithinPipeline = false;
        boolean hasNoWork = false;
        TimerTask newWorkTimer = null;
        boolean initialWait = false;
        boolean initial = true;
        boolean isKeepWaiting = false;
        boolean isHiPriRun = false;
        boolean isLowPriRun = false;
        boolean isPendingLowPriWait = false;
        boolean isPendingLowPriWait_inFront;
        boolean isInProcess = false;
        BarrierInfo currentBarrier = null;
        boolean terminate = false;

        MultiThreadInfo(Thread t, int t_number, MultiThreadCoordination mtc) {
            this.thread = t;
            this.t_number = t_number;
            this.mtc = mtc;
            this.condition = mtc.instance_lock.newCondition();
            MultiThreadCoordination multiThreadCoordination = mtc;
            multiThreadCoordination.getClass();
            this.pipeline = multiThreadCoordination.new Pipeline(this);
            if (TRACE) {
                System.out.format("TrMTC new Thread %s%n", t.getName());
            }
        }

        void handle_possible_cas_change(int casId, int casResets) {
            if (this.pipeline.casId == -1) {
                this.pipeline.casId = casId;
                this.pipeline.casResets = casResets;
                if (TRACE) {
                    System.out.println(MultiThreadCoordination.this.sb.append(", init for id/rst:").append(casId).append('/').append(casResets));
                }
                return;
            }
            int prev_cas_resets = this.pipeline.casResets;
            Pipeline cc = this.pipeline.maybe_do_pipeline_change(casId, casResets);
            if (cc == this.pipeline) {
                if (prev_cas_resets == this.pipeline.casResets) {
                    return;
                }
                return;
            }
            if (cc.parent == this.pipeline) {
                if (this.pipeline.isHiPriRun) {
                    cc.isHiPriRun = true;
                }
                this.pipeline.child = cc;
                this.pipeline = cc;
                return;
            }
            cc.child = null;
            if (this.pipeline.isHiPriRun && !cc.isHiPriRun) {
                this.pipeline = cc;
                this.reset_to_low_priority();
            } else if (!this.pipeline.isHiPriRun && cc.isHiPriRun) {
                this.pipeline = cc;
                this.from_low_prty_run_to_high_prty_run___rr();
            } else {
                this.pipeline = cc;
            }
        }

        void set_thread_state(char c) {
            if (TRACE) {
                MultiThreadCoordination.this.thread_state.setCharAt(this.t_number, c);
            }
        }

        void setPendingLowPriWait(boolean isFirst) {
            this.isPendingLowPriWait = true;
            if (TRACE) {
                this.set_thread_state('P');
            }
            this.isPendingLowPriWait_inFront = isFirst;
        }

        void resetPendingLowPriWait() {
            if (!this.isPendingLowPriWait) {
                throw new RuntimeException(MultiThreadCoordination.this.sb.append(" resetting Pending low pri wait, but wasn't set").toString());
            }
            this.isPendingLowPriWait = false;
        }

        void setLowPriWait() {
            this.resetPendingLowPriWait();
            this.isLowPriRun = false;
            if (TRACE) {
                System.out.println(MultiThreadCoordination.this.sb.append(" set_low_pri_wait +w(t#").append(this.t_number).append(")"));
                this.set_thread_state('W');
                MultiThreadCoordination.this.thread_state_in_out.setCharAt(this.t_number, 'K');
            }
        }

        void setBarrierWait(int nbrWaiting) {
            this.isLowPriRun = false;
            if (TRACE) {
                System.out.println(MultiThreadCoordination.this.sb.append(" +hold, nbr_waiting: ").append(nbrWaiting));
                this.set_thread_state('B');
            }
        }

        void setLowPriRun() {
            this.isLowPriRun = true;
            this.isHiPriRun = false;
            this.pipeline.isHiPriRun = false;
            if (TRACE) {
                this.set_thread_state('R');
                System.out.println(MultiThreadCoordination.this.sb.append(" Run low-pri"));
            }
        }

        void setHiPriRun(boolean isBarrierWait) {
            this.isHiPriRun = true;
            this.pipeline.isHiPriRun = true;
            if (TRACE) {
                System.out.println(MultiThreadCoordination.this.sb.append(" hi pri (t#").append(this.t_number).append(")"));
                this.set_thread_state(isBarrierWait ? (char)'B' : 'H');
                MultiThreadCoordination.this.show_thread_state();
            }
        }

        private boolean wake_up_another_thread_if_not_initial() {
            boolean wokeUp;
            if (this.initialWait) {
                this.initialWait = false;
                wokeUp = true;
            } else {
                wokeUp = MultiThreadCoordination.this.wakeup_hi_or_low();
            }
            if (TRACE) {
                MultiThreadCoordination.this.show_thread_state();
            }
            return wokeUp;
        }

        private void add_to_wait_pool() {
            if (this.isPendingLowPriWait_inFront) {
                this.addFirst(MultiThreadCoordination.this.wait_pool);
            } else {
                this.addLast(MultiThreadCoordination.this.wait_pool);
            }
        }

        private void addFirst(LinkedBlockingDeque<MultiThreadInfo> pool) {
            if (pool.contains(this)) {
                throw new RuntimeException("ERROR 2x add t#" + this.t_number);
            }
            if (pool == MultiThreadCoordination.this.run_pool && this.isPendingLowPriWait) {
                throw new RuntimeException(MultiThreadCoordination.this.sb + "\nERROR inserting pending wait into run pool");
            }
            if (TRACE) {
                MultiThreadCoordination.this.sb.append(pool == MultiThreadCoordination.this.run_pool ? " +rf" : " +wf");
            }
            pool.addFirst(this);
        }

        private void addLast(LinkedBlockingDeque<MultiThreadInfo> pool) {
            if (pool.contains(this)) {
                throw new RuntimeException(MultiThreadCoordination.this.sb + "\nERROR 2x add t#" + this.t_number);
            }
            if (pool == MultiThreadCoordination.this.run_pool && this.isPendingLowPriWait) {
                throw new RuntimeException(MultiThreadCoordination.this.sb + "\nERROR inserting pending wait into run pool");
            }
            if (TRACE) {
                MultiThreadCoordination.this.sb.append(pool == MultiThreadCoordination.this.run_pool ? " +rl" : " +wl");
            }
            pool.addLast(this);
        }

        private void remove(LinkedBlockingDeque<MultiThreadInfo> pool) {
            boolean wasRemoved = pool.remove(this);
            if (!wasRemoved) {
                throw new RuntimeException(MultiThreadCoordination.this.sb.toString() + "\nnever happen: removing from pool, but wasn't there");
            }
        }

        private void wakeup() {
            this.isKeepWaiting = false;
            this.condition.signal();
            if (TRACE) {
                System.out.println(MultiThreadCoordination.this.sb.append(" Notified: t#").append(this.t_number));
            }
        }

        private boolean do_wait() {
            if (TRACE) {
                System.out.println(MultiThreadCoordination.this.sb.append(" starting to wait"));
            }
            if (!MultiThreadCoordination.this.isEndState) {
                long startSleep = TRACE ? System.nanoTime() : 0L;
                this.isKeepWaiting = true;
                while (this.isKeepWaiting && !this.terminate) {
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        if (!TRACE) continue;
                        System.out.println("MultiThreadCoordination singleThread wait got interrupt");
                    }
                }
                if (this.terminate) {
                    throw new RuntimeException("forced termination due to jvm shutdown");
                }
                MultiThreadCoordination.this.startTrace(this, new String[]{" after wakeup"});
                if (TRACE) {
                    System.out.println(MultiThreadCoordination.this.sb.append(String.format(" in %,.4f ms", (double)(System.nanoTime() - startSleep) / 1000000.0)));
                }
                return false;
            }
            if (TRACE) {
                System.out.println(MultiThreadCoordination.this.sb.append(" skip wait, end-state"));
            }
            return true;
        }

        private void set_low_priority() {
            this.currentBarrier = null;
        }

        BarrierInfo reset_to_low_priority() {
            if (TRACE) {
                System.out.println(MultiThreadCoordination.this.sb.append(", loweredPriority"));
            }
            BarrierInfo bi = this.currentBarrier;
            if (bi.released) {
                this.from_high_prty_run_to_waitf___wa();
            } else {
                this.from_high_prty_run_to_low_prty_runf___ra();
            }
            return bi;
        }

        @Override
        public void from_low_pri_pending_wait_to_wait___wa() {
            boolean skipped_wait;
            this.setLowPriWait();
            boolean okToWait = this.wake_up_another_thread_if_not_initial();
            this.add_to_wait_pool();
            boolean bl = skipped_wait = !okToWait;
            if (okToWait) {
                skipped_wait = this.do_wait();
            }
            if (skipped_wait) {
                this.setLowPriRun();
                this.addFirst(MultiThreadCoordination.this.run_pool);
                this.remove(MultiThreadCoordination.this.wait_pool);
            }
        }

        @Override
        public void from_low_prty_run_to_barrier_waitb___rr_ba() {
            if (TRACE) {
                MultiThreadCoordination.this.sb.append("(wait)");
            }
            this.setHiPriRun(true);
            this.common_to_barrier_waitb(true);
        }

        private void common_to_barrier_waitb(boolean remove_from_run_pool) {
            boolean skipped_wait;
            this.setBarrierWait(this.currentBarrier.barrier_wait_pool.size());
            if (remove_from_run_pool) {
                this.remove(MultiThreadCoordination.this.run_pool);
            }
            boolean okToWait = MultiThreadCoordination.this.wakeup_hi_or_low();
            this.addLast(this.currentBarrier.barrier_wait_pool);
            boolean bl = skipped_wait = !okToWait;
            if (okToWait) {
                skipped_wait = this.do_wait();
            }
            if (TRACE) {
                this.set_thread_state('H');
            }
            if (skipped_wait) {
                this.currentBarrier.barrier_wait_pool.removeLast();
                this.currentBarrier.maybeResetBarrier();
            }
        }

        @Override
        public void from_low_pri_pending_wait_to_barrier_wait___ba() {
            if (TRACE) {
                System.out.println(MultiThreadCoordination.this.sb.append(", converting low pri wait to barrier wait"));
            }
            this.resetPendingLowPriWait();
            this.setHiPriRun(true);
            this.common_to_barrier_waitb(false);
        }

        @Override
        public void from_high_prty_run_to_low_prty_runf___ra() {
            this.set_low_priority();
            this.setLowPriRun();
            this.addFirst(MultiThreadCoordination.this.run_pool);
        }

        @Override
        public void from_high_prty_run_to_waitf___wa() {
            this.set_low_priority();
            this.isPendingLowPriWait_inFront = true;
            this.isPendingLowPriWait = true;
            this.from_low_pri_pending_wait_to_wait___wa();
        }

        @Override
        public void from_low_prty_wait_to_low_prty_run___wr_ra() {
            this.wakeup();
            this.setLowPriRun();
            this.addFirst(MultiThreadCoordination.this.run_pool);
        }

        @Override
        public void from_low_prty_run_to_high_prty_run___rr() {
            this.setHiPriRun(false);
            this.remove(MultiThreadCoordination.this.run_pool);
        }

        @Override
        public void from_low_prty_run_to_waitb___wa_rr() {
            if (TRACE) {
                System.out.println(MultiThreadCoordination.this.sb.append(", removing from run_pool t#").append(this.t_number));
            }
            this.remove(MultiThreadCoordination.this.run_pool);
            this.isPendingLowPriWait_inFront = false;
            this.isPendingLowPriWait = true;
            this.from_low_pri_pending_wait_to_wait___wa();
        }

        @Override
        public void from_low_pri_pending_wait_to_hi_prty_run() {
            this.setHiPriRun(false);
        }

        @Override
        public void from_low_prty_run_end___rr() {
            boolean noMore;
            if (this.newWorkTimer == null) {
                return;
            }
            this.isLowPriRun = false;
            this.hasNoWork = true;
            if (TRACE) {
                this.set_thread_state('E');
            }
            if (!this.isPendingLowPriWait) {
                this.remove(MultiThreadCoordination.this.run_pool);
            }
            if (MultiThreadCoordination.this.run_pool.remainingCapacity() == 0) {
                if (TRACE) {
                    System.out.println(MultiThreadCoordination.this.sb.append(", run_pool full, this thread in pending wait"));
                }
                return;
            }
            boolean bl = noMore = !MultiThreadCoordination.this.wakeup_hi_or_low();
            if (TRACE) {
                System.out.println(MultiThreadCoordination.this.sb.append(", time-out-waiting-for-wk, ").append(noMore ? "no more waiting" : "woke-up another"));
                MultiThreadCoordination.this.show_thread_state();
            }
            if (noMore) {
                MultiThreadCoordination.this.wakeup_1_at_barrier();
            }
        }
    }

    class Pipeline {
        final MultiThreadInfo ti;
        int casId;
        int casResets;
        boolean isHiPriRun = false;
        final Pipeline parent;
        Pipeline child = null;

        Pipeline(MultiThreadInfo ti) {
            this.ti = ti;
            this.parent = null;
            this.casId = -1;
            this.casResets = -1;
        }

        Pipeline(MultiThreadInfo ti, Pipeline parent, int casId, int casResets) {
            this.ti = ti;
            this.parent = parent;
            this.casId = casId;
            this.casResets = casResets;
        }

        Pipeline maybe_do_pipeline_change(int casId, int casResets) {
            int prev_casId = this.casId;
            int prev_casResets = this.casResets;
            if (!this.isSame(casId, casResets)) {
                Pipeline localParent = this.parent;
                while (localParent != null) {
                    if (localParent.isSame(casId, casResets)) {
                        if (TRACE) {
                            System.out.println(MultiThreadCoordination.this.sb.append(", returning to prev cas/rsts from ").append(prev_casId).append('/').append(prev_casResets));
                        }
                        return localParent;
                    }
                    localParent = localParent.parent;
                }
                if (casId == this.casId) {
                    this.casResets = casResets;
                    if (TRACE) {
                        System.out.println(MultiThreadCoordination.this.sb.append(", new iter cas/rsts from ").append(prev_casId).append('/').append(prev_casResets));
                    }
                    return this;
                }
                if (TRACE) {
                    System.out.println(MultiThreadCoordination.this.sb.append(", new subr cas/rsts from ").append(prev_casId).append('/').append(prev_casResets));
                }
                return new Pipeline(this.ti, this, casId, casResets);
            }
            return this;
        }

        boolean isSame(int casId, int casResets) {
            return this.casId == casId && this.casResets == casResets;
        }
    }

    static interface StateChange {
        public void from_low_pri_pending_wait_to_wait___wa();

        public void from_high_prty_run_to_low_prty_runf___ra();

        public void from_high_prty_run_to_waitf___wa();

        public void from_low_prty_wait_to_low_prty_run___wr_ra();

        public void from_low_prty_run_to_barrier_waitb___rr_ba();

        public void from_low_prty_run_to_high_prty_run___rr();

        public void from_low_prty_run_to_waitb___wa_rr();

        public void from_low_prty_run_end___rr();

        public void from_low_pri_pending_wait_to_barrier_wait___ba();

        public void from_low_pri_pending_wait_to_hi_prty_run();
    }
}

