/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.metadata.cpe;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.uima.collection.metadata.CpeComponentDescriptor;
import org.apache.uima.collection.metadata.CpeInclude;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;

public class CpeComponentDescriptorImpl
extends MetaDataObject_impl
implements CpeComponentDescriptor {
    private static final long serialVersionUID = 1607312024379882416L;
    private CpeInclude mInclude;
    private Import mImport;
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("descriptor", new PropertyXmlInfo[]{new PropertyXmlInfo("include", null), new PropertyXmlInfo("import", null)});

    public void setInclude(CpeInclude aInclude) {
        this.mInclude = aInclude;
    }

    public CpeInclude getInclude() {
        return this.mInclude;
    }

    public Import getImport() {
        return this.mImport;
    }

    public void setImport(Import aImport) {
        this.mImport = aImport;
    }

    public URL findAbsoluteUrl(ResourceManager aResourceManager) throws ResourceConfigurationException {
        try {
            if (this.mImport != null) {
                return this.mImport.findAbsoluteUrl(aResourceManager);
            }
            String path = this.mInclude.get();
            if (path.startsWith("${CPM_HOME}")) {
                String cpmHome = System.getProperty("CPM_HOME");
                path = cpmHome + path.substring("${CPM_HOME}".length());
            }
            try {
                return new URL(path);
            }
            catch (MalformedURLException e) {
                try {
                    return new File(path).getAbsoluteFile().toURI().toURL();
                }
                catch (MalformedURLException e2) {
                    throw new InvalidXMLException("malformed_import_url", new Object[]{path, this.getSourceUrlString()}, (Throwable)e);
                }
            }
        }
        catch (InvalidXMLException e) {
            throw new ResourceConfigurationException((Throwable)e);
        }
    }

    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }
}

