/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.vinci.debug.Debug;
import org.apache.vinci.transport.BaseServer;
import org.apache.vinci.transport.ServiceDownException;
import org.apache.vinci.transport.ServiceException;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.VNSException;
import org.apache.vinci.transport.VinciClient;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.VinciServable;
import org.apache.vinci.transport.VinciServerRunnable;
import org.apache.vinci.transport.context.VinciContext;
import org.apache.vinci.transport.vns.client.ServeonResult;

public class VinciServer
extends BaseServer {
    private int priority = 0;
    private int instance = 0;
    private String hostName = null;
    private String serviceName = null;
    private volatile int port = -1;
    private VinciContext context = null;

    public VinciServer(String service_name, String host_name, VinciServable servable) {
        this(service_name, host_name, servable, 0);
    }

    public VinciServer(String service_name, VinciServable servable) throws UnknownHostException {
        this(service_name, InetAddress.getLocalHost().getHostAddress(), servable);
    }

    public VinciServer(String service_name, String host_name, VinciServable servable, int myPriority, int myInstance) {
        super(servable);
        this.priority = myPriority;
        this.serviceName = service_name;
        this.instance = myInstance;
        this.hostName = host_name;
    }

    public VinciServer(String service_name, String host_name, VinciServable servable, int myPriority) {
        this(service_name, host_name, servable, myPriority, 0);
    }

    public VinciServer(String service_name, VinciServable servable, int myPriority) throws UnknownHostException {
        this(service_name, InetAddress.getLocalHost().getHostAddress(), servable, myPriority);
    }

    public VinciServer(String service_name, VinciServable servable, int myPriority, int myInstance) throws UnknownHostException {
        this(service_name, InetAddress.getLocalHost().getHostName(), servable, myPriority, myInstance);
    }

    public VinciServer(VinciServable servable) {
        super(servable);
    }

    public VinciContext getContext() {
        if (this.context == null) {
            return VinciContext.getGlobalContext();
        }
        return this.context;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int getInstance() {
        return this.instance;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getServingPort() {
        return this.port;
    }

    public void setContext(VinciContext c) {
        this.context = c;
    }

    public void serve() throws ServiceDownException, VNSException, IOException {
        this.port = this.getPort();
        Debug.printDebuggingMessage("Service " + this.serviceName + " starting on port " + this.port);
        this.serve(this.port);
    }

    public void startServing() throws ServiceDownException, VNSException, IOException {
        this.port = this.getPort();
        Debug.p("Service " + this.serviceName + " asynchronously starting on port " + this.port);
        this.startServing(this.port);
    }

    @Override
    protected Runnable getRunnable(Socket client) {
        return new VinciServerRunnable(client, this);
    }

    public static Transportable createShutdownCommand(String shutdown_message) {
        return new VinciFrame().fadd("vinci:SHUTDOWN", shutdown_message);
    }

    public boolean shutdown(String shutdown_message) {
        Debug.printDebuggingMessage("VinciServer.shutdown()", "Accepted shutdown request: " + shutdown_message);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    Debug.reportException(e);
                }
                VinciServer.this.shutdownServing();
            }
        }).start();
        return true;
    }

    protected int getPort() throws ServiceDownException, VNSException {
        try {
            VinciContext myContext = this.getContext();
            ServeonResult response = (ServeonResult)VinciClient.sendAndReceive(ServeonResult.composeQuery(this.serviceName, this.hostName, this.priority, this.instance), myContext.getVNSHost(), myContext.getVNSPort(), ServeonResult.factory, myContext.getVNSServeonTimeout());
            return response.port;
        }
        catch (IOException e) {
            Debug.reportException(e);
            throw new ServiceDownException("VNS inaccessible: " + e);
        }
        catch (ServiceException e) {
            throw new VNSException(e.getMessage());
        }
    }
}

