/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.stylemap;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.apache.uima.tools.stylemap.StyleMapTable;

class ColorRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = 4260743930100354668L;
    private Border unselectedBorder = null;
    private Border selectedBorder = null;

    public ColorRenderer(StyleMapTable sTable) {
        this.setOpaque(true);
        if (this.selectedBorder == null) {
            this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, sTable.getSelectionBackground());
        }
        if (this.unselectedBorder == null) {
            this.unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, sTable.getBackground());
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground((Color)color);
        if (isSelected) {
            this.setBorder(this.selectedBorder);
        } else {
            this.setBorder(this.unselectedBorder);
        }
        return this;
    }
}

