package org.apache.dvsl.dom4j;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.StringWriter;
import java.io.Writer;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;

import org.dom4j.Node;
import org.dom4j.Element;
import org.dom4j.Document;
import org.dom4j.Text;
import org.dom4j.Attribute;
import org.dom4j.Comment;
import org.dom4j.CDATA;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.XPath;

import org.dom4j.io.XMLWriter;

import org.apache.dvsl.DVSLNode;


/**
 * wrapper class for dom4j nodes to implement the
 *  DVSLNode interface for template use
 *
 *  @author <a href="mailto:geirm@apache.org">Geir Magnusson Jr.</a>
 */
public class Dom4jNodeImpl implements DVSLNode
{
    protected Node element = null;

    protected Map attributes = null;

    /**
     *  this is a bit yecchy - need to revamp
     */
    public Dom4jNodeImpl( Element e )
    {
        element = e;
    }

    public Dom4jNodeImpl( Document e )
    {
        element = e;
    }

    public Dom4jNodeImpl( Text e )
    {
        element = e;
    }

    public Dom4jNodeImpl( Attribute e )
    {
        element = e;
    }

    public Dom4jNodeImpl( Comment e )
    {
        element = e;
    }

    public Dom4jNodeImpl( CDATA e )
    {
        element = e;
    }

    private Dom4jNodeImpl()
    {
    }

    /**
     *  returns the name of the node
     */
    public String name()
    {
        return element.getName();
    }

    /**
     *  returns a specificed attributeattribute
     */
    public String attribute( String attribute )
    {
        if ( element instanceof Element )
            return ( (Element) element).attributeValue( attribute );

        return null;
    }

    /**
     *  returns a list of nodes that satisfy
     *  the xpath
     */
    public List selectNodes( String xpath )
    {
        List l = element.selectNodes( xpath );

        List list = new ArrayList();

        for( int i = 0; i < l.size(); i++)
        {
            Node n = (Node) l.get( i );

            if ( n != null )
            {
                list.add( makeDVSLNode( n ) );
            }
        }

        return list;
    }

    public DVSLNode selectSingleNode( String xpath )
    {
        org.dom4j.Node n = element.selectSingleNode( xpath );

        return makeDVSLNode( n );
    }

    public DVSLNode get( String xpath )
    {
        return selectSingleNode( xpath );
    }

    public String value()
    {
        return element.getText();
    }

    public Object valueOf( String xpath )
    {
        return element.valueOf( xpath );
    }

    public String toString()
    {
        return value();
    }

    public List children()
    {
        List list = new ArrayList();

        if ( element.getNodeType() == Node.ELEMENT_NODE )
        {
            List nodes = ( (Element) element).content();

            for( int i = 0; i < nodes.size(); i++)
                list.add(  makeDVSLNode( (Node) nodes.get(i)) );
        }

        return list;
    }

    /**
     *  assumes a list of DVSLNodes
     */
    public String copy( List nodes )
    {
        if ( nodes == null)
            return "";

        StringWriter sw = new StringWriter();

        for( int i = 0; i < nodes.size(); i++)
        {
            DVSLNode dn = (DVSLNode) nodes.get(i);

            copy( (Node) dn.getNodeImpl(), sw );
        }

        return sw.toString();
    }

    public String copy()
    {
        StringWriter sw = new StringWriter();
        copy(element, sw );
        return sw.toString();
    }

    private void copy( Node node, Writer writer )
    {
        XMLWriter xw = new XMLWriter( writer );

        try
        {
            xw.write( node );
        }
        catch( Exception  ee )
        {
        }
        finally
        {
            try
            {
                xw.flush();
            }
            catch( Exception eee)
                {}
        }
    }

    public String render()
    {
        try
        {
            StringWriter sw = new StringWriter();

            element.write(sw);

            return sw.toString();
        }
        catch(Exception e )
        {
        }

        return "";
    }

    public String attrib( String name )
    {
        if ( element instanceof Element )
        {
            Attribute attrib = ( (Element) element).attribute( name );

            if( attrib != null)
                return attrib.getValue();
        }

        return null;
    }

    public Object getNodeImpl()
    {
        return element;
    }

    public Map getAttribMap()
    {
        /*
         *  $$$ GMJ sync issue? yes.  Do I care?
         */

        if (attributes == null)
            attributes = new HashMap();

        /*
         * only Elements have attributes
         */

        if ( element instanceof Element )
        {
            Iterator it = ( (Element) element).attributeIterator();

            while(it.hasNext())
            {
                Attribute at = (Attribute) it.next();

                attributes.put( at.getName(), at.getValue() );
            }
        }

        return attributes;
    }

    /**
     *  will recast all of this later
     */
    private DVSLNode makeDVSLNode( Node n )
    {
        if ( n == null)
            return null;

        short type = n.getNodeType();

        if ( type == Node.ELEMENT_NODE )
        {
            return new Dom4jNodeImpl( (Element) n );
        }
        else if( type == Node.TEXT_NODE )
        {
            return new Dom4jNodeImpl( (Text) n );
        }
        else if ( type == Node.ATTRIBUTE_NODE )
        {
            return new Dom4jNodeImpl( (Attribute) n );
        }
        else if ( type == Node.COMMENT_NODE )
        {
            return new Dom4jNodeImpl( (Comment) n );
        }
        else if ( type == Node.CDATA_SECTION_NODE )
        {
            return new Dom4jNodeImpl( (CDATA) n );
        }

        return null;
    }
}
