/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.wicket.protocol.http.mock.Cookies;

public class CookieCollection {
    private final Map<Cookies.Key, Cookie> cookies = new LinkedHashMap<Cookies.Key, Cookie>();
    private final Map<Cookies.Key, Cookie> expiredCookies = new LinkedHashMap<Cookies.Key, Cookie>();

    public void add(Cookie cookie) {
        Cookies.Key key = Cookies.keyOf(cookie);
        Cookie copyOfCookie = Cookies.copyOf(cookie);
        if (Cookies.isExpired(cookie)) {
            this.expiredCookies.put(key, copyOfCookie);
            this.cookies.remove(key);
        } else {
            this.cookies.put(key, copyOfCookie);
        }
    }

    public void addAll(Cookie[] cookies) {
        if (cookies != null) {
            this.addAll(Arrays.asList(cookies));
        }
    }

    public void addAll(List<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            this.add(cookie);
        }
    }

    public List<Cookie> asList() {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        ret.addAll(this.cookies.values());
        return ret;
    }

    public List<Cookie> expiredAsList() {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        ret.addAll(this.expiredCookies.values());
        return ret;
    }

    public List<Cookie> allAsList() {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        ret.addAll(this.cookies.values());
        ret.addAll(this.expiredCookies.values());
        return ret;
    }
}

