/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import org.apache.wicket.Page;
import org.apache.wicket.markup.head.MetaDataHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class HtmlImportHeaderItem
extends MetaDataHeaderItem {
    private HtmlImportHeaderItem() {
        super("link");
    }

    public static MetaDataHeaderItem forLinkTag(String rel, String href, String media) {
        return HtmlImportHeaderItem.forLinkTag(Model.of(rel), Model.of(href), Model.of(media));
    }

    public static MetaDataHeaderItem forLinkTag(IModel<String> rel, IModel<String> href, IModel<String> media) {
        MetaDataHeaderItem headerItem = HtmlImportHeaderItem.forLinkTag(rel, href);
        headerItem.addTagAttribute("media", media);
        return headerItem;
    }

    public static MetaDataHeaderItem forImportLinkTag(String href) {
        return HtmlImportHeaderItem.forImportLinkTag(Model.of(href), false);
    }

    public static MetaDataHeaderItem forImportLinkTag(IModel<String> href) {
        return HtmlImportHeaderItem.forImportLinkTag(href, false);
    }

    public static MetaDataHeaderItem forImportLinkTag(String href, boolean async) {
        return HtmlImportHeaderItem.forImportLinkTag(Model.of(href), async);
    }

    public static MetaDataHeaderItem forImportLinkTag(IModel<String> href, boolean async) {
        MetaDataHeaderItem linkTag = HtmlImportHeaderItem.forLinkTag(Model.of("import"), href);
        HtmlImportHeaderItem.addAsyncAttribute(linkTag, async);
        return linkTag;
    }

    private static void addAsyncAttribute(MetaDataHeaderItem linkTag, boolean async) {
        if (async) {
            linkTag.addTagAttribute("async");
        }
    }

    public static MetaDataHeaderItem forImportLinkTag(Class<? extends Page> pageClass) {
        return HtmlImportHeaderItem.forImportLinkTag(pageClass, null);
    }

    public static MetaDataHeaderItem forImportLinkTag(Class<? extends Page> pageClass, PageParameters pageParameters) {
        return HtmlImportHeaderItem.forImportLinkTag(pageClass, pageParameters, false);
    }

    public static MetaDataHeaderItem forImportLinkTag(Class<? extends Page> pageClass, PageParameters pageParameters, boolean async) {
        return HtmlImportHeaderItem.forImportLinkTag(pageClass, pageParameters, (String)null, async);
    }

    public static MetaDataHeaderItem forImportLinkTag(Class<? extends Page> pageClass, PageParameters pageParameters, String media) {
        return HtmlImportHeaderItem.forImportLinkTag(pageClass, pageParameters, Model.of(media));
    }

    public static MetaDataHeaderItem forImportLinkTag(Class<? extends Page> pageClass, PageParameters pageParameters, String media, boolean async) {
        return HtmlImportHeaderItem.forImportLinkTag(pageClass, pageParameters, Model.of(media), async);
    }

    public static MetaDataHeaderItem forImportLinkTag(Class<? extends Page> pageClass, PageParameters pageParameters, IModel<String> media) {
        return HtmlImportHeaderItem.forImportLinkTag(pageClass, pageParameters, media, false);
    }

    public static MetaDataHeaderItem forImportLinkTag(Class<? extends Page> pageClass, PageParameters pageParameters, IModel<String> media, boolean async) {
        MetaDataHeaderItem linkTag = HtmlImportHeaderItem.forLinkTag(Model.of("import"), Model.of(RequestCycle.get().urlFor(pageClass, pageParameters).toString()), media);
        HtmlImportHeaderItem.addAsyncAttribute(linkTag, async);
        return linkTag;
    }
}

