/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.FloatKey;
import org.apache.batik.util.ParsedURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.fop.configuration.Configurable;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.svg.FOPSAXSVGDocumentFactory;
import org.apache.fop.svg.font.FOPFontFamilyResolver;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageSessionContext;
import org.w3c.dom.DOMImplementation;
import org.xml.sax.EntityResolver;

public abstract class AbstractFOPTranscoder
extends SVGAbstractTranscoder
implements Configurable {
    public static final TranscodingHints.Key KEY_DEVICE_RESOLUTION = new FloatKey();
    public static final TranscodingHints.Key KEY_STROKE_TEXT = new BooleanKey();
    public static final TranscodingHints.Key KEY_AUTO_FONTS = new BooleanKey();
    public static final Boolean VALUE_FORMAT_ON = Boolean.TRUE;
    public static final Boolean VALUE_FORMAT_OFF = Boolean.FALSE;
    private Log logger;
    private EntityResolver resolver;
    private Configuration cfg;
    private ImageManager imageManager;
    private ImageSessionContext imageSessionContext;

    public AbstractFOPTranscoder() {
        this.hints.put((Object)KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, (Object)"http://www.w3.org/2000/svg");
        this.hints.put((Object)KEY_DOCUMENT_ELEMENT, (Object)"svg");
        this.hints.put((Object)KEY_DOM_IMPLEMENTATION, (Object)SVGDOMImplementation.getDOMImplementation());
    }

    protected FOPTranscoderUserAgent createUserAgent() {
        return new FOPTranscoderUserAgent();
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void configure(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
    }

    protected boolean getAutoFontsDefault() {
        return true;
    }

    protected Configuration getEffectiveConfiguration() {
        Configuration effCfg = this.cfg;
        if (effCfg == null) {
            boolean autoFonts = this.getAutoFontsDefault();
            if (this.hints.containsKey((Object)KEY_AUTO_FONTS)) {
                autoFonts = (Boolean)this.hints.get((Object)KEY_AUTO_FONTS);
            }
            if (autoFonts) {
                DefaultConfiguration c = new DefaultConfiguration("cfg");
                DefaultConfiguration fonts = new DefaultConfiguration("fonts");
                c.addChild(fonts);
                DefaultConfiguration autodetect = new DefaultConfiguration("auto-detect");
                fonts.addChild(autodetect);
                effCfg = c;
            }
        }
        return effCfg;
    }

    protected final Log getLogger() {
        if (this.logger == null) {
            this.logger = new SimpleLog("FOP/Transcoder");
        }
        return this.logger;
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation domImpl, String parserClassname) {
        FOPSAXSVGDocumentFactory factory = new FOPSAXSVGDocumentFactory(parserClassname);
        if (this.resolver != null) {
            factory.setAdditionalEntityResolver(this.resolver);
        }
        return factory;
    }

    protected boolean isTextStroked() {
        boolean stroke = false;
        if (this.hints.containsKey((Object)KEY_STROKE_TEXT)) {
            stroke = (Boolean)this.hints.get((Object)KEY_STROKE_TEXT);
        }
        return stroke;
    }

    protected float getDeviceResolution() {
        if (this.hints.containsKey((Object)KEY_DEVICE_RESOLUTION)) {
            return ((Float)this.hints.get((Object)KEY_DEVICE_RESOLUTION)).floatValue();
        }
        return 72.0f;
    }

    protected ImageManager getImageManager() {
        return this.imageManager;
    }

    protected ImageSessionContext getImageSessionContext() {
        return this.imageSessionContext;
    }

    protected void setupImageInfrastructure(final String baseURI) {
        final ImageContext imageContext = new ImageContext(){

            public float getSourceResolution() {
                return AbstractFOPTranscoder.this.userAgent.getSourceResolution();
            }
        };
        this.imageManager = new ImageManager(imageContext);
        this.imageSessionContext = new AbstractImageSessionContext(){

            public ImageContext getParentContext() {
                return imageContext;
            }

            public float getTargetResolution() {
                return AbstractFOPTranscoder.this.getDeviceResolution();
            }

            public float getSourceResolution() {
                return AbstractFOPTranscoder.this.getDeviceResolution();
            }

            public Source resolveURI(String uri) {
                try {
                    ParsedURL url = new ParsedURL(baseURI, uri);
                    InputStream in = url.openStream();
                    StreamSource source = new StreamSource(in, url.toString());
                    return source;
                }
                catch (IOException ioe) {
                    AbstractFOPTranscoder.this.userAgent.displayError((Exception)ioe);
                    return null;
                }
            }
        };
    }

    protected class FOPTranscoderUserAgent
    extends SVGAbstractTranscoder.SVGAbstractTranscoderUserAgent {
        private FOPFontFamilyResolver fontFamilyResolver;

        protected FOPTranscoderUserAgent() {
            super((SVGAbstractTranscoder)AbstractFOPTranscoder.this);
        }

        public void displayError(String message) {
            try {
                AbstractFOPTranscoder.this.getErrorHandler().error(new TranscoderException(message));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException();
            }
        }

        public void displayError(Exception e) {
            try {
                AbstractFOPTranscoder.this.getErrorHandler().error(new TranscoderException(e));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException();
            }
        }

        public void displayMessage(String message) {
            AbstractFOPTranscoder.this.getLogger().info(message);
        }

        public float getPixelUnitToMillimeter() {
            TranscodingHints.Key key = ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER;
            if (AbstractFOPTranscoder.this.getTranscodingHints().containsKey((Object)key)) {
                return ((Float)AbstractFOPTranscoder.this.getTranscodingHints().get((Object)key)).floatValue();
            }
            return 25.4f / this.getSourceResolution();
        }

        public String getMedia() {
            return "print";
        }

        public void setFontFamilyResolver(FOPFontFamilyResolver resolver) {
            this.fontFamilyResolver = resolver;
        }

        public FontFamilyResolver getFontFamilyResolver() {
            return this.fontFamilyResolver;
        }
    }

    protected class FOPErrorHandler
    implements ErrorHandler {
        protected FOPErrorHandler() {
        }

        public void error(TranscoderException te) throws TranscoderException {
            AbstractFOPTranscoder.this.getLogger().error(te.getMessage());
        }

        public void fatalError(TranscoderException te) throws TranscoderException {
            throw te;
        }

        public void warning(TranscoderException te) throws TranscoderException {
            AbstractFOPTranscoder.this.getLogger().warn(te.getMessage());
        }
    }
}

