# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=libical
VER=0.43
REV=1
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev
usemsvs6

(

set -x

# Avoid the silly "relink" stuff in libtool
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

patch -p0 <<'EOF'
diff -ru -x Makefile.am ../0.43.orig/src/libical/icalrecur.c ./src/libical/icalrecur.c
--- ../0.43.orig/src/libical/icalrecur.c	2009-01-08 18:50:21.000000000 +0200
+++ ./src/libical/icalrecur.c	2009-01-27 20:51:01.925000000 +0200
@@ -142,7 +142,7 @@
 #include <limits.h>
 
 #ifndef HAVE_INTPTR_T
-#if defined (WIN32) || defined (XP_BEOS)
+#if (defined (WIN32) && !defined (__MINGW32__)) || defined (XP_BEOS)
 typedef long intptr_t;
 #endif
 #endif
diff -ru -x Makefile.am ../0.43.orig/src/libical/icaltz-util.c ./src/libical/icaltz-util.c
--- ../0.43.orig/src/libical/icaltz-util.c	2009-01-08 18:50:21.000000000 +0200
+++ ./src/libical/icaltz-util.c	2009-01-27 20:38:04.987500000 +0200
@@ -59,6 +59,9 @@
                     | (((x) & 0x0000000000ff0000ull) << 24) \
                     | (((x) & 0x000000000000ff00ull) << 40) \
                     | (((x) & 0x00000000000000ffull) << 56))
+#define BIG_ENDIAN 'B'
+#define LITTLE_ENDIAN 'l'
+#define BYTE_ORDER LITTLE_ENDIAN
 #endif
 #include <io.h>
 #endif
diff -ru -x Makefile.am ../0.43.orig/src/libical/Makefile.in ./src/libical/Makefile.in
--- ../0.43.orig/src/libical/Makefile.in	2009-01-08 18:51:42.000000000 +0200
+++ ./src/libical/Makefile.in	2009-01-27 20:46:09.612500000 +0200
@@ -326,7 +326,7 @@
 	-I$(top_builddir)/src/libical	\
 	-I$(srcdir)
 
-libical_la_LDFLAGS = -version-info 43:0:43
+libical_la_LDFLAGS = -version-info 43:0:43 -no-undefined
 libical_la_LIBADD = $(PTHREAD_LIBS)
 libical_la_SOURCES = \
 	$(BUILT_SOURCES)	\
diff -ru -x Makefile.am ../0.43.orig/src/libical/vsnprintf.c ./src/libical/vsnprintf.c
--- ../0.43.orig/src/libical/vsnprintf.c	2009-01-08 18:50:22.000000000 +0200
+++ ./src/libical/vsnprintf.c	2009-01-27 20:44:09.425000000 +0200
@@ -1,6 +1,4 @@
-#ifndef WIN32
 #include "config.h"
-#endif
 #ifndef HAVE_SNPRINTF
 #error DO NOT USE libical version of vsnprintf.
 /*
diff -ru -x Makefile.am ../0.43.orig/src/libicalss/Makefile.in ./src/libicalss/Makefile.in
--- ../0.43.orig/src/libicalss/Makefile.in	2009-01-08 18:51:44.000000000 +0200
+++ ./src/libicalss/Makefile.in	2009-01-27 21:02:40.800000000 +0200
@@ -307,8 +307,8 @@
 	-I$(top_builddir)/src/libical	\
 	$(BDB_INCLUDE)
 
-libicalss_la_LDFLAGS = -version-info 43:0:43
-libicalss_la_LIBADD = $(BDB_LIBFILES) 
+libicalss_la_LDFLAGS = -version-info 43:0:43 -no-undefined
+libicalss_la_LIBADD = $(BDB_LIBFILES) $(top_builddir)/src/libical/libical.la
 @DEV_FALSE@libicalss_la_DEVSOURCES = icalsslexer.c icalssyacc.c
 @DEV_TRUE@libicalss_la_DEVSOURCES = icalsslexer.l icalssyacc.y
 libicalss_la_SOURCES = \
diff -ru -x Makefile.am ../0.43.orig/src/libicalvcal/Makefile.in ./src/libicalvcal/Makefile.in
--- ../0.43.orig/src/libicalvcal/Makefile.in	2009-01-08 18:51:46.000000000 +0200
+++ ./src/libicalvcal/Makefile.in	2009-01-27 21:12:01.893750000 +0200
@@ -237,7 +237,7 @@
 	-I$(top_builddir)/src/libical	\
 	-I$(top_srcdir)/src/libicalss
 
-libicalvcal_la_LDFLAGS = -version-info 43:0:43
+libicalvcal_la_LDFLAGS = -version-info 43:0:43 -no-undefined
 libicalvcal_la_LIBADD = ../libical/.libs/libical.la
 @DEV_FALSE@libicalvcal_la_DEVSOURCES = vcc.c
 @DEV_TRUE@libicalvcal_la_DEVSOURCES = vcc.y
diff -ru -x Makefile.am ../0.43.orig/libical.pc.in ./libical.pc.in
--- libical.pc.in
+++ libical.pc.in
@@ -7,5 +7,5 @@
 Description: An implementation of basic iCAL protocols
 Version: @VERSION@
 Libs: -L${libdir} -lical -licalss -licalvcal
-Cflags: -I${includedir}/libical
+Cflags: -I${includedir}

EOF

CC='gcc -mtune=pentium3 -mthreads' CFLAGS=-O2 ./configure --disable-static --prefix=$TARGET &&
libtoolcacheize &&
make -j3 install &&

cd /devel/target/$HEX &&

rm -f /tmp/$RUNZIP /tmp/$DEVZIP &&

zip /tmp/$RUNZIP bin/libical*dll  &&
zip -r /tmp/$RUNZIP share/libical/zoneinfo &&

zip /tmp/$DEVZIP lib/libical*.dll.a &&
zip -r /tmp/$DEVZIP include/libical &&
zip /tmp/$DEVZIP lib/pkgconfig

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
