# Copyright (C) 2005 by Sicem S.L.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import gettext
import gtk

_ = gettext.gettext

class BugReportDialog(gtk.Dialog):

    def __init__(self, parent=None):
        gtk.Dialog.__init__(self, 'Send Bug report', parent,
                            gtk.DIALOG_MODAL | gtk.DIALOG_NO_SEPARATOR,
                            (gtk.STOCK_OK, gtk.RESPONSE_ACCEPT,
                             gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT))
        self.set_border_width(6)
        # 304 = 430 / sqrt(2) = golden number
        self.set_default_size(430, 304)
        self.vbox.set_spacing(12)

        text1 = _('What were you doing before the error occured?')
        frame1 = self._create_frame(text1)
        sw = gtk.ScrolledWindow()
        sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        sw.set_shadow_type(gtk.SHADOW_IN)
        self.description_textview = gtk.TextView()
        sw.add(self.description_textview)
        frame1.add(sw)
        self.vbox.pack_start(frame1, True, True)

        text2 = _('Personal information (optional)') + ':'
        frame2 = self._create_frame(text2)
        table = gtk.Table(2, 2)
        table.set_border_width(6)
        table.set_row_spacings(6)
        table.set_col_spacings(6)
        label1 = gtk.Label(_('Name') + ':')
        self.name_entry = gtk.Entry()
        label2 = gtk.Label(_('E-Mail') + ':')
        self.email_entry = gtk.Entry()
        table.attach(label1, 0, 1, 0, 1, 0, 0)
        table.attach(self.name_entry, 1, 2, 0, 1, gtk.EXPAND|gtk.FILL, 0)
        table.attach(label2, 0, 1, 1, 2, 0, 0)
        table.attach(self.email_entry, 1, 2, 1, 2, gtk.EXPAND|gtk.FILL, 0)
        frame2.add(table)
        self.vbox.pack_start(frame2, False, False)

        self.vbox.show_all()

    def _create_frame(self, labeltext):
        frame = gtk.Frame()
        frame.set_border_width(6)
        frame.set_shadow_type(gtk.SHADOW_NONE)
        label = gtk.Label("<b>%s</b>" % labeltext)
        label.set_use_markup(True)
        frame.set_label_widget(label)
        return frame

    def get_description(self):
        buffer = self.description_textview.get_buffer()
        return buffer.get_text(*buffer.get_bounds())

    def get_name(self):
        return self.name_entry.get_text()

    def get_email(self):
        return self.email_entry.get_text()
