/* -*- C++ -*-
    Class to manipulate job execution in ThreadWeaver.

    SPDX-FileCopyrightText: 2005-2013 Mirko Boehm <mirko@kde.org>

    SPDX-License-Identifier: LGPL-2.0-or-later
*/

#include "executewrapper_p.h"

namespace ThreadWeaver
{
ExecuteWrapper::ExecuteWrapper()
{
}

Executor *ExecuteWrapper::wrap(Executor *previous)
{
    return wrapped.fetchAndStoreOrdered(previous);
}

Executor *ExecuteWrapper::unwrap(const JobPointer &job)
{
    Executor *executor = job->setExecutor(wrapped.fetchAndAddOrdered(0));
    Q_ASSERT_X(executor == this, Q_FUNC_INFO, "ExecuteWrapper can only unwrap itself!");
    wrapped.fetchAndStoreOrdered(nullptr);
    return executor;
}

void ExecuteWrapper::begin(const JobPointer &job, Thread *thread)
{
    Q_ASSERT(wrapped.loadAcquire() != nullptr);
    wrapped.loadAcquire()->begin(job, thread);
}

void ExecuteWrapper::execute(const JobPointer &job, Thread *thread)
{
    executeWrapped(job, thread);
}

void ExecuteWrapper::executeWrapped(const JobPointer &job, Thread *thread)
{
    Executor *executor = wrapped.loadAcquire();
    Q_ASSERT_X(executor != nullptr, Q_FUNC_INFO, "Wrapped Executor cannot be zero!");
    executor->execute(job, thread);
}

void ExecuteWrapper::end(const JobPointer &job, Thread *thread)
{
    Q_ASSERT(wrapped.loadAcquire() != nullptr);
    wrapped.loadAcquire()->end(job, thread);
}

}

#include "executewrapper_p.h"
