/*
 * Decompiled with CFR 0.152.
 */
package javax.tv.media;

import java.awt.Rectangle;

public class AWTVideoSize {
    private Rectangle source;
    private Rectangle dest;

    public AWTVideoSize(Rectangle source, Rectangle dest) {
        if (source == null || dest == null) {
            System.err.println("null rect");
            throw new NullPointerException("null rect");
        }
        this.source = (Rectangle)source.clone();
        this.dest = (Rectangle)dest.clone();
    }

    public Rectangle getSource() {
        return (Rectangle)this.source.clone();
    }

    public Rectangle getDestination() {
        return (Rectangle)this.dest.clone();
    }

    public float getXScale() {
        return this.dest.width / this.source.width;
    }

    public float getYScale() {
        return this.dest.height / this.source.height;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dest == null ? 0 : this.dest.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AWTVideoSize)) {
            return false;
        }
        AWTVideoSize other = (AWTVideoSize)obj;
        return this.dest.equals(other.dest) && this.source.equals(other.source);
    }

    public String toString() {
        return this.getClass().getName() + "[dest=" + this.dest + ",source=" + this.source + "]";
    }
}

