/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.daemon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.IVlOrderGiver;
import org.videolan.vlma.common.VlServer;
import org.videolan.vlma.common.adapters.IVlAdapter;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.medias.VlMediaGroup;
import org.videolan.vlma.common.orders.VlOrder;
import org.videolan.vlma.common.programs.IVlProgram;

public class VlOrderGiver
implements IVlOrderGiver {
    private static final Logger logger = Logger.getLogger(VlOrderGiver.class);
    private IVlData data;
    private Thread computingThread;
    private Runnable orderComputer = new Runnable(){

        public void run() {
            logger.log(Level.DEBUG, "Starting computing channels assignement.");
            HashMap<Integer, List<VlOrder>> orders = VlOrderGiver.this.data.getOrders();
            List<IVlMedia> medias = VlOrderGiver.this.data.getMedias();
            List<VlServer> servers = VlOrderGiver.this.data.getServers();
            HashMap programGroups = new HashMap();
            HashMap readyAdapters = new HashMap();
            HashMap<IVlAdapter, VlServer> readyAdaptersServers = new HashMap<IVlAdapter, VlServer>();
            int nbAdapters = 0;
            logger.log(Level.DEBUG, "Analysing available adapters.");
            for (VlServer s : servers) {
                if (!s.isUp()) continue;
                for (IVlAdapter a : s.getAdapters().values()) {
                    if (!a.isUp()) continue;
                    ArrayList<IVlAdapter> sameHashTypeAdapterList = (ArrayList<IVlAdapter>)readyAdapters.get(a.hashType());
                    if (sameHashTypeAdapterList == null) {
                        sameHashTypeAdapterList = new ArrayList<IVlAdapter>();
                        readyAdapters.put(a.hashType(), sameHashTypeAdapterList);
                    }
                    readyAdaptersServers.put(a, s);
                    sameHashTypeAdapterList.add(a);
                    ++nbAdapters;
                }
            }
            logger.log(Level.DEBUG, nbAdapters + " available adapters.");
            int nbMedias = 0;
            logger.log(Level.DEBUG, "Putting together media to stream.");
            block6: for (IVlMedia m : medias) {
                IVlProgram p = m.getProgram();
                if (p == null || !p.isTimeToPlay()) continue;
                logger.log(Level.DEBUG, "Media to be streamed: " + m.getName());
                for (Integer h : readyAdapters.keySet()) {
                    List sameHashTypeAdapterList = (List)readyAdapters.get(h);
                    if (((IVlAdapter)sameHashTypeAdapterList.get(0)).canRead(m)) {
                        ArrayList<VlMediaGroup> sameHashTypeGroupList = (ArrayList<VlMediaGroup>)programGroups.get(h);
                        if (sameHashTypeGroupList == null) {
                            sameHashTypeGroupList = new ArrayList<VlMediaGroup>();
                            programGroups.put(h, sameHashTypeGroupList);
                        }
                        VlMediaGroup mediaGroup = null;
                        for (VlMediaGroup j : sameHashTypeGroupList) {
                            if (!m.belongsToGroup(j)) continue;
                            mediaGroup = j;
                            break;
                        }
                        if (mediaGroup == null) {
                            mediaGroup = new VlMediaGroup();
                            sameHashTypeGroupList.add(mediaGroup);
                        }
                        mediaGroup.medias.add(m);
                        ++nbMedias;
                        continue block6;
                    }
                    logger.log(Level.DEBUG, "This adapter cannot stream " + m.getName());
                }
            }
            logger.log(Level.DEBUG, nbMedias + " media to stream.");
            logger.log(Level.DEBUG, "Assigning programms to adapters.");
            for (Integer c : readyAdapters.keySet()) {
                logger.log(Level.DEBUG, "Media type: " + c.toString());
                List sameHashTypeGroupList = (List)programGroups.get(c);
                List sameHashTypeAdapterList = (List)readyAdapters.get(c);
                logger.log(Level.DEBUG, sameHashTypeAdapterList.size() + " adapters.");
                if (sameHashTypeGroupList != null) {
                    Collections.sort(sameHashTypeGroupList);
                    logger.log(Level.DEBUG, sameHashTypeGroupList.size() + " media groups/");
                    int nbAdapters2 = sameHashTypeAdapterList.size();
                    while (sameHashTypeGroupList.size() > nbAdapters2) {
                        logger.log(Level.DEBUG, "This media group won't be streamed (priority " + ((VlMediaGroup)sameHashTypeGroupList.get(sameHashTypeGroupList.size() - 1)).getPriority() + ") :");
                        for (IVlMedia m : ((VlMediaGroup)sameHashTypeGroupList.get((int)(sameHashTypeGroupList.size() - 1))).medias) {
                            logger.log(Level.DEBUG, "- " + m.getName());
                        }
                        sameHashTypeGroupList.remove(sameHashTypeGroupList.size() - 1);
                    }
                }
                logger.log(Level.DEBUG, "Remove unused orders.");
                ArrayList oldOrders = new ArrayList();
                if (orders.containsKey(c)) {
                    oldOrders.addAll((Collection)orders.get(c));
                }
                logger.log(Level.DEBUG, oldOrders.size() + " former orders");
                if (sameHashTypeGroupList != null) {
                    Iterator groupIt = sameHashTypeGroupList.iterator();
                    block12: while (groupIt.hasNext()) {
                        VlMediaGroup g = (VlMediaGroup)groupIt.next();
                        Iterator orderIt = oldOrders.iterator();
                        while (orderIt.hasNext()) {
                            VlOrder order = (VlOrder)orderIt.next();
                            logger.log(Level.DEBUG, g.medias.size() + " media against " + order.getMedias().medias.size() + " media");
                            if (!order.getMedias().medias.containsAll(g.medias) || !g.medias.containsAll(order.getMedias().medias) || order.getServer().getIp() != g.medias.get(0).getProgram().getPlayer()) continue;
                            groupIt.remove();
                            sameHashTypeAdapterList.remove(order.getAdapter());
                            orderIt.remove();
                            continue block12;
                        }
                    }
                }
                for (VlOrder o : oldOrders) {
                    try {
                        o.stop();
                        for (IVlMedia media : o.getMedias().medias) {
                            if (media.getProgram() == null) continue;
                            media.getProgram().setPlayer(null);
                            media.getProgram().setBroadcastState(false);
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    ((List)orders.get(c)).remove(o);
                }
                if (!orders.containsKey(c)) {
                    orders.put(c, new ArrayList());
                }
                if (sameHashTypeGroupList == null) continue;
                logger.log(Level.DEBUG, "Creating new orders.");
                Iterator i = sameHashTypeGroupList.iterator();
                Iterator j = sameHashTypeAdapterList.iterator();
                while (i.hasNext() && j.hasNext()) {
                    VlMediaGroup g = (VlMediaGroup)i.next();
                    IVlAdapter a = (IVlAdapter)j.next();
                    VlServer adapterServer = a.getServer();
                    VlOrder o = new VlOrder();
                    o.setAdapter(a);
                    o.setServer(adapterServer);
                    o.setMedias(g);
                    logger.log(Level.DEBUG, "Assigning channels on adapter " + a.getName() + " of server " + adapterServer.getName());
                    for (IVlMedia media : o.getMedias().medias) {
                        media.getProgram().setPlayer(adapterServer.getIp());
                    }
                    try {
                        o.start();
                    }
                    catch (IOException e) {
                        adapterServer.setUp(false);
                    }
                    ((List)orders.get(c)).add(o);
                }
            }
        }
    };

    public VlOrderGiver(IVlData data) {
        this.data = data;
        this.computingThread = null;
    }

    public boolean isComputing() {
        return this.computingThread != null && this.computingThread.isAlive();
    }

    public synchronized void computeOrders() {
        if (!this.isComputing()) {
            this.computingThread = new Thread(this.orderComputer);
            this.computingThread.setName("OrderComputingThread");
            this.computingThread.start();
        }
    }
}

