/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.web.satellites;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.medias.VlSatellite;
import org.videolan.vlma.web.satellites.SatellitesAdd;

public class SatellitesEditFormController
extends SimpleFormController {
    private IVlData data;

    public IVlData getData() {
        return this.data;
    }

    public void setData(IVlData data) {
        this.data = data;
    }

    public ModelAndView onSubmit(Object command) throws ServletException, UnknownHostException {
        String satelliteCoverage = ((SatellitesAdd)command).getCoverage();
        int satelliteId = ((SatellitesAdd)command).getId();
        this.data.clearSatelliteCoverages(satelliteId);
        this.data.addSatelliteCoverage(satelliteId, satelliteCoverage);
        return new ModelAndView((View)new RedirectView(this.getSuccessView()));
    }

    protected Object formBackingObject(HttpServletRequest request) throws ServletException {
        SatellitesAdd satellitesAdd = new SatellitesAdd();
        int id = Integer.parseInt(request.getParameter("satellite"));
        VlSatellite satellite = this.data.getSatellite(id);
        if (satellite != null) {
            satellitesAdd.setName(satellite.getName());
            StringBuffer coverages = new StringBuffer();
            for (String coverage : satellite.getCoverages()) {
                coverages.append(coverage);
                coverages.append('\n');
            }
            satellitesAdd.setCoverage(coverages.toString());
        }
        satellitesAdd.setData(this.data);
        satellitesAdd.setId(id);
        return satellitesAdd;
    }

    protected ModelAndView showForm(HttpServletRequest arg0, HttpServletResponse arg1, BindException arg2, Map arg3) throws Exception {
        VlSatellite satellite = this.data.getSatellite(Integer.parseInt(arg0.getParameter("satellite")));
        HashMap<String, VlSatellite> m = new HashMap<String, VlSatellite>();
        m.put("satellite", satellite);
        return super.showForm(arg0, arg1, arg2, m);
    }
}

