/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import rath.msnm.BuddyGroup;
import rath.msnm.BuddyList;
import rath.msnm.GroupList;
import rath.msnm.entity.Group;
import rath.msnm.entity.MsnFriend;
import rath.msnm.msg.MimeUtility;

public class LocalCopy {
    public static final File DEFAULT_HOME_DIR = new File(System.getProperty("user.home"), ".jmsn");
    private final File homedir;
    private File userdir = null;
    private String loginName = null;
    private Properties setting = new Properties();

    public LocalCopy() {
        this.homedir = DEFAULT_HOME_DIR;
        this.homedir.mkdirs();
    }

    public LocalCopy(File dir) {
        if (dir.isFile()) {
            throw new IllegalArgumentException("dir is must be directory");
        }
        this.homedir = dir;
        this.homedir.mkdirs();
    }

    public File getHomeDirectory() {
        return this.homedir;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
        this.userdir = new File(this.homedir, loginName.toLowerCase());
        this.userdir.mkdirs();
    }

    public String getLoginName() {
        return this.loginName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInformation() {
        if (this.userdir == null) {
            throw new IllegalStateException("required setLoginName");
        }
        File file = new File(this.userdir, "setting.prop");
        if (!file.exists()) {
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.setting.load(fis);
            fis.close();
        }
        catch (IOException e) {
            System.err.println("cannot read local setting file: " + e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setProperty(String key, String value) {
        this.setting.setProperty(key, value);
    }

    public void setProperty(String key, boolean value) {
        this.setProperty(key, String.valueOf(value));
    }

    public String getProperty(String key) {
        return this.setting.getProperty(key);
    }

    public String getProperty(String key, String def) {
        return this.setting.getProperty(key, def);
    }

    public boolean getPropertyBoolean(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public boolean getPropertyBoolean(String key, boolean def) {
        String value = this.getProperty(key);
        if (value == null) {
            return def;
        }
        return Boolean.valueOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeInformation() {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(this.userdir, "setting.prop").getAbsolutePath());
            this.setting.store(fos, "JMSN setting");
            fos.flush();
            fos.close();
            fos = null;
        }
        catch (IOException e) {
            System.err.println("cannot write serial infomration file: " + e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void storeBuddies(BuddyGroup bg) {
        try {
            this.writeGroups(bg.getGroupList(), new File(this.userdir, "Groups.prop"));
            this.writeList(bg.getForwardList(), new File(this.userdir, "Forward"), true);
            this.writeList(bg.getReverseList(), new File(this.userdir, "Reverse"));
            this.writeList(bg.getAllowList(), new File(this.userdir, "Allow"));
            this.writeList(bg.getBlockList(), new File(this.userdir, "Block"));
        }
        catch (Exception e) {
            System.err.println("cannot write buddy list cache: " + e);
        }
    }

    public void loadBuddies(BuddyGroup bg) {
        try {
            this.readGroups(bg.getGroupList(), new File(this.userdir, "Groups.prop"));
            this.readList(bg.getForwardList(), new File(this.userdir, "Forward"), true);
            this.readList(bg.getReverseList(), new File(this.userdir, "Reverse"));
            this.readList(bg.getAllowList(), new File(this.userdir, "Allow"));
            this.readList(bg.getBlockList(), new File(this.userdir, "Block"));
        }
        catch (Exception e) {
            System.err.println("cannot read buddy list cache: " + e);
        }
    }

    private void readList(BuddyList list, File file) throws IOException {
        this.readList(list, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readList(BuddyList list, File file, boolean isFL) throws IOException {
        list.clear();
        if (!file.exists()) {
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] rec;
                MsnFriend friend = null;
                if (isFL) {
                    rec = line.split(",", 4);
                    friend = new MsnFriend(rec[0], rec[3]);
                    friend.setGroupIndex(rec[2]);
                    friend.setCode(rec[1]);
                } else {
                    rec = line.split(",", 2);
                    friend = new MsnFriend(rec[0], rec[1]);
                }
                list.add(friend);
            }
            br.close();
            fis.close();
            fis = null;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private void writeList(BuddyList list, File file) throws IOException {
        this.writeList(list, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeList(BuddyList list, File file, boolean isFL) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            PrintWriter out = new PrintWriter(fos);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                MsnFriend friend = (MsnFriend)i.next();
                out.print(friend.getLoginName());
                if (isFL) {
                    out.print(",");
                    out.print(friend.getCode());
                    out.print(",");
                    out.print(friend.getGroupIndex());
                }
                out.print(",");
                out.print(friend.getFriendlyName());
                out.println();
            }
            out.flush();
            out.close();
            fos.close();
            fos = null;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGroups(GroupList list, File file) throws IOException {
        FileOutputStream fos = null;
        Properties prop = new Properties();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Group group = (Group)i.next();
            prop.setProperty("group." + group.getIndex(), group.getName());
        }
        try {
            fos = new FileOutputStream(file);
            prop.store(fos, "JMSN Group cache file");
            fos.flush();
            fos.close();
            fos = null;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readGroups(GroupList list, File file) throws IOException {
        list.clear();
        if (!file.exists()) {
            return;
        }
        FileInputStream fis = null;
        Properties prop = new Properties();
        try {
            fis = new FileInputStream(file);
            prop.load(fis);
            Enumeration<?> e = prop.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = MimeUtility.getURLDecodedString(prop.getProperty(key), "UTF-8");
                if (key.indexOf(46) == -1) continue;
                String index = key.substring(key.indexOf(46) + 1);
                Group group = new Group(value, index);
                list.addGroup(group);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }
}

