# Contribution FAQ

## General

### Can I discuss my contribution ideas somewhere?

Sure thing! You can either open an Enhancement Proposal in our GitHub issue tracker or you can [join us on Slack](https://argoproj.github.io/community/join-slack) in channel #argo-contributors to discuss your ideas and get guidance for submitting a PR.

### No one has looked at my PR yet. Why?

As we have limited manpower, it can sometimes take a while for someone to respond to your PR. Especially, when your PR contains complex or non-obvious changes. Please bear with us, we try to look at every PR that we receive.

### Why has my PR been declined? I put much work in it!

We appreciate that you have put your valuable time and know how into a contribution. Alas, some changes do not fit into the overall ArgoCD philosophy, and therefore can't be merged into the official ArgoCD source tree.

To be on the safe side, make sure that you have created an Enhancement Proposal for your change before starting to work on your PR and have gathered enough feedback from the community and the maintainers.

### A check on my PR is failing.
See [Failing CI Checks](ci.md#troubleshooting-ci-checks).

### What checked-in code is generated, and how is it generated?
The following files under this repository are generated, and must be kept up-to-date. Also see [Why does the codegen step fail?](ci.md#why-does-the-codegen-step-fail).

See the Makefile for targets that can also run these scripts, and the `codegen` target which runs them all.

| Filename | Purpose | Generated by |
| -------- | ------- | ------------ |
| `*.pb.go`, `*.pb.gw.go` | [Protobuf](https://developers.google.com/protocol-buffers/docs/gotutorial) Interfaces | `hack/generate-proto.sh` |
| `assets/swagger.json` | Swagger 2 API spec | `hack/update-openapi.sh` |
| `manifests/` | k8s Installation Manifests | `hack/update-manifests.sh` |
| `docs/user-guide/commands` | CLI Documentation | `tools/cmd-docs/main.go` |
