# v3.0 to 3.1

## No more KubeVersions variable modification

Until v3.0, Argo CD removed `+` identifier from `kubeVersions` in Helm, Kustomize and Plugins. For example, if Argo CD receive `kubeVersions` as vX.Y.Z+, we convert to vX.Y.Z internally. Starting with v3.1, the internal conversation is entirely removed.

### Detection

To detect if you are affected, check the `kubeVersions` you are using. If you use `kubeVersions` including `+` identifier, the application must be failed when you upgrade from v3.0 to v3.1.

### Remediation

The plus symbol was originally removed [because Helm did not support it](https://github.com/argoproj/argo-cd/issues/2303). Helm no longer enforces this restriction, so apps should work fine even if your kubeVersions include `+`.

However, since Argo CD now sends unmodified kubeVersions to Helm, the generated manifests may differ due to the changed kubeVersions. For apps which require extra caution, it may be advisable to disable auto-sync, upgrade, check any diffs, and then reenable auto-sync.

## Symlink protection in API `--staticassets` directory

The `--staticassets` directory in the API server (`/app/shared` by default) is now protected against out-of-bounds
symlinks. This is to help protect against symlink attacks. If you have any symlinks in your `--staticassets` directory
to a location outside the directory, they will return a 500 error starting with 3.1.

## OpenID Connect authorization code flow with PKCE is now handled by the server instead of the UI

Previously, when PKCE was enabled, the authorization code flow (the process which happens when you log in to Argo CD using OpenID Connect) was handled by the UI, whereas this flow was handled by the server if PKCE was not enabled. The server now always handles this flow, PKCE being enabled or not.

### Detection

To check whether PKCE is used or not, run the following command:

```shell
kubectl get cm argocd-cm -o=jsonpath="{.data.oidc\.config}" | grep enablePKCEAuthentication
```

If it returns `"enablePKCEAuthentication": true`, then PKCE is used.

### Remediation

On your identity provider, ensure that the OIDC client used for Argo CD has the `/auth/callback` endpoint of your Argo CD URL (e.g. https://argocd.example.com/auth/callback) in the redirect URIs.
