// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// BgpPeer State of a BGP Peer
//
// +k8s:deepcopy-gen=true
//
// swagger:model BgpPeer
type BgpPeer struct {

	// BGP peer address family state
	Families []*BgpPeerFamilies `json:"families"`

	// Local AS Number
	LocalAsn int64 `json:"local-asn,omitempty"`

	// IP Address of peer
	PeerAddress string `json:"peer-address,omitempty"`

	// Peer AS Number
	PeerAsn int64 `json:"peer-asn,omitempty"`

	// BGP peer operational state as described here
	// https://www.rfc-editor.org/rfc/rfc4271#section-8.2.2
	//
	SessionState string `json:"session-state,omitempty"`

	// BGP peer connection uptime in nano seconds.
	UptimeNanoseconds int64 `json:"uptime-nanoseconds,omitempty"`
}

// Validate validates this bgp peer
func (m *BgpPeer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFamilies(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeer) validateFamilies(formats strfmt.Registry) error {
	if swag.IsZero(m.Families) { // not required
		return nil
	}

	for i := 0; i < len(m.Families); i++ {
		if swag.IsZero(m.Families[i]) { // not required
			continue
		}

		if m.Families[i] != nil {
			if err := m.Families[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("families" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("families" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this bgp peer based on the context it is used
func (m *BgpPeer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFamilies(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeer) contextValidateFamilies(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Families); i++ {

		if m.Families[i] != nil {
			if err := m.Families[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("families" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("families" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *BgpPeer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BgpPeer) UnmarshalBinary(b []byte) error {
	var res BgpPeer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
