// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package v2alpha1

import (
	"context"
	"time"

	v2alpha1 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2alpha1"
	scheme "github.com/cilium/cilium/pkg/k8s/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CiliumPodIPPoolsGetter has a method to return a CiliumPodIPPoolInterface.
// A group's client should implement this interface.
type CiliumPodIPPoolsGetter interface {
	CiliumPodIPPools() CiliumPodIPPoolInterface
}

// CiliumPodIPPoolInterface has methods to work with CiliumPodIPPool resources.
type CiliumPodIPPoolInterface interface {
	Create(ctx context.Context, ciliumPodIPPool *v2alpha1.CiliumPodIPPool, opts v1.CreateOptions) (*v2alpha1.CiliumPodIPPool, error)
	Update(ctx context.Context, ciliumPodIPPool *v2alpha1.CiliumPodIPPool, opts v1.UpdateOptions) (*v2alpha1.CiliumPodIPPool, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2alpha1.CiliumPodIPPool, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2alpha1.CiliumPodIPPoolList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumPodIPPool, err error)
	CiliumPodIPPoolExpansion
}

// ciliumPodIPPools implements CiliumPodIPPoolInterface
type ciliumPodIPPools struct {
	client rest.Interface
}

// newCiliumPodIPPools returns a CiliumPodIPPools
func newCiliumPodIPPools(c *CiliumV2alpha1Client) *ciliumPodIPPools {
	return &ciliumPodIPPools{
		client: c.RESTClient(),
	}
}

// Get takes name of the ciliumPodIPPool, and returns the corresponding ciliumPodIPPool object, and an error if there is any.
func (c *ciliumPodIPPools) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2alpha1.CiliumPodIPPool, err error) {
	result = &v2alpha1.CiliumPodIPPool{}
	err = c.client.Get().
		Resource("ciliumpodippools").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CiliumPodIPPools that match those selectors.
func (c *ciliumPodIPPools) List(ctx context.Context, opts v1.ListOptions) (result *v2alpha1.CiliumPodIPPoolList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v2alpha1.CiliumPodIPPoolList{}
	err = c.client.Get().
		Resource("ciliumpodippools").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ciliumPodIPPools.
func (c *ciliumPodIPPools) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("ciliumpodippools").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a ciliumPodIPPool and creates it.  Returns the server's representation of the ciliumPodIPPool, and an error, if there is any.
func (c *ciliumPodIPPools) Create(ctx context.Context, ciliumPodIPPool *v2alpha1.CiliumPodIPPool, opts v1.CreateOptions) (result *v2alpha1.CiliumPodIPPool, err error) {
	result = &v2alpha1.CiliumPodIPPool{}
	err = c.client.Post().
		Resource("ciliumpodippools").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumPodIPPool).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a ciliumPodIPPool and updates it. Returns the server's representation of the ciliumPodIPPool, and an error, if there is any.
func (c *ciliumPodIPPools) Update(ctx context.Context, ciliumPodIPPool *v2alpha1.CiliumPodIPPool, opts v1.UpdateOptions) (result *v2alpha1.CiliumPodIPPool, err error) {
	result = &v2alpha1.CiliumPodIPPool{}
	err = c.client.Put().
		Resource("ciliumpodippools").
		Name(ciliumPodIPPool.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumPodIPPool).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the ciliumPodIPPool and deletes it. Returns an error if one occurs.
func (c *ciliumPodIPPools) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("ciliumpodippools").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ciliumPodIPPools) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("ciliumpodippools").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched ciliumPodIPPool.
func (c *ciliumPodIPPools) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumPodIPPool, err error) {
	result = &v2alpha1.CiliumPodIPPool{}
	err = c.client.Patch(pt).
		Resource("ciliumpodippools").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
