// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// BackendAddress Service backend address
//
// swagger:model BackendAddress
type BackendAddress struct {

	// Layer 3 address
	// Required: true
	IP *string `json:"ip"`

	// Optional name of the node on which this backend runs
	NodeName string `json:"nodeName,omitempty"`

	// Layer 4 port number
	Port uint16 `json:"port,omitempty"`

	// Indicator if this backend is preferred in the context of clustermesh service affinity. The value is set based
	// on related annotation of global service. Applicable for active state only.
	Preferred bool `json:"preferred,omitempty"`

	// State of the backend for load-balancing service traffic
	// Enum: [active terminating quarantined maintenance]
	State string `json:"state,omitempty"`

	// Backend weight
	Weight *uint16 `json:"weight,omitempty"`
}

// Validate validates this backend address
func (m *BackendAddress) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BackendAddress) validateIP(formats strfmt.Registry) error {

	if err := validate.Required("ip", "body", m.IP); err != nil {
		return err
	}

	return nil
}

var backendAddressTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["active","terminating","quarantined","maintenance"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendAddressTypeStatePropEnum = append(backendAddressTypeStatePropEnum, v)
	}
}

const (

	// BackendAddressStateActive captures enum value "active"
	BackendAddressStateActive string = "active"

	// BackendAddressStateTerminating captures enum value "terminating"
	BackendAddressStateTerminating string = "terminating"

	// BackendAddressStateQuarantined captures enum value "quarantined"
	BackendAddressStateQuarantined string = "quarantined"

	// BackendAddressStateMaintenance captures enum value "maintenance"
	BackendAddressStateMaintenance string = "maintenance"
)

// prop value enum
func (m *BackendAddress) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendAddressTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendAddress) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this backend address based on context it is used
func (m *BackendAddress) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *BackendAddress) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BackendAddress) UnmarshalBinary(b []byte) error {
	var res BackendAddress
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
