// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// BgpRoutePolicy Single BGP route policy retrieved from the underlying router
//
// swagger:model BgpRoutePolicy
type BgpRoutePolicy struct {

	// Name of the route policy
	Name string `json:"name,omitempty"`

	// Autonomous System Number (ASN) identifying a BGP virtual router instance
	RouterAsn int64 `json:"router-asn,omitempty"`

	// List of the route policy statements
	Statements []*BgpRoutePolicyStatement `json:"statements"`

	// Type of the route policy
	// Enum: [export import]
	Type string `json:"type,omitempty"`
}

// Validate validates this bgp route policy
func (m *BgpRoutePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatements(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpRoutePolicy) validateStatements(formats strfmt.Registry) error {
	if swag.IsZero(m.Statements) { // not required
		return nil
	}

	for i := 0; i < len(m.Statements); i++ {
		if swag.IsZero(m.Statements[i]) { // not required
			continue
		}

		if m.Statements[i] != nil {
			if err := m.Statements[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("statements" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var bgpRoutePolicyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["export","import"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		bgpRoutePolicyTypeTypePropEnum = append(bgpRoutePolicyTypeTypePropEnum, v)
	}
}

const (

	// BgpRoutePolicyTypeExport captures enum value "export"
	BgpRoutePolicyTypeExport string = "export"

	// BgpRoutePolicyTypeImport captures enum value "import"
	BgpRoutePolicyTypeImport string = "import"
)

// prop value enum
func (m *BgpRoutePolicy) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, bgpRoutePolicyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BgpRoutePolicy) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this bgp route policy based on the context it is used
func (m *BgpRoutePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStatements(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpRoutePolicy) contextValidateStatements(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Statements); i++ {

		if m.Statements[i] != nil {

			if swag.IsZero(m.Statements[i]) { // not required
				return nil
			}

			if err := m.Statements[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("statements" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *BgpRoutePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BgpRoutePolicy) UnmarshalBinary(b []byte) error {
	var res BgpRoutePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
