// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

package common

const (
	// Miscellaneous dedicated constants

	// CHeaderFileName is the name of the C header file for BPF programs for a
	// particular endpoint.
	CHeaderFileName = "ep_config.h"

	// EndpointStateFileName is used as the file name for the JSON representation
	// of endpoint state.
	EndpointStateFileName = "ep_config.json"

	// PossibleCPUSysfsPath is used to retrieve the number of CPUs for per-CPU maps.
	PossibleCPUSysfsPath = "/sys/devices/system/cpu/possible"
)
