// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2017-2020 Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// PathStatus Connectivity status via different paths, for example using different
// policies or service redirection
//
//
// swagger:model PathStatus
type PathStatus struct {

	// Connectivity status without policy applied
	HTTP *ConnectivityStatus `json:"http,omitempty"`

	// Basic ping connectivity status to node IP
	Icmp *ConnectivityStatus `json:"icmp,omitempty"`

	// IP address queried for the connectivity status
	IP string `json:"ip,omitempty"`
}

// Validate validates this path status
func (m *PathStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHTTP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIcmp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PathStatus) validateHTTP(formats strfmt.Registry) error {

	if swag.IsZero(m.HTTP) { // not required
		return nil
	}

	if m.HTTP != nil {
		if err := m.HTTP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("http")
			}
			return err
		}
	}

	return nil
}

func (m *PathStatus) validateIcmp(formats strfmt.Registry) error {

	if swag.IsZero(m.Icmp) { // not required
		return nil
	}

	if m.Icmp != nil {
		if err := m.Icmp.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("icmp")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PathStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PathStatus) UnmarshalBinary(b []byte) error {
	var res PathStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
