// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2017-2021 Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package endpoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// GetEndpointIDLabelsReader is a Reader for the GetEndpointIDLabels structure.
type GetEndpointIDLabelsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetEndpointIDLabelsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetEndpointIDLabelsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewGetEndpointIDLabelsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetEndpointIDLabelsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewGetEndpointIDLabelsOK creates a GetEndpointIDLabelsOK with default headers values
func NewGetEndpointIDLabelsOK() *GetEndpointIDLabelsOK {
	return &GetEndpointIDLabelsOK{}
}

/*GetEndpointIDLabelsOK handles this case with default header values.

Success
*/
type GetEndpointIDLabelsOK struct {
	Payload *models.LabelConfiguration
}

func (o *GetEndpointIDLabelsOK) Error() string {
	return fmt.Sprintf("[GET /endpoint/{id}/labels][%d] getEndpointIdLabelsOK  %+v", 200, o.Payload)
}

func (o *GetEndpointIDLabelsOK) GetPayload() *models.LabelConfiguration {
	return o.Payload
}

func (o *GetEndpointIDLabelsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LabelConfiguration)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetEndpointIDLabelsNotFound creates a GetEndpointIDLabelsNotFound with default headers values
func NewGetEndpointIDLabelsNotFound() *GetEndpointIDLabelsNotFound {
	return &GetEndpointIDLabelsNotFound{}
}

/*GetEndpointIDLabelsNotFound handles this case with default header values.

Endpoint not found
*/
type GetEndpointIDLabelsNotFound struct {
}

func (o *GetEndpointIDLabelsNotFound) Error() string {
	return fmt.Sprintf("[GET /endpoint/{id}/labels][%d] getEndpointIdLabelsNotFound ", 404)
}

func (o *GetEndpointIDLabelsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetEndpointIDLabelsTooManyRequests creates a GetEndpointIDLabelsTooManyRequests with default headers values
func NewGetEndpointIDLabelsTooManyRequests() *GetEndpointIDLabelsTooManyRequests {
	return &GetEndpointIDLabelsTooManyRequests{}
}

/*GetEndpointIDLabelsTooManyRequests handles this case with default header values.

Rate-limiting too many requests in the given time frame
*/
type GetEndpointIDLabelsTooManyRequests struct {
}

func (o *GetEndpointIDLabelsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /endpoint/{id}/labels][%d] getEndpointIdLabelsTooManyRequests ", 429)
}

func (o *GetEndpointIDLabelsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}
