# etcd functional test suite

etcd functional test suite tests the functionality of an etcd cluster with a focus on failure resistance under high pressure. It sets up an etcd cluster and inject failures into the cluster by killing the process or isolate the network of the process. It expects the etcd cluster to recover within a short amount of time after fixing the fault.

etcd functional test suite has two components: etcd-agent and etcd-tester. etcd-agent runs on every test machines and etcd-tester is a single controller of the test. etcd-tester controls all the etcd-agent to start etcd clusters and simulate various failure cases.

## requirements

The environment of the cluster must be stable enough, so etcd test suite can assume that most of the failures are generated by itself.

## etcd agent

etcd agent is a daemon on each machines. It can start, stop, restart, isolate and terminate an etcd process. The agent exposes these functionality via HTTP RPC.

## etcd tester

etcd functional tester control the progress of the functional tests. It calls the RPC of the etcd agent to simulate various test cases. For example, it can start a three members cluster by sending three start RPC calls to three different etcd agents. It can make one of the member failed by sending stop RPC call to one etcd agent.

### Run locally

```
$ PASSES=functional ./test
```

### Run with Docker

To run locally, first build tester image:

```bash
pushd ../..

GO_VERSION=1.9.3 \
  make build-docker-functional-tester \
  -f ./hack/scripts-dev/Makefile

popd
```

And run [example scripts](./scripts).

```bash
./scripts/agent-1.sh
./scripts/agent-2.sh
./scripts/agent-3.sh

./scripts/tester-limit.sh
```
