// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: rpcpb/rpc.proto

package rpcpb

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type StresserType int32

const (
	StresserType_KV_WRITE_SMALL      StresserType = 0
	StresserType_KV_WRITE_LARGE      StresserType = 1
	StresserType_KV_READ_ONE_KEY     StresserType = 2
	StresserType_KV_READ_RANGE       StresserType = 3
	StresserType_KV_DELETE_ONE_KEY   StresserType = 4
	StresserType_KV_DELETE_RANGE     StresserType = 5
	StresserType_KV_TXN_WRITE_DELETE StresserType = 6
	StresserType_LEASE               StresserType = 10
	StresserType_ELECTION_RUNNER     StresserType = 20
	StresserType_WATCH_RUNNER        StresserType = 31
	StresserType_LOCK_RACER_RUNNER   StresserType = 41
	StresserType_LEASE_RUNNER        StresserType = 51
)

var StresserType_name = map[int32]string{
	0:  "KV_WRITE_SMALL",
	1:  "KV_WRITE_LARGE",
	2:  "KV_READ_ONE_KEY",
	3:  "KV_READ_RANGE",
	4:  "KV_DELETE_ONE_KEY",
	5:  "KV_DELETE_RANGE",
	6:  "KV_TXN_WRITE_DELETE",
	10: "LEASE",
	20: "ELECTION_RUNNER",
	31: "WATCH_RUNNER",
	41: "LOCK_RACER_RUNNER",
	51: "LEASE_RUNNER",
}

var StresserType_value = map[string]int32{
	"KV_WRITE_SMALL":      0,
	"KV_WRITE_LARGE":      1,
	"KV_READ_ONE_KEY":     2,
	"KV_READ_RANGE":       3,
	"KV_DELETE_ONE_KEY":   4,
	"KV_DELETE_RANGE":     5,
	"KV_TXN_WRITE_DELETE": 6,
	"LEASE":               10,
	"ELECTION_RUNNER":     20,
	"WATCH_RUNNER":        31,
	"LOCK_RACER_RUNNER":   41,
	"LEASE_RUNNER":        51,
}

func (x StresserType) String() string {
	return proto.EnumName(StresserType_name, int32(x))
}

func (StresserType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4fbc93a8dcc3881e, []int{0}
}

type Checker int32

const (
	Checker_KV_HASH                Checker = 0
	Checker_LEASE_EXPIRE           Checker = 1
	Checker_RUNNER                 Checker = 2
	Checker_NO_CHECK               Checker = 3
	Checker_SHORT_TTL_LEASE_EXPIRE Checker = 4
)

var Checker_name = map[int32]string{
	0: "KV_HASH",
	1: "LEASE_EXPIRE",
	2: "RUNNER",
	3: "NO_CHECK",
	4: "SHORT_TTL_LEASE_EXPIRE",
}

var Checker_value = map[string]int32{
	"KV_HASH":                0,
	"LEASE_EXPIRE":           1,
	"RUNNER":                 2,
	"NO_CHECK":               3,
	"SHORT_TTL_LEASE_EXPIRE": 4,
}

func (x Checker) String() string {
	return proto.EnumName(Checker_name, int32(x))
}

func (Checker) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4fbc93a8dcc3881e, []int{1}
}

type Operation int32

const (
	// NOT_STARTED is the agent status before etcd first start.
	Operation_NOT_STARTED Operation = 0
	// INITIAL_START_ETCD is only called to start etcd, the very first time.
	Operation_INITIAL_START_ETCD Operation = 10
	// RESTART_ETCD is sent to restart killed etcd.
	Operation_RESTART_ETCD Operation = 11
	// SIGTERM_ETCD pauses etcd process while keeping data directories
	// and previous etcd configurations.
	Operation_SIGTERM_ETCD Operation = 20
	// SIGQUIT_ETCD_AND_REMOVE_DATA kills etcd process and removes all data
	// directories to simulate destroying the whole machine.
	Operation_SIGQUIT_ETCD_AND_REMOVE_DATA Operation = 21
	// SAVE_SNAPSHOT is sent to trigger local member to download its snapshot
	// onto its local disk with the specified path from tester.
	Operation_SAVE_SNAPSHOT Operation = 30
	// RESTORE_RESTART_FROM_SNAPSHOT is sent to trigger local member to
	// restore a cluster from existing snapshot from disk, and restart
	// an etcd instance from recovered data.
	Operation_RESTORE_RESTART_FROM_SNAPSHOT Operation = 31
	// RESTART_FROM_SNAPSHOT is sent to trigger local member to restart
	// and join an existing cluster that has been recovered from a snapshot.
	// Local member joins this cluster with fresh data.
	Operation_RESTART_FROM_SNAPSHOT Operation = 32
	// SIGQUIT_ETCD_AND_ARCHIVE_DATA is sent when consistency check failed,
	// thus need to archive etcd data directories.
	Operation_SIGQUIT_ETCD_AND_ARCHIVE_DATA Operation = 40
	// SIGQUIT_ETCD_AND_REMOVE_DATA_AND_STOP_AGENT destroys etcd process,
	// etcd data, and agent server.
	Operation_SIGQUIT_ETCD_AND_REMOVE_DATA_AND_STOP_AGENT Operation = 41
	// BLACKHOLE_PEER_PORT_TX_RX drops all outgoing/incoming packets from/to
	// the peer port on target member's peer port.
	Operation_BLACKHOLE_PEER_PORT_TX_RX Operation = 100
	// UNBLACKHOLE_PEER_PORT_TX_RX removes outgoing/incoming packet dropping.
	Operation_UNBLACKHOLE_PEER_PORT_TX_RX Operation = 101
	// DELAY_PEER_PORT_TX_RX delays all outgoing/incoming packets from/to
	// the peer port on target member's peer port.
	Operation_DELAY_PEER_PORT_TX_RX Operation = 200
	// UNDELAY_PEER_PORT_TX_RX removes all outgoing/incoming delays.
	Operation_UNDELAY_PEER_PORT_TX_RX Operation = 201
)

var Operation_name = map[int32]string{
	0:   "NOT_STARTED",
	10:  "INITIAL_START_ETCD",
	11:  "RESTART_ETCD",
	20:  "SIGTERM_ETCD",
	21:  "SIGQUIT_ETCD_AND_REMOVE_DATA",
	30:  "SAVE_SNAPSHOT",
	31:  "RESTORE_RESTART_FROM_SNAPSHOT",
	32:  "RESTART_FROM_SNAPSHOT",
	40:  "SIGQUIT_ETCD_AND_ARCHIVE_DATA",
	41:  "SIGQUIT_ETCD_AND_REMOVE_DATA_AND_STOP_AGENT",
	100: "BLACKHOLE_PEER_PORT_TX_RX",
	101: "UNBLACKHOLE_PEER_PORT_TX_RX",
	200: "DELAY_PEER_PORT_TX_RX",
	201: "UNDELAY_PEER_PORT_TX_RX",
}

var Operation_value = map[string]int32{
	"NOT_STARTED":                                 0,
	"INITIAL_START_ETCD":                          10,
	"RESTART_ETCD":                                11,
	"SIGTERM_ETCD":                                20,
	"SIGQUIT_ETCD_AND_REMOVE_DATA":                21,
	"SAVE_SNAPSHOT":                               30,
	"RESTORE_RESTART_FROM_SNAPSHOT":               31,
	"RESTART_FROM_SNAPSHOT":                       32,
	"SIGQUIT_ETCD_AND_ARCHIVE_DATA":               40,
	"SIGQUIT_ETCD_AND_REMOVE_DATA_AND_STOP_AGENT": 41,
	"BLACKHOLE_PEER_PORT_TX_RX":                   100,
	"UNBLACKHOLE_PEER_PORT_TX_RX":                 101,
	"DELAY_PEER_PORT_TX_RX":                       200,
	"UNDELAY_PEER_PORT_TX_RX":                     201,
}

func (x Operation) String() string {
	return proto.EnumName(Operation_name, int32(x))
}

func (Operation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4fbc93a8dcc3881e, []int{2}
}

// Case defines various system faults or test case in distributed systems,
// in order to verify correct behavior of etcd servers and clients.
type Case int32

const (
	// SIGTERM_ONE_FOLLOWER stops a randomly chosen follower (non-leader)
	// but does not delete its data directories on disk for next restart.
	// It waits "delay-ms" before recovering this failure.
	// The expected behavior is that the follower comes back online
	// and rejoins the cluster, and then each member continues to process
	// client requests ('Put' request that requires Raft consensus).
	Case_SIGTERM_ONE_FOLLOWER Case = 0
	// SIGTERM_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT stops a randomly chosen
	// follower but does not delete its data directories on disk for next
	// restart. And waits until most up-to-date node (leader) applies the
	// snapshot count of entries since the stop operation.
	// The expected behavior is that the follower comes back online and
	// rejoins the cluster, and then active leader sends snapshot
	// to the follower to force it to follow the leader's log.
	// As always, after recovery, each member must be able to process
	// client requests.
	Case_SIGTERM_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT Case = 1
	// SIGTERM_LEADER stops the active leader node but does not delete its
	// data directories on disk for next restart. Then it waits "delay-ms"
	// before recovering this failure, in order to trigger election timeouts.
	// The expected behavior is that a new leader gets elected, and the
	// old leader comes back online and rejoins the cluster as a follower.
	// As always, after recovery, each member must be able to process
	// client requests.
	Case_SIGTERM_LEADER Case = 2
	// SIGTERM_LEADER_UNTIL_TRIGGER_SNAPSHOT stops the active leader node
	// but does not delete its data directories on disk for next restart.
	// And waits until most up-to-date node ("new" leader) applies the
	// snapshot count of entries since the stop operation.
	// The expected behavior is that cluster elects a new leader, and the
	// old leader comes back online and rejoins the cluster as a follower.
	// And it receives the snapshot from the new leader to overwrite its
	// store. As always, after recovery, each member must be able to
	// process client requests.
	Case_SIGTERM_LEADER_UNTIL_TRIGGER_SNAPSHOT Case = 3
	// SIGTERM_QUORUM stops majority number of nodes to make the whole cluster
	// inoperable but does not delete data directories on stopped nodes
	// for next restart. And it waits "delay-ms" before recovering failure.
	// The expected behavior is that nodes come back online, thus cluster
	// comes back operative as well. As always, after recovery, each member
	// must be able to process client requests.
	Case_SIGTERM_QUORUM Case = 4
	// SIGTERM_ALL stops the whole cluster but does not delete data directories
	// on disk for next restart. And it waits "delay-ms" before  recovering
	// this failure.
	// The expected behavior is that nodes come back online, thus cluster
	// comes back operative as well. As always, after recovery, each member
	// must be able to process client requests.
	Case_SIGTERM_ALL Case = 5
	// SIGQUIT_AND_REMOVE_ONE_FOLLOWER stops a randomly chosen follower
	// (non-leader), deletes its data directories on disk, and removes
	// this member from cluster (membership reconfiguration). On recovery,
	// tester adds a new member, and this member joins the existing cluster
	// with fresh data. It waits "delay-ms" before recovering this
	// failure. This simulates destroying one follower machine, where operator
	// needs to add a new member from a fresh machine.
	// The expected behavior is that a new member joins the existing cluster,
	// and then each member continues to process client requests.
	Case_SIGQUIT_AND_REMOVE_ONE_FOLLOWER Case = 10
	// SIGQUIT_AND_REMOVE_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT stops a randomly
	// chosen follower, deletes its data directories on disk, and removes
	// this member from cluster (membership reconfiguration). On recovery,
	// tester adds a new member, and this member joins the existing cluster
	// restart. On member remove, cluster waits until most up-to-date node
	// (leader) applies the snapshot count of entries since the stop operation.
	// This simulates destroying a leader machine, where operator needs to add
	// a new member from a fresh machine.
	// The expected behavior is that a new member joins the existing cluster,
	// and receives a snapshot from the active leader. As always, after
	// recovery, each member must be able to process client requests.
	Case_SIGQUIT_AND_REMOVE_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT Case = 11
	// SIGQUIT_AND_REMOVE_LEADER stops the active leader node, deletes its
	// data directories on disk, and removes this member from cluster.
	// On recovery, tester adds a new member, and this member joins the
	// existing cluster with fresh data. It waits "delay-ms" before
	// recovering this failure. This simulates destroying a leader machine,
	// where operator needs to add a new member from a fresh machine.
	// The expected behavior is that a new member joins the existing cluster,
	// and then each member continues to process client requests.
	Case_SIGQUIT_AND_REMOVE_LEADER Case = 12
	// SIGQUIT_AND_REMOVE_LEADER_UNTIL_TRIGGER_SNAPSHOT stops the active leader,
	// deletes its data directories on disk, and removes this member from
	// cluster (membership reconfiguration). On recovery, tester adds a new
	// member, and this member joins the existing cluster restart. On member
	// remove, cluster waits until most up-to-date node (new leader) applies
	// the snapshot count of entries since the stop operation. This simulates
	// destroying a leader machine, where operator needs to add a new member
	// from a fresh machine.
	// The expected behavior is that on member remove, cluster elects a new
	// leader, and a new member joins the existing cluster and receives a
	// snapshot from the newly elected leader. As always, after recovery, each
	// member must be able to process client requests.
	Case_SIGQUIT_AND_REMOVE_LEADER_UNTIL_TRIGGER_SNAPSHOT Case = 13
	// SIGQUIT_AND_REMOVE_QUORUM_AND_RESTORE_LEADER_SNAPSHOT_FROM_SCRATCH first
	// stops majority number of nodes, deletes data directories on those quorum
	// nodes, to make the whole cluster inoperable. Now that quorum and their
	// data are totally destroyed, cluster cannot even remove unavailable nodes
	// (e.g. 2 out of 3 are lost, so no leader can be elected).
	// Let's assume 3-node cluster of node A, B, and C. One day, node A and B
	// are destroyed and all their data are gone. The only viable solution is
	// to recover from C's latest snapshot.
	//
	// To simulate:
	//  1. Assume node C is the current leader with most up-to-date data.
	//  2. Download snapshot from node C, before destroying node A and B.
	//  3. Destroy node A and B, and make the whole cluster inoperable.
	//  4. Now node C cannot operate either.
	//  5. SIGTERM node C and remove its data directories.
	//  6. Restore a new seed member from node C's latest snapshot file.
	//  7. Add another member to establish 2-node cluster.
	//  8. Add another member to establish 3-node cluster.
	//  9. Add more if any.
	//
	// The expected behavior is that etcd successfully recovers from such
	// disastrous situation as only 1-node survives out of 3-node cluster,
	// new members joins the existing cluster, and previous data from snapshot
	// are still preserved after recovery process. As always, after recovery,
	// each member must be able to process client requests.
	Case_SIGQUIT_AND_REMOVE_QUORUM_AND_RESTORE_LEADER_SNAPSHOT_FROM_SCRATCH Case = 14
	// BLACKHOLE_PEER_PORT_TX_RX_ONE_FOLLOWER drops all outgoing/incoming
	// packets from/to the peer port on a randomly chosen follower
	// (non-leader), and waits for "delay-ms" until recovery.
	// The expected behavior is that once dropping operation is undone,
	// each member must be able to process client requests.
	Case_BLACKHOLE_PEER_PORT_TX_RX_ONE_FOLLOWER Case = 100
	// BLACKHOLE_PEER_PORT_TX_RX_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT drops
	// all outgoing/incoming packets from/to the peer port on a randomly
	// chosen follower (non-leader), and waits for most up-to-date node
	// (leader) applies the snapshot count of entries since the blackhole
	// operation.
	// The expected behavior is that once packet drop operation is undone,
	// the slow follower tries to catch up, possibly receiving the snapshot
	// from the active leader. As always, after recovery, each member must
	// be able to process client requests.
	Case_BLACKHOLE_PEER_PORT_TX_RX_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT Case = 101
	// BLACKHOLE_PEER_PORT_TX_RX_LEADER drops all outgoing/incoming packets
	// from/to the peer port on the active leader (isolated), and waits for
	// "delay-ms" until recovery, in order to trigger election timeout.
	// The expected behavior is that after election timeout, a new leader gets
	// elected, and once dropping operation is undone, the old leader comes
	// back and rejoins the cluster as a follower. As always, after recovery,
	// each member must be able to process client requests.
	Case_BLACKHOLE_PEER_PORT_TX_RX_LEADER Case = 102
	// BLACKHOLE_PEER_PORT_TX_RX_LEADER_UNTIL_TRIGGER_SNAPSHOT drops all
	// outgoing/incoming packets from/to the peer port on the active leader,
	// and waits for most up-to-date node (leader) applies the snapshot
	// count of entries since the blackhole operation.
	// The expected behavior is that cluster elects a new leader, and once
	// dropping operation is undone, the old leader comes back and rejoins
	// the cluster as a follower. The slow follower tries to catch up, likely
	// receiving the snapshot from the new active leader. As always, after
	// recovery, each member must be able to process client requests.
	Case_BLACKHOLE_PEER_PORT_TX_RX_LEADER_UNTIL_TRIGGER_SNAPSHOT Case = 103
	// BLACKHOLE_PEER_PORT_TX_RX_QUORUM drops all outgoing/incoming packets
	// from/to the peer ports on majority nodes of cluster, thus losing its
	// leader and cluster being inoperable. And it waits for "delay-ms"
	// until recovery.
	// The expected behavior is that once packet drop operation is undone,
	// nodes come back online, thus cluster comes back operative. As always,
	// after recovery, each member must be able to process client requests.
	Case_BLACKHOLE_PEER_PORT_TX_RX_QUORUM Case = 104
	// BLACKHOLE_PEER_PORT_TX_RX_ALL drops all outgoing/incoming packets
	// from/to the peer ports on all nodes, thus making cluster totally
	// inoperable. It waits for "delay-ms" until recovery.
	// The expected behavior is that once packet drop operation is undone,
	// nodes come back online, thus cluster comes back operative. As always,
	// after recovery, each member must be able to process client requests.
	Case_BLACKHOLE_PEER_PORT_TX_RX_ALL Case = 105
	// DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER delays outgoing/incoming packets
	// from/to the peer port on a randomly chosen follower (non-leader).
	// It waits for "delay-ms" until recovery.
	// The expected behavior is that once packet delay operation is undone,
	// the follower comes back and tries to catch up with latest changes from
	// cluster. And as always, after recovery, each member must be able to
	// process client requests.
	Case_DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER Case = 200
	// RANDOM_DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER delays outgoing/incoming
	// packets from/to the peer port on a randomly chosen follower
	// (non-leader) with a randomized time duration (thus isolated). It
	// waits for "delay-ms" until recovery.
	// The expected behavior is that once packet delay operation is undone,
	// each member must be able to process client requests.
	Case_RANDOM_DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER Case = 201
	// DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT delays
	// outgoing/incoming packets from/to the peer port on a randomly chosen
	// follower (non-leader), and waits for most up-to-date node (leader)
	// applies the snapshot count of entries since the delay operation.
	// The expected behavior is that the delayed follower gets isolated
	// and behind the current active leader, and once delay operation is undone,
	// the slow follower comes back and catches up possibly receiving snapshot
	// from the active leader. As always, after recovery, each member must be
	// able to process client requests.
	Case_DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT Case = 202
	// RANDOM_DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT delays
	// outgoing/incoming packets from/to the peer port on a randomly chosen
	// follower (non-leader) with a randomized time duration, and waits for
	// most up-to-date node (leader) applies the snapshot count of entries
	// since the delay operation.
	// The expected behavior is that the delayed follower gets isolated
	// and behind the current active leader, and once delay operation is undone,
	// the slow follower comes back and catches up, possibly receiving a
	// snapshot from the active leader. As always, after recovery, each member
	// must be able to process client requests.
	Case_RANDOM_DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT Case = 203
	// DELAY_PEER_PORT_TX_RX_LEADER delays outgoing/incoming packets from/to
	// the peer port on the active leader. And waits for "delay-ms" until
	// recovery.
	// The expected behavior is that cluster may elect a new leader, and
	// once packet delay operation is undone, the (old) leader comes back
	// and tries to catch up with latest changes from cluster. As always,
	// after recovery, each member must be able to process client requests.
	Case_DELAY_PEER_PORT_TX_RX_LEADER Case = 204
	// RANDOM_DELAY_PEER_PORT_TX_RX_LEADER delays outgoing/incoming packets
	// from/to the peer port on the active leader with a randomized time
	// duration. And waits for "delay-ms" until recovery.
	// The expected behavior is that cluster may elect a new leader, and
	// once packet delay operation is undone, the (old) leader comes back
	// and tries to catch up with latest changes from cluster. As always,
	// after recovery, each member must be able to process client requests.
	Case_RANDOM_DELAY_PEER_PORT_TX_RX_LEADER Case = 205
	// DELAY_PEER_PORT_TX_RX_LEADER_UNTIL_TRIGGER_SNAPSHOT delays
	// outgoing/incoming packets from/to the peer port on the active leader,
	// and waits for most up-to-date node (current or new leader) applies the
	// snapshot count of entries since the delay operation.
	// The expected behavior is that cluster may elect a new leader, and
	// the old leader gets isolated and behind the current active leader,
	// and once delay operation is undone, the slow follower comes back
	// and catches up, likely receiving a snapshot from the active leader.
	// As always, after recovery, each member must be able to process client
	// requests.
	Case_DELAY_PEER_PORT_TX_RX_LEADER_UNTIL_TRIGGER_SNAPSHOT Case = 206
	// RANDOM_DELAY_PEER_PORT_TX_RX_LEADER_UNTIL_TRIGGER_SNAPSHOT delays
	// outgoing/incoming packets from/to the peer port on the active leader,
	// with a randomized time duration. And it waits for most up-to-date node
	// (current or new leader) applies the snapshot count of entries since the
	// delay operation.
	// The expected behavior is that cluster may elect a new leader, and
	// the old leader gets isolated and behind the current active leader,
	// and once delay operation is undone, the slow follower comes back
	// and catches up, likely receiving a snapshot from the active leader.
	// As always, after recovery, each member must be able to process client
	// requests.
	Case_RANDOM_DELAY_PEER_PORT_TX_RX_LEADER_UNTIL_TRIGGER_SNAPSHOT Case = 207
	// DELAY_PEER_PORT_TX_RX_QUORUM delays outgoing/incoming packets from/to
	// the peer ports on majority nodes of cluster. And it waits for
	// "delay-ms" until recovery, likely to trigger election timeouts.
	// The expected behavior is that cluster may elect a new leader, while
	// quorum of nodes struggle with slow networks, and once delay operation
	// is undone, nodes come back and cluster comes back operative. As always,
	// after recovery, each member must be able to process client requests.
	Case_DELAY_PEER_PORT_TX_RX_QUORUM Case = 208
	// RANDOM_DELAY_PEER_PORT_TX_RX_QUORUM delays outgoing/incoming packets
	// from/to the peer ports on majority nodes of cluster, with randomized
	// time durations. And it waits for "delay-ms" until recovery, likely
	// to trigger election timeouts.
	// The expected behavior is that cluster may elect a new leader, while
	// quorum of nodes struggle with slow networks, and once delay operation
	// is undone, nodes come back and cluster comes back operative. As always,
	// after recovery, each member must be able to process client requests.
	Case_RANDOM_DELAY_PEER_PORT_TX_RX_QUORUM Case = 209
	// DELAY_PEER_PORT_TX_RX_ALL delays outgoing/incoming packets from/to the
	// peer ports on all nodes. And it waits for "delay-ms" until recovery,
	// likely to trigger election timeouts.
	// The expected behavior is that cluster may become totally inoperable,
	// struggling with slow networks across the whole cluster. Once delay
	// operation is undone, nodes come back and cluster comes back operative.
	// As always, after recovery, each member must be able to process client
	// requests.
	Case_DELAY_PEER_PORT_TX_RX_ALL Case = 210
	// RANDOM_DELAY_PEER_PORT_TX_RX_ALL delays outgoing/incoming packets
	// from/to the peer ports on all nodes, with randomized time durations.
	// And it waits for "delay-ms" until recovery, likely to trigger
	// election timeouts.
	// The expected behavior is that cluster may become totally inoperable,
	// struggling with slow networks across the whole cluster. Once delay
	// operation is undone, nodes come back and cluster comes back operative.
	// As always, after recovery, each member must be able to process client
	// requests.
	Case_RANDOM_DELAY_PEER_PORT_TX_RX_ALL Case = 211
	// NO_FAIL_WITH_STRESS stops injecting failures while testing the
	// consistency and correctness under pressure loads, for the duration of
	// "delay-ms". Goal is to ensure cluster be still making progress
	// on recovery, and verify system does not deadlock following a sequence
	// of failure injections.
	// The expected behavior is that cluster remains fully operative in healthy
	// condition. As always, after recovery, each member must be able to process
	// client requests.
	Case_NO_FAIL_WITH_STRESS Case = 300
	// NO_FAIL_WITH_NO_STRESS_FOR_LIVENESS neither injects failures nor
	// sends stressig client requests to the cluster, for the duration of
	// "delay-ms". Goal is to ensure cluster be still making progress
	// on recovery, and verify system does not deadlock following a sequence
	// of failure injections.
	// The expected behavior is that cluster remains fully operative in healthy
	// condition, and clients requests during liveness period succeed without
	// errors.
	// Note: this is how Google Chubby does failure injection testing
	// https://static.googleusercontent.com/media/research.google.com/en//archive/paxos_made_live.pdf.
	Case_NO_FAIL_WITH_NO_STRESS_FOR_LIVENESS Case = 301
	// FAILPOINTS injects failpoints to etcd server runtime, triggering panics
	// in critical code paths.
	Case_FAILPOINTS Case = 400
	// FAILPOINTS_WITH_DISK_IO_LATENCY injects high disk I/O latency failure in raftAfterSave code paths.
	Case_FAILPOINTS_WITH_DISK_IO_LATENCY Case = 401
	// EXTERNAL runs external failure injection scripts.
	Case_EXTERNAL Case = 500
)

var Case_name = map[int32]string{
	0:   "SIGTERM_ONE_FOLLOWER",
	1:   "SIGTERM_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT",
	2:   "SIGTERM_LEADER",
	3:   "SIGTERM_LEADER_UNTIL_TRIGGER_SNAPSHOT",
	4:   "SIGTERM_QUORUM",
	5:   "SIGTERM_ALL",
	10:  "SIGQUIT_AND_REMOVE_ONE_FOLLOWER",
	11:  "SIGQUIT_AND_REMOVE_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT",
	12:  "SIGQUIT_AND_REMOVE_LEADER",
	13:  "SIGQUIT_AND_REMOVE_LEADER_UNTIL_TRIGGER_SNAPSHOT",
	14:  "SIGQUIT_AND_REMOVE_QUORUM_AND_RESTORE_LEADER_SNAPSHOT_FROM_SCRATCH",
	100: "BLACKHOLE_PEER_PORT_TX_RX_ONE_FOLLOWER",
	101: "BLACKHOLE_PEER_PORT_TX_RX_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT",
	102: "BLACKHOLE_PEER_PORT_TX_RX_LEADER",
	103: "BLACKHOLE_PEER_PORT_TX_RX_LEADER_UNTIL_TRIGGER_SNAPSHOT",
	104: "BLACKHOLE_PEER_PORT_TX_RX_QUORUM",
	105: "BLACKHOLE_PEER_PORT_TX_RX_ALL",
	200: "DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER",
	201: "RANDOM_DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER",
	202: "DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT",
	203: "RANDOM_DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT",
	204: "DELAY_PEER_PORT_TX_RX_LEADER",
	205: "RANDOM_DELAY_PEER_PORT_TX_RX_LEADER",
	206: "DELAY_PEER_PORT_TX_RX_LEADER_UNTIL_TRIGGER_SNAPSHOT",
	207: "RANDOM_DELAY_PEER_PORT_TX_RX_LEADER_UNTIL_TRIGGER_SNAPSHOT",
	208: "DELAY_PEER_PORT_TX_RX_QUORUM",
	209: "RANDOM_DELAY_PEER_PORT_TX_RX_QUORUM",
	210: "DELAY_PEER_PORT_TX_RX_ALL",
	211: "RANDOM_DELAY_PEER_PORT_TX_RX_ALL",
	300: "NO_FAIL_WITH_STRESS",
	301: "NO_FAIL_WITH_NO_STRESS_FOR_LIVENESS",
	400: "FAILPOINTS",
	401: "FAILPOINTS_WITH_DISK_IO_LATENCY",
	500: "EXTERNAL",
}

var Case_value = map[string]int32{
	"SIGTERM_ONE_FOLLOWER":                                               0,
	"SIGTERM_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT":                        1,
	"SIGTERM_LEADER":                                                     2,
	"SIGTERM_LEADER_UNTIL_TRIGGER_SNAPSHOT":                              3,
	"SIGTERM_QUORUM":                                                     4,
	"SIGTERM_ALL":                                                        5,
	"SIGQUIT_AND_REMOVE_ONE_FOLLOWER":                                    10,
	"SIGQUIT_AND_REMOVE_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT":             11,
	"SIGQUIT_AND_REMOVE_LEADER":                                          12,
	"SIGQUIT_AND_REMOVE_LEADER_UNTIL_TRIGGER_SNAPSHOT":                   13,
	"SIGQUIT_AND_REMOVE_QUORUM_AND_RESTORE_LEADER_SNAPSHOT_FROM_SCRATCH": 14,
	"BLACKHOLE_PEER_PORT_TX_RX_ONE_FOLLOWER":                             100,
	"BLACKHOLE_PEER_PORT_TX_RX_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT":      101,
	"BLACKHOLE_PEER_PORT_TX_RX_LEADER":                                   102,
	"BLACKHOLE_PEER_PORT_TX_RX_LEADER_UNTIL_TRIGGER_SNAPSHOT":            103,
	"BLACKHOLE_PEER_PORT_TX_RX_QUORUM":                                   104,
	"BLACKHOLE_PEER_PORT_TX_RX_ALL":                                      105,
	"DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER":                                 200,
	"RANDOM_DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER":                          201,
	"DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT":          202,
	"RANDOM_DELAY_PEER_PORT_TX_RX_ONE_FOLLOWER_UNTIL_TRIGGER_SNAPSHOT":   203,
	"DELAY_PEER_PORT_TX_RX_LEADER":                                       204,
	"RANDOM_DELAY_PEER_PORT_TX_RX_LEADER":                                205,
	"DELAY_PEER_PORT_TX_RX_LEADER_UNTIL_TRIGGER_SNAPSHOT":                206,
	"RANDOM_DELAY_PEER_PORT_TX_RX_LEADER_UNTIL_TRIGGER_SNAPSHOT":         207,
	"DELAY_PEER_PORT_TX_RX_QUORUM":                                       208,
	"RANDOM_DELAY_PEER_PORT_TX_RX_QUORUM":                                209,
	"DELAY_PEER_PORT_TX_RX_ALL":                                          210,
	"RANDOM_DELAY_PEER_PORT_TX_RX_ALL":                                   211,
	"NO_FAIL_WITH_STRESS":                                                300,
	"NO_FAIL_WITH_NO_STRESS_FOR_LIVENESS":                                301,
	"FAILPOINTS":                                                         400,
	"FAILPOINTS_WITH_DISK_IO_LATENCY":                                    401,
	"EXTERNAL":                                                           500,
}

func (x Case) String() string {
	return proto.EnumName(Case_name, int32(x))
}

func (Case) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4fbc93a8dcc3881e, []int{3}
}

type Request struct {
	Operation Operation `protobuf:"varint,1,opt,name=Operation,proto3,enum=rpcpb.Operation" json:"Operation,omitempty"`
	// Member contains the same Member object from tester configuration.
	Member *Member `protobuf:"bytes,2,opt,name=Member,proto3" json:"Member,omitempty"`
	// Tester contains tester configuration.
	Tester               *Tester  `protobuf:"bytes,3,opt,name=Tester,proto3" json:"Tester,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Request) Reset()         { *m = Request{} }
func (m *Request) String() string { return proto.CompactTextString(m) }
func (*Request) ProtoMessage()    {}
func (*Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_4fbc93a8dcc3881e, []int{0}
}
func (m *Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Request.Merge(m, src)
}
func (m *Request) XXX_Size() int {
	return m.Size()
}
func (m *Request) XXX_DiscardUnknown() {
	xxx_messageInfo_Request.DiscardUnknown(m)
}

var xxx_messageInfo_Request proto.InternalMessageInfo

// SnapshotInfo contains SAVE_SNAPSHOT request results.
type SnapshotInfo struct {
	MemberName           string   `protobuf:"bytes,1,opt,name=MemberName,proto3" json:"MemberName,omitempty"`
	MemberClientURLs     []string `protobuf:"bytes,2,rep,name=MemberClientURLs,proto3" json:"MemberClientURLs,omitempty"`
	SnapshotPath         string   `protobuf:"bytes,3,opt,name=SnapshotPath,proto3" json:"SnapshotPath,omitempty"`
	SnapshotFileSize     string   `protobuf:"bytes,4,opt,name=SnapshotFileSize,proto3" json:"SnapshotFileSize,omitempty"`
	SnapshotTotalSize    string   `protobuf:"bytes,5,opt,name=SnapshotTotalSize,proto3" json:"SnapshotTotalSize,omitempty"`
	SnapshotTotalKey     int64    `protobuf:"varint,6,opt,name=SnapshotTotalKey,proto3" json:"SnapshotTotalKey,omitempty"`
	SnapshotHash         int64    `protobuf:"varint,7,opt,name=SnapshotHash,proto3" json:"SnapshotHash,omitempty"`
	SnapshotRevision     int64    `protobuf:"varint,8,opt,name=SnapshotRevision,proto3" json:"SnapshotRevision,omitempty"`
	Took                 string   `protobuf:"bytes,9,opt,name=Took,proto3" json:"Took,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SnapshotInfo) Reset()         { *m = SnapshotInfo{} }
func (m *SnapshotInfo) String() string { return proto.CompactTextString(m) }
func (*SnapshotInfo) ProtoMessage()    {}
func (*SnapshotInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_4fbc93a8dcc3881e, []int{1}
}
func (m *SnapshotInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SnapshotInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SnapshotInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SnapshotInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SnapshotInfo.Merge(m, src)
}
func (m *SnapshotInfo) XXX_Size() int {
	return m.Size()
}
func (m *SnapshotInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SnapshotInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SnapshotInfo proto.InternalMessageInfo

type Response struct {
	Success bool   `protobuf:"varint,1,opt,name=Success,proto3" json:"Success,omitempty"`
	Status  string `protobuf:"bytes,2,opt,name=Status,proto3" json:"Status,omitempty"`
	// Member contains the same Member object from tester request.
	Member *Member `protobuf:"bytes,3,opt,name=Member,proto3" json:"Member,omitempty"`
	// SnapshotInfo contains SAVE_SNAPSHOT request results.
	SnapshotInfo         *SnapshotInfo `protobuf:"bytes,4,opt,name=SnapshotInfo,proto3" json:"SnapshotInfo,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Response) Reset()         { *m = Response{} }
func (m *Response) String() string { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()    {}
func (*Response) Descriptor() ([]byte, []int) {
	return fileDescriptor_4fbc93a8dcc3881e, []int{2}
}
func (m *Response) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Response) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Response.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Response) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Response.Merge(m, src)
}
func (m *Response) XXX_Size() int {
	return m.Size()
}
func (m *Response) XXX_DiscardUnknown() {
	xxx_messageInfo_Response.DiscardUnknown(m)
}

var xxx_messageInfo_Response proto.InternalMessageInfo

type Member struct {
	// EtcdExec is the executable etcd binary path in agent server.
	EtcdExec string `protobuf:"bytes,1,opt,name=EtcdExec,proto3" json:"EtcdExec,omitempty" yaml:"etcd-exec"`
	// AgentAddr is the agent HTTP server address.
	AgentAddr string `protobuf:"bytes,11,opt,name=AgentAddr,proto3" json:"AgentAddr,omitempty" yaml:"agent-addr"`
	// FailpointHTTPAddr is the agent's failpoints HTTP server address.
	FailpointHTTPAddr string `protobuf:"bytes,12,opt,name=FailpointHTTPAddr,proto3" json:"FailpointHTTPAddr,omitempty" yaml:"failpoint-http-addr"`
	// BaseDir is the base directory where all logs and etcd data are stored.
	BaseDir string `protobuf:"bytes,101,opt,name=BaseDir,proto3" json:"BaseDir,omitempty" yaml:"base-dir"`
	// EtcdClientProxy is true when client traffic needs to be proxied.
	// If true, listen client URL port must be different than advertise client URL port.
	EtcdClientProxy bool `protobuf:"varint,201,opt,name=EtcdClientProxy,proto3" json:"EtcdClientProxy,omitempty" yaml:"etcd-client-proxy"`
	// EtcdPeerProxy is true when peer traffic needs to be proxied.
	// If true, listen peer URL port must be different than advertise peer URL port.
	EtcdPeerProxy bool `protobuf:"varint,202,opt,name=EtcdPeerProxy,proto3" json:"EtcdPeerProxy,omitempty" yaml:"etcd-peer-proxy"`
	// EtcdClientEndpoint is the etcd client endpoint.
	EtcdClientEndpoint string `protobuf:"bytes,301,opt,name=EtcdClientEndpoint,proto3" json:"EtcdClientEndpoint,omitempty" yaml:"etcd-client-endpoint"`
	// Etcd defines etcd binary configuration flags.
	Etcd *Etcd `protobuf:"bytes,302,opt,name=Etcd,proto3" json:"Etcd,omitempty" yaml:"etcd"`
	// EtcdOnSnapshotRestore defines one-time use configuration during etcd
	// snapshot recovery process.
	EtcdOnSnapshotRestore *Etcd `protobuf:"bytes,303,opt,name=EtcdOnSnapshotRestore,proto3" json:"EtcdOnSnapshotRestore,omitempty"`
	// ClientCertData contains cert file contents from this member's etcd server.
	ClientCertData string `protobuf:"bytes,401,opt,name=ClientCertData,proto3" json:"ClientCertData,omitempty" yaml:"client-cert-data"`
	ClientCertPath string `protobuf:"bytes,402,opt,name=ClientCertPath,proto3" json:"ClientCertPath,omitempty" yaml:"client-cert-path"`
	// ClientKeyData contains key file contents from this member's etcd server.
	ClientKeyData string `protobuf:"bytes,403,opt,name=ClientKeyData,proto3" json:"ClientKeyData,omitempty" yaml:"client-key-data"`
	ClientKeyPath string `protobuf:"bytes,404,opt,name=ClientKeyPath,proto3" json:"ClientKeyPath,omitempty" yaml:"client-key-path"`
	// ClientTrustedCAData contains trusted CA file contents from this member's etcd server.
	ClientTrustedCAData string `protobuf:"bytes,405,opt,name=ClientTrustedCAData,proto3" json:"ClientTrustedCAData,omitempty" yaml:"client-trusted-ca-data"`
	ClientTrustedCAPath string `protobuf:"bytes,406,opt,name=ClientTrustedCAPath,proto3" json:"ClientTrustedCAPath,omitempty" yaml:"client-trusted-ca-path"`
	// PeerCertData contains cert file contents from this member's etcd server.
	PeerCertData string `protobuf:"bytes,501,opt,name=PeerCertData,proto3" json:"PeerCertData,omitempty" yaml:"peer-cert-data"`
	PeerCertPath string `protobuf:"bytes,502,opt,name=PeerCertPath,proto3" json:"PeerCertPath,omitempty" yaml:"peer-cert-path"`
	// PeerKeyData contains key file contents from this member's etcd server.
	PeerKeyData string `protobuf:"bytes,503,opt,name=PeerKeyData,proto3" json:"PeerKeyData,omitempty" yaml:"peer-key-data"`
	PeerKeyPath string `protobuf:"bytes,504,opt,name=PeerKeyPath,proto3" json:"PeerKeyPath,omitempty" yaml:"peer-key-path"`
	// PeerTrustedCAData contains trusted CA file contents from this member's etcd server.
	PeerTrustedCAData string `protobuf:"bytes,505,opt,name=PeerTrustedCAData,proto3" json:"PeerTrustedCAData,omitempty" yaml:"peer-trusted-ca-data"`
	PeerTrustedCAPath string `protobuf:"bytes,506,opt,name=PeerTrustedCAPath,proto3" json:"PeerTrustedCAPath,omitempty" yaml:"peer-trusted-ca-path"`
	// SnapshotPath is the snapshot file path to store or restore from.
	SnapshotPath string `protobuf:"bytes,601,opt,name=SnapshotPath,proto3" json:"SnapshotPath,omitempty" yaml:"snapshot-path"`
	// SnapshotInfo contains last SAVE_SNAPSHOT request results.
	SnapshotInfo *SnapshotInfo `protobuf:"bytes,602,opt,name=SnapshotInfo,proto3" json:"SnapshotInfo,omitempty"`
	// Failpoints is the GOFAIL_FAILPOINTS environment variable value to use when starting etcd.
	Failpoints           string   `protobuf:"bytes,701,opt,name=Failpoints,proto3" json:"Failpoints,omitempty" yaml:"failpoints"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Member) Reset()         { *m = Member{} }
func (m *Member) String() string { return proto.CompactTextString(m) }
func (*Member) ProtoMessage()    {}
func (*Member) Descriptor() ([]byte, []int) {
	return fileDescriptor_4fbc93a8dcc3881e, []int{3}
}
func (m *Member) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Member) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Member.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Member) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Member.Merge(m, src)
}
func (m *Member) XXX_Size() int {
	return m.Size()
}
func (m *Member) XXX_DiscardUnknown() {
	xxx_messageInfo_Member.DiscardUnknown(m)
}

var xxx_messageInfo_Member proto.InternalMessageInfo

type Tester struct {
	DataDir string `protobuf:"bytes,1,opt,name=DataDir,proto3" json:"DataDir,omitempty" yaml:"data-dir"`
	Network string `protobuf:"bytes,2,opt,name=Network,proto3" json:"Network,omitempty" yaml:"network"`
	Addr    string `protobuf:"bytes,3,opt,name=Addr,proto3" json:"Addr,omitempty" yaml:"addr"`
	// DelayLatencyMsRv is the delay latency in milliseconds,
	// to inject to simulated slow network.
	DelayLatencyMs uint32 `protobuf:"varint,11,opt,name=DelayLatencyMs,proto3" json:"DelayLatencyMs,omitempty" yaml:"delay-latency-ms"`
	// DelayLatencyMsRv is the delay latency random variable in milliseconds.
	DelayLatencyMsRv uint32 `protobuf:"varint,12,opt,name=DelayLatencyMsRv,proto3" json:"DelayLatencyMsRv,omitempty" yaml:"delay-latency-ms-rv"`
	// UpdatedDelayLatencyMs is the update delay latency in milliseconds,
	// to inject to simulated slow network. It's the final latency to apply,
	// in case the latency numbers are randomly generated from given delay latency field.
	UpdatedDelayLatencyMs uint32 `protobuf:"varint,13,opt,name=UpdatedDelayLatencyMs,proto3" json:"UpdatedDelayLatencyMs,omitempty" yaml:"updated-delay-latency-ms"`
	// RoundLimit is the limit of rounds to run failure set (-1 to run without limits).
	RoundLimit int32 `protobuf:"varint,21,opt,name=RoundLimit,proto3" json:"RoundLimit,omitempty" yaml:"round-limit"`
	// ExitOnCaseFail is true, then exit tester on first failure.
	ExitOnCaseFail bool `protobuf:"varint,22,opt,name=ExitOnCaseFail,proto3" json:"ExitOnCaseFail,omitempty" yaml:"exit-on-failure"`
	// EnablePprof is true to enable profiler.
	EnablePprof bool `protobuf:"varint,23,opt,name=EnablePprof,proto3" json:"EnablePprof,omitempty" yaml:"enable-pprof"`
	// CaseDelayMs is the delay duration after failure is injected.
	// Useful when triggering snapshot or no-op failure cases.
	CaseDelayMs uint32 `protobuf:"varint,31,opt,name=CaseDelayMs,proto3" json:"CaseDelayMs,omitempty" yaml:"case-delay-ms"`
	// CaseShuffle is true to randomize failure injecting order.
	CaseShuffle bool `protobuf:"varint,32,opt,name=CaseShuffle,proto3" json:"CaseShuffle,omitempty" yaml:"case-shuffle"`
	// Cases is the selected test cases to schedule.
	// If empty, run all failure cases.
	Cases []string `protobuf:"bytes,33,rep,name=Cases,proto3" json:"Cases,omitempty" yaml:"cases"`
	// FailpointCommands is the list of "gofail" commands
	// (e.g. panic("etcd-tester"),1*sleep(1000).
	FailpointCommands []string `protobuf:"bytes,34,rep,name=FailpointCommands,proto3" json:"FailpointCommands,omitempty" yaml:"failpoint-commands"`
	// RunnerExecPath is a path of etcd-runner binary.
	RunnerExecPath string `protobuf:"bytes,41,opt,name=RunnerExecPath,proto3" json:"RunnerExecPath,omitempty" yaml:"runner-exec-path"`
	// ExternalExecPath is a path of script for enabling/disabling an external fault injector.
	ExternalExecPath string `protobuf:"bytes,42,opt,name=ExternalExecPath,proto3" json:"ExternalExecPath,omitempty" yaml:"external-exec-path"`
	// Stressers is the list of stresser types:
	// KV, LEASE, ELECTION_RUNNER, WATCH_RUNNER, LOCK_RACER_RUNNER, LEASE_RUNNER.
	Stressers []*Stresser `protobuf:"bytes,101,rep,name=Stressers,proto3" json:"Stressers,omitempty" yaml:"stressers"`
	// Checkers is the list of consistency checker types:
	// KV_HASH, LEASE_EXPIRE, NO_CHECK, RUNNER.
	// Leave empty to skip consistency checks.
	Checkers []string `protobuf:"bytes,102,rep,name=Checkers,proto3" json:"Checkers,omitempty" yaml:"checkers"`
	// StressKeySize is the size of each small key written into etcd.
	StressKeySize int32 `protobuf:"varint,201,opt,name=StressKeySize,proto3" json:"StressKeySize,omitempty" yaml:"stress-key-size"`
	// StressKeySizeLarge is the size of each large key written into etcd.
	StressKeySizeLarge int32 `protobuf:"varint,202,opt,name=StressKeySizeLarge,proto3" json:"StressKeySizeLarge,omitempty" yaml:"stress-key-size-large"`
	// StressKeySuffixRange is the count of key range written into etcd.
	// Stress keys are created with "fmt.Sprintf("foo%016x", rand.Intn(keySuffixRange)".
	StressKeySuffixRange int32 `protobuf:"varint,203,opt,name=StressKeySuffixRange,proto3" json:"StressKeySuffixRange,omitempty" yaml:"stress-key-suffix-range"`
	// StressKeySuffixRangeTxn is the count of key range written into etcd txn (max 100).
	// Stress keys are created with "fmt.Sprintf("/k%03d", i)".
	StressKeySuffixRangeTxn int32 `protobuf:"varint,204,opt,name=StressKeySuffixRangeTxn,proto3" json:"StressKeySuffixRangeTxn,omitempty" yaml:"stress-key-suffix-range-txn"`
	// StressKeyTxnOps is the number of operations per a transaction (max 64).
	StressKeyTxnOps int32 `protobuf:"varint,205,opt,name=StressKeyTxnOps,proto3" json:"StressKeyTxnOps,omitempty" yaml:"stress-key-txn-ops"`
	// StressClients is the number of concurrent stressing clients
	// with "one" shared TCP connection.
	StressClients int32 `protobuf:"varint,301,opt,name=StressClients,proto3" json:"StressClients,omitempty" yaml:"stress-clients"`
	// StressQPS is the maximum number of stresser requests per second.
	StressQPS            int32    `protobuf:"varint,302,opt,name=StressQPS,proto3" json:"StressQPS,omitempty" yaml:"stress-qps"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tester) Reset()         { *m = Tester{} }
func (m *Tester) String() string { return proto.CompactTextString(m) }
func (*Tester) ProtoMessage()    {}
func (*Tester) Descriptor() ([]byte, []int) {
	return fileDescriptor_4fbc93a8dcc3881e, []int{4}
}
func (m *Tester) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tester) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tester.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tester) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tester.Merge(m, src)
}
func (m *Tester) XXX_Size() int {
	return m.Size()
}
func (m *Tester) XXX_DiscardUnknown() {
	xxx_messageInfo_Tester.DiscardUnknown(m)
}

var xxx_messageInfo_Tester proto.InternalMessageInfo

type Stresser struct {
	Type                 string   `protobuf:"bytes,1,opt,name=Type,proto3" json:"Type,omitempty" yaml:"type"`
	Weight               float64  `protobuf:"fixed64,2,opt,name=Weight,proto3" json:"Weight,omitempty" yaml:"weight"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Stresser) Reset()         { *m = Stresser{} }
func (m *Stresser) String() string { return proto.CompactTextString(m) }
func (*Stresser) ProtoMessage()    {}
func (*Stresser) Descriptor() ([]byte, []int) {
	return fileDescriptor_4fbc93a8dcc3881e, []int{5}
}
func (m *Stresser) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Stresser) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Stresser.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Stresser) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Stresser.Merge(m, src)
}
func (m *Stresser) XXX_Size() int {
	return m.Size()
}
func (m *Stresser) XXX_DiscardUnknown() {
	xxx_messageInfo_Stresser.DiscardUnknown(m)
}

var xxx_messageInfo_Stresser proto.InternalMessageInfo

type Etcd struct {
	Name    string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty" yaml:"name"`
	DataDir string `protobuf:"bytes,2,opt,name=DataDir,proto3" json:"DataDir,omitempty" yaml:"data-dir"`
	WALDir  string `protobuf:"bytes,3,opt,name=WALDir,proto3" json:"WALDir,omitempty" yaml:"wal-dir"`
	// HeartbeatIntervalMs is the time (in milliseconds) of a heartbeat interval.
	// Default value is 100, which is 100ms.
	HeartbeatIntervalMs int64 `protobuf:"varint,11,opt,name=HeartbeatIntervalMs,proto3" json:"HeartbeatIntervalMs,omitempty" yaml:"heartbeat-interval"`
	// ElectionTimeoutMs is the time (in milliseconds) for an election to timeout.
	// Default value is 1000, which is 1s.
	ElectionTimeoutMs   int64    `protobuf:"varint,12,opt,name=ElectionTimeoutMs,proto3" json:"ElectionTimeoutMs,omitempty" yaml:"election-timeout"`
	ListenClientURLs    []string `protobuf:"bytes,21,rep,name=ListenClientURLs,proto3" json:"ListenClientURLs,omitempty" yaml:"listen-client-urls"`
	AdvertiseClientURLs []string `protobuf:"bytes,22,rep,name=AdvertiseClientURLs,proto3" json:"AdvertiseClientURLs,omitempty" yaml:"advertise-client-urls"`
	ClientAutoTLS       bool     `protobuf:"varint,23,opt,name=ClientAutoTLS,proto3" json:"ClientAutoTLS,omitempty" yaml:"auto-tls"`
	ClientCertAuth      bool     `protobuf:"varint,24,opt,name=ClientCertAuth,proto3" json:"ClientCertAuth,omitempty" yaml:"client-cert-auth"`
	ClientCertFile      string   `protobuf:"bytes,25,opt,name=ClientCertFile,proto3" json:"ClientCertFile,omitempty" yaml:"cert-file"`
	ClientKeyFile       string   `protobuf:"bytes,26,opt,name=ClientKeyFile,proto3" json:"ClientKeyFile,omitempty" yaml:"key-file"`
	ClientTrustedCAFile string   `protobuf:"bytes,27,opt,name=ClientTrustedCAFile,proto3" json:"ClientTrustedCAFile,omitempty" yaml:"trusted-ca-file"`
	ListenPeerURLs      []string `protobuf:"bytes,31,rep,name=ListenPeerURLs,proto3" json:"ListenPeerURLs,omitempty" yaml:"listen-peer-urls"`
	AdvertisePeerURLs   []string `protobuf:"bytes,32,rep,name=AdvertisePeerURLs,proto3" json:"AdvertisePeerURLs,omitempty" yaml:"initial-advertise-peer-urls"`
	PeerAutoTLS         bool     `protobuf:"varint,33,opt,name=PeerAutoTLS,proto3" json:"PeerAutoTLS,omitempty" yaml:"peer-auto-tls"`
	PeerClientCertAuth  bool     `protobuf:"varint,34,opt,name=PeerClientCertAuth,proto3" json:"PeerClientCertAuth,omitempty" yaml:"peer-client-cert-auth"`
	PeerCertFile        string   `protobuf:"bytes,35,opt,name=PeerCertFile,proto3" json:"PeerCertFile,omitempty" yaml:"peer-cert-file"`
	PeerKeyFile         string   `protobuf:"bytes,36,opt,name=PeerKeyFile,proto3" json:"PeerKeyFile,omitempty" yaml:"peer-key-file"`
	PeerTrustedCAFile   string   `protobuf:"bytes,37,opt,name=PeerTrustedCAFile,proto3" json:"PeerTrustedCAFile,omitempty" yaml:"peer-trusted-ca-file"`
	InitialCluster      string   `protobuf:"bytes,41,opt,name=InitialCluster,proto3" json:"InitialCluster,omitempty" yaml:"initial-cluster"`
	InitialClusterState string   `protobuf:"bytes,42,opt,name=InitialClusterState,proto3" json:"InitialClusterState,omitempty" yaml:"initial-cluster-state"`
	InitialClusterToken string   `protobuf:"bytes,43,opt,name=InitialClusterToken,proto3" json:"InitialClusterToken,omitempty" yaml:"initial-cluster-token"`
	SnapshotCount       int64    `protobuf:"varint,51,opt,name=SnapshotCount,proto3" json:"SnapshotCount,omitempty" yaml:"snapshot-count"`
	QuotaBackendBytes   int64    `protobuf:"varint,52,opt,name=QuotaBackendBytes,proto3" json:"QuotaBackendBytes,omitempty" yaml:"quota-backend-bytes"`
	PreVote             bool     `protobuf:"varint,63,opt,name=PreVote,proto3" json:"PreVote,omitempty" yaml:"pre-vote"`
	InitialCorruptCheck bool     `protobuf:"varint,64,opt,name=InitialCorruptCheck,proto3" json:"InitialCorruptCheck,omitempty" yaml:"initial-corrupt-check"`
	Logger              string   `protobuf:"bytes,71,opt,name=Logger,proto3" json:"Logger,omitempty" yaml:"logger"`
	// LogOutputs is the log file to store current etcd server logs.
	LogOutputs           []string `protobuf:"bytes,72,rep,name=LogOutputs,proto3" json:"LogOutputs,omitempty" yaml:"log-outputs"`
	LogLevel             string   `protobuf:"bytes,73,opt,name=LogLevel,proto3" json:"LogLevel,omitempty" yaml:"log-level"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Etcd) Reset()         { *m = Etcd{} }
func (m *Etcd) String() string { return proto.CompactTextString(m) }
func (*Etcd) ProtoMessage()    {}
func (*Etcd) Descriptor() ([]byte, []int) {
	return fileDescriptor_4fbc93a8dcc3881e, []int{6}
}
func (m *Etcd) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Etcd) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Etcd.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Etcd) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Etcd.Merge(m, src)
}
func (m *Etcd) XXX_Size() int {
	return m.Size()
}
func (m *Etcd) XXX_DiscardUnknown() {
	xxx_messageInfo_Etcd.DiscardUnknown(m)
}

var xxx_messageInfo_Etcd proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("rpcpb.StresserType", StresserType_name, StresserType_value)
	proto.RegisterEnum("rpcpb.Checker", Checker_name, Checker_value)
	proto.RegisterEnum("rpcpb.Operation", Operation_name, Operation_value)
	proto.RegisterEnum("rpcpb.Case", Case_name, Case_value)
	proto.RegisterType((*Request)(nil), "rpcpb.Request")
	proto.RegisterType((*SnapshotInfo)(nil), "rpcpb.SnapshotInfo")
	proto.RegisterType((*Response)(nil), "rpcpb.Response")
	proto.RegisterType((*Member)(nil), "rpcpb.Member")
	proto.RegisterType((*Tester)(nil), "rpcpb.Tester")
	proto.RegisterType((*Stresser)(nil), "rpcpb.Stresser")
	proto.RegisterType((*Etcd)(nil), "rpcpb.Etcd")
}

func init() { proto.RegisterFile("rpcpb/rpc.proto", fileDescriptor_4fbc93a8dcc3881e) }

var fileDescriptor_4fbc93a8dcc3881e = []byte{
	// 3039 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x59, 0xcb, 0x77, 0xdb, 0xc6,
	0xf5, 0x36, 0x44, 0x49, 0x96, 0x46, 0x2f, 0x68, 0x64, 0xd9, 0xf0, 0x4b, 0x90, 0xe1, 0x38, 0x3f,
	0x59, 0x09, 0x6c, 0xff, 0xec, 0x9c, 0x3c, 0x9c, 0x26, 0x0e, 0x48, 0x41, 0x12, 0x4b, 0x88, 0xa4,
	0x87, 0x90, 0x6c, 0x77, 0x51, 0x1c, 0x88, 0x1c, 0x49, 0x3c, 0xa6, 0x00, 0x06, 0x18, 0x3a, 0x52,
	0xfe, 0x81, 0xee, 0x7a, 0x9a, 0x36, 0xed, 0x69, 0xcf, 0xe9, 0x9f, 0xd0, 0xb4, 0x8b, 0xae, 0xbb,
	0x77, 0x5e, 0x6d, 0xda, 0xae, 0xda, 0x05, 0x4f, 0x9b, 0x6e, 0xba, 0xe6, 0xe9, 0x7b, 0xd1, 0xd3,
	0x33, 0x33, 0x00, 0x39, 0x00, 0x49, 0x59, 0x2b, 0x0b, 0xf7, 0x7e, 0xdf, 0x37, 0x17, 0xf7, 0x0e,
	0xe6, 0xde, 0x31, 0xc1, 0x5c, 0xd0, 0xac, 0x36, 0x77, 0x6f, 0x07, 0xcd, 0xea, 0xad, 0x66, 0xe0,
	0x13, 0x1f, 0x8e, 0x31, 0xc3, 0x25, 0x7d, 0xbf, 0x4e, 0x0e, 0x5a, 0xbb, 0xb7, 0xaa, 0xfe, 0xe1,
	0xed, 0x7d, 0x7f, 0xdf, 0xbf, 0xcd, 0xbc, 0xbb, 0xad, 0x3d, 0xf6, 0xc4, 0x1e, 0xd8, 0x5f, 0x9c,
	0xa5, 0x7d, 0x47, 0x02, 0x67, 0x11, 0x7e, 0xbf, 0x85, 0x43, 0x02, 0x6f, 0x81, 0xc9, 0x52, 0x13,
	0x07, 0x2e, 0xa9, 0xfb, 0x9e, 0x22, 0x2d, 0x4b, 0x2b, 0xb3, 0x77, 0xe5, 0x5b, 0x4c, 0xf5, 0x56,
	0xd7, 0x8e, 0x7a, 0x10, 0x78, 0x03, 0x8c, 0x6f, 0xe1, 0xc3, 0x5d, 0x1c, 0x28, 0x23, 0xcb, 0xd2,
	0xca, 0xd4, 0xdd, 0x99, 0x08, 0xcc, 0x8d, 0x28, 0x72, 0x52, 0x98, 0x8d, 0x43, 0x82, 0x03, 0x25,
	0x93, 0x80, 0x71, 0x23, 0x8a, 0x9c, 0xda, 0x5f, 0x47, 0xc0, 0x74, 0xc5, 0x73, 0x9b, 0xe1, 0x81,
	0x4f, 0xf2, 0xde, 0x9e, 0x0f, 0x97, 0x00, 0xe0, 0x0a, 0x45, 0xf7, 0x10, 0xb3, 0x78, 0x26, 0x91,
	0x60, 0x81, 0xab, 0x40, 0xe6, 0x4f, 0xb9, 0x46, 0x1d, 0x7b, 0x64, 0x1b, 0x59, 0xa1, 0x32, 0xb2,
	0x9c, 0x59, 0x99, 0x44, 0x7d, 0x76, 0xa8, 0xf5, 0xb4, 0xcb, 0x2e, 0x39, 0x60, 0x91, 0x4c, 0xa2,
	0x84, 0x8d, 0xea, 0xc5, 0xcf, 0xeb, 0xf5, 0x06, 0xae, 0xd4, 0x3f, 0xc4, 0xca, 0x28, 0xc3, 0xf5,
	0xd9, 0xe1, 0xab, 0x60, 0x3e, 0xb6, 0xd9, 0x3e, 0x71, 0x1b, 0x0c, 0x3c, 0xc6, 0xc0, 0xfd, 0x0e,
	0x51, 0x99, 0x19, 0x0b, 0xf8, 0x58, 0x19, 0x5f, 0x96, 0x56, 0x32, 0xa8, 0xcf, 0x2e, 0x46, 0xba,
	0xe9, 0x86, 0x07, 0xca, 0x59, 0x86, 0x4b, 0xd8, 0x44, 0x3d, 0x84, 0x9f, 0xd5, 0x43, 0x5a, 0xaf,
	0x89, 0xa4, 0x5e, 0x6c, 0x87, 0x10, 0x8c, 0xda, 0xbe, 0xff, 0x54, 0x99, 0x64, 0xc1, 0xb1, 0xbf,
	0xb5, 0x9f, 0x4a, 0x60, 0x02, 0xe1, 0xb0, 0xe9, 0x7b, 0x21, 0x86, 0x0a, 0x38, 0x5b, 0x69, 0x55,
	0xab, 0x38, 0x0c, 0x59, 0x8e, 0x27, 0x50, 0xfc, 0x08, 0xcf, 0x83, 0xf1, 0x0a, 0x71, 0x49, 0x2b,
	0x64, 0xf5, 0x9d, 0x44, 0xd1, 0x93, 0x50, 0xf7, 0xcc, 0x49, 0x75, 0x7f, 0x23, 0x59, 0x4f, 0x96,
	0xcb, 0xa9, 0xbb, 0x0b, 0x11, 0x58, 0x74, 0xa1, 0x04, 0x50, 0xfb, 0x6c, 0x3a, 0x5e, 0x00, 0xde,
	0x01, 0x13, 0x26, 0xa9, 0xd6, 0xcc, 0x23, 0x5c, 0xe5, 0x3b, 0x20, 0x7b, 0xae, 0xd3, 0x56, 0xe5,
	0x63, 0xf7, 0xb0, 0x71, 0x5f, 0xc3, 0xa4, 0x5a, 0xd3, 0xf1, 0x11, 0xae, 0x6a, 0xa8, 0x8b, 0x82,
	0xf7, 0xc0, 0xa4, 0xb1, 0x8f, 0x3d, 0x62, 0xd4, 0x6a, 0x81, 0x32, 0xc5, 0x28, 0x8b, 0x9d, 0xb6,
	0x3a, 0xcf, 0x29, 0x2e, 0x75, 0xe9, 0x6e, 0xad, 0x16, 0x68, 0xa8, 0x87, 0x83, 0x16, 0x98, 0x5f,
	0x77, 0xeb, 0x8d, 0xa6, 0x5f, 0xf7, 0xc8, 0xa6, 0x6d, 0x97, 0x19, 0x79, 0x9a, 0x91, 0x97, 0x3a,
	0x6d, 0xf5, 0x12, 0x27, 0xef, 0xc5, 0x10, 0xfd, 0x80, 0x90, 0x66, 0xa4, 0xd2, 0x4f, 0x84, 0x3a,
	0x38, 0x9b, 0x75, 0x43, 0xbc, 0x56, 0x0f, 0x14, 0xcc, 0x34, 0x16, 0x3a, 0x6d, 0x75, 0x8e, 0x6b,
	0xec, 0xba, 0x21, 0xd6, 0x6b, 0xf5, 0x40, 0x43, 0x31, 0x06, 0x6e, 0x80, 0x39, 0x1a, 0x3d, 0xdf,
	0xad, 0xe5, 0xc0, 0x3f, 0x3a, 0x56, 0x3e, 0x65, 0x95, 0xc8, 0x5e, 0xe9, 0xb4, 0x55, 0x45, 0x78,
	0xd7, 0x2a, 0x83, 0xe8, 0x4d, 0x8a, 0xd1, 0x50, 0x9a, 0x05, 0x0d, 0x30, 0x43, 0x4d, 0x65, 0x8c,
	0x03, 0x2e, 0xf3, 0x19, 0x97, 0xb9, 0xd4, 0x69, 0xab, 0xe7, 0x05, 0x99, 0x26, 0xc6, 0x41, 0x2c,
	0x92, 0x64, 0xc0, 0x32, 0x80, 0x3d, 0x55, 0xd3, 0xab, 0xb1, 0x17, 0x53, 0x3e, 0x61, 0xf5, 0xcf,
	0xaa, 0x9d, 0xb6, 0x7a, 0xb9, 0x3f, 0x1c, 0x1c, 0xc1, 0x34, 0x34, 0x80, 0x0b, 0xff, 0x1f, 0x8c,
	0x52, 0xab, 0xf2, 0x73, 0x7e, 0x46, 0x4c, 0x45, 0xe5, 0xa7, 0xb6, 0xec, 0x5c, 0xa7, 0xad, 0x4e,
	0xf5, 0x04, 0x35, 0xc4, 0xa0, 0x30, 0x0b, 0x16, 0xe9, 0xbf, 0x25, 0xaf, 0xb7, 0x99, 0x43, 0xe2,
	0x07, 0x58, 0xf9, 0x45, 0xbf, 0x06, 0x1a, 0x0c, 0x85, 0x6b, 0x60, 0x96, 0x07, 0x92, 0xc3, 0x01,
	0x59, 0x73, 0x89, 0xab, 0x7c, 0xc4, 0xbe, 0xf9, 0xec, 0xe5, 0x4e, 0x5b, 0xbd, 0xc0, 0xd7, 0x8c,
	0xe2, 0xaf, 0xe2, 0x80, 0xe8, 0x35, 0x97, 0xb8, 0x1a, 0x4a, 0x71, 0x92, 0x2a, 0xec, 0xe0, 0xf8,
	0xfe, 0x89, 0x2a, 0x4d, 0x97, 0x1c, 0x24, 0x54, 0xd8, 0xc1, 0x62, 0x80, 0x19, 0x6e, 0x29, 0xe0,
	0x63, 0x16, 0xca, 0x0f, 0xb8, 0x88, 0x50, 0x97, 0x48, 0xe4, 0x29, 0x3e, 0x8e, 0x22, 0x49, 0x32,
	0x12, 0x12, 0x2c, 0x8e, 0x8f, 0x4f, 0x92, 0xe0, 0x61, 0x24, 0x19, 0xd0, 0x06, 0x0b, 0xdc, 0x60,
	0x07, 0xad, 0x90, 0xe0, 0x5a, 0xce, 0x60, 0xb1, 0xfc, 0x90, 0x0b, 0x5d, 0xeb, 0xb4, 0xd5, 0xab,
	0x09, 0x21, 0xc2, 0x61, 0x7a, 0xd5, 0x8d, 0x42, 0x1a, 0x44, 0x1f, 0xa0, 0xca, 0xc2, 0xfb, 0xd1,
	0x29, 0x54, 0x79, 0x94, 0x83, 0xe8, 0xf0, 0x5d, 0x30, 0x4d, 0xf7, 0x64, 0xb7, 0x76, 0x7f, 0xe7,
	0x72, 0x17, 0x3b, 0x6d, 0x75, 0x91, 0xcb, 0xb1, 0x3d, 0x2c, 0x54, 0x2e, 0x81, 0x17, 0xf9, 0x2c,
	0x9c, 0x7f, 0x9c, 0xc0, 0xe7, 0x61, 0x24, 0xf0, 0xf0, 0x6d, 0x30, 0x45, 0x9f, 0xe3, 0x7a, 0xfd,
	0x93, 0xd3, 0x95, 0x4e, 0x5b, 0x3d, 0x27, 0xd0, 0x7b, 0xd5, 0x12, 0xd1, 0x02, 0x99, 0xad, 0xfd,
	0xaf, 0xe1, 0x64, 0xbe, 0xb4, 0x88, 0x86, 0x45, 0x30, 0x4f, 0x1f, 0x93, 0x35, 0xfa, 0x77, 0x26,
	0xfd, 0xfd, 0x31, 0x89, 0xbe, 0x0a, 0xf5, 0x53, 0xfb, 0xf4, 0x58, 0x48, 0xff, 0x79, 0xa1, 0x1e,
	0x8f, 0xac, 0x9f, 0x0a, 0xdf, 0x49, 0x35, 0xd2, 0x3f, 0x8c, 0xa6, 0xdf, 0x2e, 0x8c, 0xdc, 0x71,
	0x62, 0x13, 0x3d, 0xf6, 0xcd, 0x54, 0x4f, 0xf8, 0xe3, 0x69, 0x9b, 0x02, 0x7c, 0x1d, 0x80, 0xee,
	0x49, 0x1b, 0x2a, 0xbf, 0x1a, 0x4b, 0x9f, 0xec, 0xdd, 0xc3, 0x39, 0xd4, 0x90, 0x80, 0xd4, 0x7e,
	0x39, 0x1d, 0x8f, 0x1f, 0xf4, 0x5c, 0xa6, 0x39, 0xa1, 0xe7, 0xb2, 0x94, 0x3e, 0x97, 0x69, 0x02,
	0xa3, 0x73, 0x39, 0xc2, 0xc0, 0x57, 0xc1, 0xd9, 0x22, 0x26, 0x1f, 0xf8, 0xc1, 0x53, 0xde, 0xff,
	0xb2, 0xb0, 0xd3, 0x56, 0x67, 0x39, 0xdc, 0xe3, 0x0e, 0x0d, 0xc5, 0x10, 0x78, 0x1d, 0x8c, 0xb2,
	0xae, 0xc1, 0x53, 0x2b, 0x9c, 0x6c, 0xbc, 0x4d, 0x30, 0x27, 0xcc, 0x81, 0xd9, 0x35, 0xdc, 0x70,
	0x8f, 0x2d, 0x97, 0x60, 0xaf, 0x7a, 0xbc, 0x15, 0xb2, 0x0e, 0x35, 0x23, 0x1e, 0x27, 0x35, 0xea,
	0xd7, 0x1b, 0x1c, 0xa0, 0x1f, 0x86, 0x1a, 0x4a, 0x51, 0xe0, 0x37, 0x81, 0x9c, 0xb4, 0xa0, 0x67,
	0xac, 0x57, 0xcd, 0x88, 0xbd, 0x2a, 0x2d, 0xa3, 0x07, 0xcf, 0x34, 0xd4, 0xc7, 0x83, 0x4f, 0xc0,
	0xe2, 0x76, 0xb3, 0xe6, 0x12, 0x5c, 0x4b, 0xc5, 0x35, 0xc3, 0x04, 0xaf, 0x77, 0xda, 0xaa, 0xca,
	0x05, 0x5b, 0x1c, 0xa6, 0xf7, 0xc7, 0x37, 0x58, 0x81, 0x16, 0x0c, 0xf9, 0x2d, 0xaf, 0x66, 0xd5,
	0x0f, 0xeb, 0x44, 0x59, 0x5c, 0x96, 0x56, 0xc6, 0xb2, 0xe7, 0x3b, 0x6d, 0x15, 0x72, 0xbd, 0x80,
	0xfa, 0xf4, 0x06, 0x75, 0x6a, 0x48, 0x40, 0xc2, 0x2c, 0x98, 0x35, 0x8f, 0xea, 0xa4, 0xe4, 0xe5,
	0xdc, 0x10, 0xd3, 0x42, 0x2a, 0xe7, 0xfb, 0xba, 0xd8, 0x51, 0x9d, 0xe8, 0xbe, 0xa7, 0xd3, 0x9a,
	0xb7, 0x02, 0xac, 0xa1, 0x14, 0x03, 0xbe, 0x05, 0xa6, 0x4c, 0xcf, 0xdd, 0x6d, 0xe0, 0x72, 0x33,
	0xf0, 0xf7, 0x94, 0x0b, 0x4c, 0xe0, 0x42, 0xa7, 0xad, 0x2e, 0x44, 0x02, 0xcc, 0xa9, 0x37, 0xa9,
	0x57, 0x43, 0x22, 0x16, 0xde, 0x07, 0x53, 0x54, 0x86, 0xbd, 0xcc, 0x56, 0xa8, 0xa8, 0x2c, 0x0f,
	0xc2, 0xf6, 0xae, 0xb2, 0x06, 0xce, 0x92, 0x40, 0x5f, 0x5e, 0x04, 0xd3, 0x65, 0xe9, 0x63, 0xe5,
	0xa0, 0xb5, 0xb7, 0xd7, 0xc0, 0xca, 0x72, 0x7a, 0x59, 0xc6, 0x0d, 0xb9, 0x37, 0xa2, 0x46, 0x58,
	0xf8, 0x32, 0x18, 0xa3, 0x8f, 0xa1, 0x72, 0x8d, 0x4e, 0xb0, 0x59, 0xb9, 0xd3, 0x56, 0xa7, 0x7b,
	0xa4, 0x50, 0x43, 0xdc, 0x0d, 0x0b, 0xc2, 0xa4, 0x92, 0xf3, 0x0f, 0x0f, 0x5d, 0xaf, 0x16, 0x2a,
	0x1a, 0xe3, 0x5c, 0xed, 0xb4, 0xd5, 0x8b, 0xe9, 0x49, 0xa5, 0x1a, 0x61, 0xc4, 0x41, 0x25, 0xe6,
	0xd1, 0xed, 0x88, 0x5a, 0x9e, 0x87, 0x03, 0x3a, 0x39, 0xb1, 0xcf, 0xf9, 0x66, 0xba, 0xbb, 0x05,
	0xcc, 0xcf, 0xa6, 0xac, 0xb8, 0xbb, 0x25, 0x29, 0x30, 0x0f, 0x64, 0xf3, 0x88, 0xe0, 0xc0, 0x73,
	0x1b, 0x5d, 0x99, 0x55, 0x26, 0x23, 0x04, 0x84, 0x23, 0x84, 0x28, 0xd4, 0x47, 0x83, 0x39, 0x30,
	0x59, 0x21, 0x01, 0x0e, 0x43, 0x1c, 0x84, 0x0a, 0x5e, 0xce, 0xac, 0x4c, 0xdd, 0x9d, 0x8b, 0x4f,
	0x86, 0xc8, 0x2e, 0xce, 0x7f, 0x61, 0x8c, 0xd5, 0x50, 0x8f, 0x07, 0x6f, 0x83, 0x89, 0xdc, 0x01,
	0xae, 0x3e, 0xa5, 0x1a, 0x7b, 0x2c, 0x31, 0xc2, 0x67, 0x5e, 0x8d, 0x3c, 0x1a, 0xea, 0x82, 0x68,
	0x6f, 0xe5, 0xec, 0x02, 0x3e, 0x66, 0x73, 0x3c, 0x9b, 0xbe, 0xc6, 0xc4, 0x0d, 0xc7, 0x57, 0x62,
	0x67, 0x76, 0x58, 0xff, 0x10, 0x6b, 0x28, 0xc9, 0x80, 0x0f, 0x01, 0x4c, 0x18, 0x2c, 0x37, 0xd8,
	0xc7, 0x7c, 0xfc, 0x1a, 0xcb, 0x2e, 0x77, 0xda, 0xea, 0x95, 0x81, 0x3a, 0x7a, 0x83, 0xe2, 0x34,
	0x34, 0x80, 0x0c, 0x1f, 0x81, 0x73, 0x3d, 0x6b, 0x6b, 0x6f, 0xaf, 0x7e, 0x84, 0x5c, 0x6f, 0x1f,
	0x2b, 0x9f, 0x73, 0x51, 0xad, 0xd3, 0x56, 0x97, 0xfa, 0x45, 0x19, 0x50, 0x0f, 0x28, 0x52, 0x43,
	0x03, 0x05, 0xa0, 0x0b, 0x2e, 0x0c, 0xb2, 0xdb, 0x47, 0x9e, 0xf2, 0x05, 0xd7, 0x7e, 0xb9, 0xd3,
	0x56, 0xb5, 0x13, 0xb5, 0x75, 0x72, 0xe4, 0x69, 0x68, 0x98, 0x0e, 0xdc, 0x04, 0x73, 0x5d, 0x97,
	0x7d, 0xe4, 0x95, 0x9a, 0xa1, 0xf2, 0x25, 0x97, 0x16, 0xb6, 0x84, 0x20, 0x4d, 0x8e, 0x3c, 0xdd,
	0x6f, 0x86, 0x1a, 0x4a, 0xd3, 0xe0, 0x7b, 0x71, 0x6d, 0xf8, 0x94, 0x10, 0xf2, 0x51, 0x74, 0x4c,
	0xec, 0xe4, 0x91, 0x0e, 0x9f, 0x2f, 0xc2, 0x6e, 0x69, 0x22, 0x02, 0x7c, 0x2d, 0xde, 0x53, 0x0f,
	0xcb, 0x15, 0x3e, 0x84, 0x8e, 0x89, 0x6d, 0x23, 0x62, 0xbf, 0xdf, 0xec, 0x6d, 0xa2, 0x87, 0xe5,
	0x8a, 0xf6, 0x2d, 0x30, 0x11, 0xef, 0x28, 0x7a, 0xb2, 0xdb, 0xc7, 0xcd, 0xe8, 0x06, 0x2a, 0x9e,
	0xec, 0xe4, 0xb8, 0x89, 0x35, 0xc4, 0x9c, 0xf0, 0x26, 0x18, 0x7f, 0x84, 0xeb, 0xfb, 0x07, 0x84,
	0xf5, 0x0a, 0x29, 0x3b, 0xdf, 0x69, 0xab, 0x33, 0x1c, 0xf6, 0x01, 0xb3, 0x6b, 0x28, 0x02, 0x68,
	0xdf, 0x9d, 0xe3, 0x23, 0x31, 0x15, 0xee, 0x5d, 0x6d, 0x45, 0x61, 0xcf, 0x3d, 0xa4, 0xc2, 0xec,
	0x96, 0x2b, 0x34, 0xad, 0x91, 0x53, 0x34, 0xad, 0x55, 0x30, 0xfe, 0xc8, 0xb0, 0x28, 0x3a, 0x93,
	0xee, 0x59, 0x1f, 0xb8, 0x0d, 0x0e, 0x8e, 0x10, 0xb0, 0x04, 0x16, 0x36, 0xb1, 0x1b, 0x90, 0x5d,
	0xec, 0x92, 0xbc, 0x47, 0x70, 0xf0, 0xcc, 0x6d, 0x44, 0x2d, 0x29, 0x23, 0x56, 0xea, 0x20, 0x06,
	0xe9, 0xf5, 0x08, 0xa5, 0xa1, 0x41, 0x4c, 0x98, 0x07, 0xf3, 0x66, 0x03, 0x57, 0x49, 0xdd, 0xf7,
	0xec, 0xfa, 0x21, 0xf6, 0x5b, 0x64, 0x2b, 0x64, 0xad, 0x29, 0x23, 0x1e, 0x29, 0x38, 0x82, 0xe8,
	0x84, 0x63, 0x34, 0xd4, 0xcf, 0xa2, 0xa7, 0x8a, 0x55, 0x0f, 0x09, 0xf6, 0x84, 0xcb, 0xfd, 0x62,
	0xfa, 0x98, 0x6b, 0x30, 0x44, 0x7c, 0x0f, 0x69, 0x05, 0x8d, 0x50, 0x43, 0x7d, 0x34, 0x88, 0xc0,
	0x82, 0x51, 0x7b, 0x86, 0x03, 0x52, 0x0f, 0xb1, 0xa0, 0x76, 0x9e, 0xa9, 0x09, 0x1f, 0xa7, 0x1b,
	0x83, 0x92, 0x82, 0x83, 0xc8, 0xf0, 0xad, 0x78, 0x1e, 0x37, 0x5a, 0xc4, 0xb7, 0xad, 0x4a, 0xd4,
	0x62, 0x84, 0xda, 0xb8, 0x2d, 0xe2, 0xeb, 0x84, 0x0a, 0x24, 0x91, 0xf4, 0xd0, 0xed, 0xdd, 0x0f,
	0x8c, 0x16, 0x39, 0x50, 0x14, 0xc6, 0x1d, 0x72, 0xa5, 0x70, 0x5b, 0xa9, 0x2b, 0x05, 0xa5, 0xc0,
	0x6f, 0x88, 0x22, 0xeb, 0xf5, 0x06, 0x56, 0x2e, 0xa6, 0x6f, 0xc7, 0x8c, 0xbd, 0x57, 0xa7, 0x9d,
	0x26, 0x85, 0xed, 0x45, 0x5f, 0xc0, 0xc7, 0x8c, 0x7c, 0x29, 0xbd, 0xb3, 0xe8, 0x57, 0xc9, 0xb9,
	0x49, 0x24, 0xb4, 0xfa, 0xe6, 0x7d, 0x26, 0x70, 0x39, 0x7d, 0x1b, 0x11, 0x66, 0x49, 0xae, 0x33,
	0x88, 0x46, 0x73, 0xc1, 0xcb, 0x45, 0x07, 0x4d, 0x56, 0x15, 0x95, 0x55, 0x45, 0xc8, 0x45, 0x54,
	0x63, 0x36, 0xa0, 0xf2, 0x82, 0xa4, 0x28, 0xd0, 0x06, 0xf3, 0xdd, 0x12, 0x75, 0x75, 0x96, 0x99,
	0x8e, 0x70, 0x92, 0xd5, 0xbd, 0x3a, 0xa9, 0xbb, 0x0d, 0xbd, 0x57, 0x65, 0x41, 0xb2, 0x5f, 0x80,
	0xce, 0x01, 0xf4, 0xef, 0xb8, 0xbe, 0xd7, 0x58, 0x8d, 0xd2, 0x43, 0x7c, 0xaf, 0xc8, 0x22, 0x98,
	0xde, 0xa2, 0xd9, 0x75, 0x22, 0x59, 0x66, 0x8d, 0x49, 0x08, 0x1b, 0x8e, 0xdf, 0x41, 0xfa, 0x6a,
	0x3d, 0x80, 0x4b, 0xc7, 0xee, 0xf8, 0x82, 0xc2, 0xf2, 0x7d, 0x7d, 0xf8, 0x7d, 0x86, 0xa7, 0x3b,
	0x01, 0x8f, 0x5f, 0x26, 0x2e, 0xf7, 0x4b, 0x43, 0x6f, 0x24, 0x9c, 0x2c, 0x82, 0xe1, 0x56, 0xea,
	0x06, 0xc1, 0x14, 0x6e, 0xbc, 0xe8, 0x02, 0xc1, 0x85, 0xfa, 0x99, 0x74, 0xbc, 0xcb, 0xf3, 0x52,
	0xe4, 0x1a, 0x2d, 0xf6, 0xbf, 0x82, 0x37, 0xd3, 0x7b, 0x27, 0x2e, 0x55, 0x95, 0x03, 0x34, 0x94,
	0x62, 0xd0, 0x2f, 0x3a, 0x69, 0xa9, 0x10, 0x97, 0xe0, 0x68, 0xea, 0x10, 0x12, 0x9c, 0x12, 0xd2,
	0x43, 0x0a, 0xd3, 0xd0, 0x20, 0x72, 0xbf, 0xa6, 0xed, 0x3f, 0xc5, 0x9e, 0xf2, 0xca, 0x8b, 0x34,
	0x09, 0x85, 0xf5, 0x69, 0x32, 0x32, 0x7c, 0x00, 0x66, 0xe2, 0x3b, 0x4c, 0xce, 0x6f, 0x79, 0x44,
	0xb9, 0xc7, 0xce, 0x42, 0xb1, 0x79, 0xc5, 0x97, 0xa5, 0x2a, 0xf5, 0xd3, 0xe6, 0x25, 0xe2, 0xa1,
	0x05, 0xe6, 0x1f, 0xb6, 0x7c, 0xe2, 0x66, 0xdd, 0xea, 0x53, 0xec, 0xd5, 0xb2, 0xc7, 0x04, 0x87,
	0xca, 0x6b, 0x4c, 0x44, 0x98, 0xf5, 0xdf, 0xa7, 0x10, 0x7d, 0x97, 0x63, 0xf4, 0x5d, 0x0a, 0xd2,
	0x50, 0x3f, 0x91, 0xb6, 0x92, 0x72, 0x80, 0x77, 0x7c, 0x82, 0x95, 0x07, 0xe9, 0xe3, 0xaa, 0x19,
	0x60, 0xfd, 0x99, 0x4f, 0xb3, 0x13, 0x63, 0xc4, 0x8c, 0xf8, 0x41, 0xd0, 0x6a, 0x12, 0x36, 0x31,
	0x29, 0xef, 0xa5, 0xb7, 0x71, 0x37, 0x23, 0x1c, 0xa5, 0xb3, 0x19, 0x4b, 0xc8, 0x88, 0x40, 0xa6,
	0x6d, 0xd2, 0xf2, 0xf7, 0xf7, 0x71, 0xa0, 0x6c, 0xb0, 0xc4, 0x0a, 0x6d, 0xb2, 0xc1, 0xec, 0x1a,
	0x8a, 0x00, 0xf4, 0xfe, 0x60, 0xf9, 0xfb, 0xa5, 0x16, 0x69, 0xb6, 0x48, 0xa8, 0x6c, 0xb2, 0xef,
	0x59, 0xb8, 0x3f, 0x34, 0xfc, 0x7d, 0xdd, 0xe7, 0x4e, 0x0d, 0x09, 0x48, 0x78, 0x07, 0x4c, 0x58,
	0xfe, 0xbe, 0x85, 0x9f, 0xe1, 0x86, 0x92, 0x4f, 0x1f, 0x8a, 0x94, 0xd5, 0xa0, 0x2e, 0x0d, 0x75,
	0x51, 0xab, 0xff, 0x95, 0xc0, 0x74, 0xdc, 0xed, 0x59, 0x33, 0x87, 0x60, 0xb6, 0xb0, 0xe3, 0x3c,
	0x42, 0x79, 0xdb, 0x74, 0x2a, 0x5b, 0x86, 0x65, 0xc9, 0x67, 0x12, 0x36, 0xcb, 0x40, 0x1b, 0xa6,
	0x2c, 0xc1, 0x05, 0x30, 0x57, 0xd8, 0x71, 0x90, 0x69, 0xac, 0x39, 0xa5, 0xa2, 0xe9, 0x14, 0xcc,
	0x27, 0xf2, 0x08, 0x9c, 0x07, 0x33, 0xb1, 0x11, 0x19, 0xc5, 0x0d, 0x53, 0xce, 0xc0, 0x45, 0x30,
	0x5f, 0xd8, 0x71, 0xd6, 0x4c, 0xcb, 0xb4, 0xcd, 0x2e, 0x72, 0x34, 0xa2, 0x47, 0x66, 0x8e, 0x1d,
	0x83, 0x17, 0xc0, 0x42, 0x61, 0xc7, 0xb1, 0x1f, 0x17, 0xa3, 0xb5, 0xb8, 0x5b, 0x1e, 0x87, 0x93,
	0x60, 0xcc, 0x32, 0x8d, 0x8a, 0x29, 0x03, 0x4a, 0x34, 0x2d, 0x33, 0x67, 0xe7, 0x4b, 0x45, 0x07,
	0x6d, 0x17, 0x8b, 0x26, 0x92, 0xcf, 0x41, 0x19, 0x4c, 0x3f, 0x32, 0xec, 0xdc, 0x66, 0x6c, 0x51,
	0xe9, 0xb2, 0x56, 0x29, 0x57, 0x70, 0x90, 0x91, 0x33, 0x51, 0x6c, 0xbe, 0x49, 0x81, 0x4c, 0x28,
	0xb6, 0xdc, 0x5b, 0xfd, 0x36, 0x38, 0x1b, 0x4d, 0xc3, 0x70, 0x0a, 0x9c, 0x2d, 0xec, 0x38, 0x9b,
	0x46, 0x65, 0x53, 0x3e, 0xd3, 0x43, 0x9a, 0x8f, 0xcb, 0x79, 0x44, 0xdf, 0x18, 0x80, 0xf1, 0x88,
	0x35, 0x02, 0xa7, 0xc1, 0x44, 0xb1, 0xe4, 0xe4, 0x36, 0xcd, 0x5c, 0x41, 0xce, 0xc0, 0x4b, 0xe0,
	0x7c, 0x65, 0xb3, 0x84, 0x6c, 0xc7, 0xb6, 0x2d, 0x27, 0xc1, 0x1a, 0x5d, 0xfd, 0x49, 0x46, 0xf8,
	0x65, 0x01, 0xce, 0x81, 0xa9, 0x62, 0xc9, 0x76, 0x2a, 0xb6, 0x81, 0x6c, 0x73, 0x4d, 0x3e, 0x03,
	0xcf, 0x03, 0x98, 0x2f, 0xe6, 0xed, 0xbc, 0x61, 0x71, 0xa3, 0x63, 0xda, 0xb9, 0x35, 0x19, 0xd0,
	0xe5, 0x91, 0x29, 0x58, 0xa6, 0xa8, 0xa5, 0x92, 0xdf, 0xb0, 0x4d, 0xb4, 0xc5, 0x2d, 0xe7, 0xe0,
	0x32, 0xb8, 0x52, 0xc9, 0x6f, 0x3c, 0xdc, 0xce, 0x73, 0x8c, 0x63, 0x14, 0xd7, 0x1c, 0x64, 0x6e,
	0x95, 0x76, 0x4c, 0x67, 0xcd, 0xb0, 0x0d, 0x79, 0x91, 0xd6, 0xa3, 0x62, 0xec, 0x98, 0x4e, 0xa5,
	0x68, 0x94, 0x2b, 0x9b, 0x25, 0x5b, 0x5e, 0x82, 0xd7, 0xc0, 0x55, 0x2a, 0x5c, 0x42, 0xa6, 0x13,
	0x2f, 0xb0, 0x8e, 0x4a, 0x5b, 0x3d, 0x88, 0x0a, 0x2f, 0x82, 0xc5, 0xc1, 0xae, 0x65, 0xca, 0xee,
	0x5b, 0xd2, 0x40, 0xb9, 0xcd, 0x7c, 0xbc, 0xe6, 0x0a, 0xbc, 0x0d, 0x5e, 0x39, 0x29, 0x2a, 0xf6,
	0x5c, 0xb1, 0x4b, 0x65, 0xc7, 0xd8, 0x30, 0x8b, 0xb6, 0x7c, 0x13, 0x5e, 0x05, 0x17, 0xb3, 0x96,
	0x91, 0x2b, 0x6c, 0x96, 0x2c, 0xd3, 0x29, 0x9b, 0x26, 0x72, 0xca, 0x2c, 0x97, 0x8f, 0x1d, 0xf4,
	0x58, 0xae, 0x41, 0x15, 0x5c, 0xde, 0x2e, 0x0e, 0x07, 0x60, 0x78, 0x09, 0x2c, 0xae, 0x99, 0x96,
	0xf1, 0xa4, 0xcf, 0xf5, 0x5c, 0x82, 0x57, 0xc0, 0x85, 0xed, 0xe2, 0x60, 0xef, 0xa7, 0xd2, 0xea,
	0xc7, 0x53, 0x60, 0x94, 0x5e, 0x2d, 0xa1, 0x02, 0xce, 0xc5, 0xb9, 0xa5, 0x5b, 0x74, 0xbd, 0x64,
	0x59, 0xa5, 0x47, 0x26, 0x92, 0xcf, 0x44, 0x6f, 0xd3, 0xe7, 0x71, 0xb6, 0x8b, 0x76, 0xde, 0x72,
	0x6c, 0x94, 0xdf, 0xd8, 0x30, 0x51, 0x2f, 0x43, 0x12, 0xfd, 0x56, 0x62, 0x82, 0x65, 0x1a, 0x6b,
	0x6c, 0xb7, 0xdc, 0x04, 0x37, 0x92, 0xb6, 0x61, 0xf4, 0x8c, 0x48, 0x7f, 0xb8, 0x5d, 0x42, 0xdb,
	0x5b, 0xf2, 0x28, 0xdd, 0x34, 0xb1, 0x8d, 0x7e, 0x8f, 0x63, 0xf0, 0x3a, 0x50, 0xe3, 0x14, 0x0b,
	0xd9, 0x4d, 0x44, 0x0e, 0xe0, 0x7d, 0xf0, 0xfa, 0x0b, 0x40, 0xc3, 0xa2, 0x98, 0xa2, 0x25, 0x19,
	0xc0, 0x8d, 0xde, 0x67, 0x1a, 0xbe, 0x06, 0xee, 0x0c, 0x75, 0x0f, 0x13, 0x9d, 0x81, 0xeb, 0x20,
	0x3b, 0x80, 0xc5, 0xdf, 0x32, 0xb2, 0xf0, 0x7d, 0x19, 0x09, 0xc5, 0xd4, 0x68, 0x13, 0xe6, 0x10,
	0xfd, 0xc2, 0xe5, 0x59, 0xb8, 0x0a, 0x5e, 0x1e, 0xba, 0x1d, 0x92, 0x49, 0xa8, 0x41, 0x03, 0xbc,
	0x73, 0x3a, 0xec, 0xb0, 0xb0, 0x31, 0x7c, 0x09, 0x2c, 0x0f, 0x97, 0x88, 0x52, 0xb2, 0x07, 0xdf,
	0x06, 0x6f, 0xbc, 0x08, 0x35, 0x6c, 0x89, 0xfd, 0x93, 0x97, 0x88, 0xb6, 0xc1, 0x01, 0xfd, 0xf6,
	0x86, 0xa3, 0xe8, 0xc6, 0xa8, 0xc3, 0xff, 0x03, 0xda, 0xc0, 0xcd, 0x9e, 0x4c, 0xcb, 0x73, 0x09,
	0xde, 0x02, 0x37, 0x91, 0x51, 0x5c, 0x2b, 0x6d, 0x39, 0xa7, 0xc0, 0x7f, 0x2a, 0xc1, 0x77, 0xc1,
	0x5b, 0x2f, 0x06, 0x0e, 0x7b, 0xc1, 0xcf, 0x24, 0x68, 0x82, 0xf7, 0x4e, 0xbd, 0xde, 0x30, 0x99,
	0xcf, 0x25, 0x78, 0x0d, 0x5c, 0x19, 0xcc, 0x8f, 0xea, 0xf0, 0x85, 0x04, 0x57, 0xc0, 0xf5, 0x13,
	0x57, 0x8a, 0x90, 0x5f, 0x4a, 0xf0, 0x4d, 0x70, 0xef, 0x24, 0xc8, 0xb0, 0x30, 0x7e, 0x2d, 0xc1,
	0x07, 0xe0, 0xfe, 0x29, 0xd6, 0x18, 0x26, 0xf0, 0x9b, 0x13, 0xde, 0x23, 0x2a, 0xf6, 0x57, 0x2f,
	0x7e, 0x8f, 0x08, 0xf9, 0x5b, 0x09, 0x2e, 0x81, 0x8b, 0x83, 0x21, 0x74, 0x4f, 0xfc, 0x4e, 0x82,
	0x37, 0xc0, 0xf2, 0x89, 0x4a, 0x14, 0xf6, 0x7b, 0x09, 0x2a, 0x60, 0xa1, 0x58, 0x72, 0xd6, 0x8d,
	0xbc, 0xe5, 0x3c, 0xca, 0xdb, 0x9b, 0x4e, 0xc5, 0x46, 0x66, 0xa5, 0x22, 0xff, 0x6c, 0x84, 0x86,
	0x92, 0xf0, 0x14, 0x4b, 0x91, 0xd3, 0x59, 0x2f, 0x21, 0xc7, 0xca, 0xef, 0x98, 0x45, 0x8a, 0xfc,
	0x64, 0x04, 0xce, 0x01, 0x40, 0x61, 0xe5, 0x52, 0xbe, 0x68, 0x57, 0xe4, 0xef, 0x65, 0xe0, 0x4b,
	0x40, 0xed, 0x19, 0x38, 0x7b, 0x2d, 0x5f, 0x29, 0x38, 0xf9, 0x92, 0x63, 0x19, 0xb6, 0x59, 0xcc,
	0x3d, 0x91, 0x3f, 0xca, 0xc0, 0x19, 0x30, 0x61, 0x3e, 0xb6, 0x4d, 0x54, 0x34, 0x2c, 0xf9, 0x6f,
	0x99, 0xbb, 0x0f, 0xc0, 0xa4, 0x1d, 0xb8, 0x5e, 0xd8, 0xf4, 0x03, 0x02, 0xef, 0x8a, 0x0f, 0xb3,
	0xd1, 0xff, 0x88, 0x45, 0xbf, 0xda, 0x5f, 0x9a, 0xeb, 0x3e, 0xf3, 0x1f, 0x74, 0xb5, 0x33, 0x2b,
	0xd2, 0x1d, 0x29, 0x7b, 0xee, 0xf9, 0x9f, 0x97, 0xce, 0x3c, 0xff, 0x7a, 0x49, 0xfa, 0xea, 0xeb,
	0x25, 0xe9, 0x4f, 0x5f, 0x2f, 0x49, 0x3f, 0xfe, 0xcb, 0xd2, 0x99, 0xdd, 0x71, 0xf6, 0xab, 0xff,
	0xbd, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0x21, 0xcd, 0x4e, 0x90, 0x3e, 0x20, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// TransportClient is the client API for Transport service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TransportClient interface {
	Transport(ctx context.Context, opts ...grpc.CallOption) (Transport_TransportClient, error)
}

type transportClient struct {
	cc *grpc.ClientConn
}

func NewTransportClient(cc *grpc.ClientConn) TransportClient {
	return &transportClient{cc}
}

func (c *transportClient) Transport(ctx context.Context, opts ...grpc.CallOption) (Transport_TransportClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Transport_serviceDesc.Streams[0], "/rpcpb.Transport/Transport", opts...)
	if err != nil {
		return nil, err
	}
	x := &transportTransportClient{stream}
	return x, nil
}

type Transport_TransportClient interface {
	Send(*Request) error
	Recv() (*Response, error)
	grpc.ClientStream
}

type transportTransportClient struct {
	grpc.ClientStream
}

func (x *transportTransportClient) Send(m *Request) error {
	return x.ClientStream.SendMsg(m)
}

func (x *transportTransportClient) Recv() (*Response, error) {
	m := new(Response)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// TransportServer is the server API for Transport service.
type TransportServer interface {
	Transport(Transport_TransportServer) error
}

// UnimplementedTransportServer can be embedded to have forward compatible implementations.
type UnimplementedTransportServer struct {
}

func (*UnimplementedTransportServer) Transport(srv Transport_TransportServer) error {
	return status.Errorf(codes.Unimplemented, "method Transport not implemented")
}

func RegisterTransportServer(s *grpc.Server, srv TransportServer) {
	s.RegisterService(&_Transport_serviceDesc, srv)
}

func _Transport_Transport_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(TransportServer).Transport(&transportTransportServer{stream})
}

type Transport_TransportServer interface {
	Send(*Response) error
	Recv() (*Request, error)
	grpc.ServerStream
}

type transportTransportServer struct {
	grpc.ServerStream
}

func (x *transportTransportServer) Send(m *Response) error {
	return x.ServerStream.SendMsg(m)
}

func (x *transportTransportServer) Recv() (*Request, error) {
	m := new(Request)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Transport_serviceDesc = grpc.ServiceDesc{
	ServiceName: "rpcpb.Transport",
	HandlerType: (*TransportServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Transport",
			Handler:       _Transport_Transport_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "rpcpb/rpc.proto",
}

func (m *Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Tester != nil {
		{
			size, err := m.Tester.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Member != nil {
		{
			size, err := m.Member.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Operation != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Operation))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SnapshotInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SnapshotInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SnapshotInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Took) > 0 {
		i -= len(m.Took)
		copy(dAtA[i:], m.Took)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Took)))
		i--
		dAtA[i] = 0x4a
	}
	if m.SnapshotRevision != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.SnapshotRevision))
		i--
		dAtA[i] = 0x40
	}
	if m.SnapshotHash != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.SnapshotHash))
		i--
		dAtA[i] = 0x38
	}
	if m.SnapshotTotalKey != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.SnapshotTotalKey))
		i--
		dAtA[i] = 0x30
	}
	if len(m.SnapshotTotalSize) > 0 {
		i -= len(m.SnapshotTotalSize)
		copy(dAtA[i:], m.SnapshotTotalSize)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.SnapshotTotalSize)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.SnapshotFileSize) > 0 {
		i -= len(m.SnapshotFileSize)
		copy(dAtA[i:], m.SnapshotFileSize)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.SnapshotFileSize)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.SnapshotPath) > 0 {
		i -= len(m.SnapshotPath)
		copy(dAtA[i:], m.SnapshotPath)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.SnapshotPath)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.MemberClientURLs) > 0 {
		for iNdEx := len(m.MemberClientURLs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.MemberClientURLs[iNdEx])
			copy(dAtA[i:], m.MemberClientURLs[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.MemberClientURLs[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.MemberName) > 0 {
		i -= len(m.MemberName)
		copy(dAtA[i:], m.MemberName)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.MemberName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Response) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SnapshotInfo != nil {
		{
			size, err := m.SnapshotInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Member != nil {
		{
			size, err := m.Member.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x12
	}
	if m.Success {
		i--
		if m.Success {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Member) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Member) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Member) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Failpoints) > 0 {
		i -= len(m.Failpoints)
		copy(dAtA[i:], m.Failpoints)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Failpoints)))
		i--
		dAtA[i] = 0x2b
		i--
		dAtA[i] = 0xea
	}
	if m.SnapshotInfo != nil {
		{
			size, err := m.SnapshotInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x25
		i--
		dAtA[i] = 0xd2
	}
	if len(m.SnapshotPath) > 0 {
		i -= len(m.SnapshotPath)
		copy(dAtA[i:], m.SnapshotPath)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.SnapshotPath)))
		i--
		dAtA[i] = 0x25
		i--
		dAtA[i] = 0xca
	}
	if len(m.PeerTrustedCAPath) > 0 {
		i -= len(m.PeerTrustedCAPath)
		copy(dAtA[i:], m.PeerTrustedCAPath)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.PeerTrustedCAPath)))
		i--
		dAtA[i] = 0x1f
		i--
		dAtA[i] = 0xd2
	}
	if len(m.PeerTrustedCAData) > 0 {
		i -= len(m.PeerTrustedCAData)
		copy(dAtA[i:], m.PeerTrustedCAData)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.PeerTrustedCAData)))
		i--
		dAtA[i] = 0x1f
		i--
		dAtA[i] = 0xca
	}
	if len(m.PeerKeyPath) > 0 {
		i -= len(m.PeerKeyPath)
		copy(dAtA[i:], m.PeerKeyPath)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.PeerKeyPath)))
		i--
		dAtA[i] = 0x1f
		i--
		dAtA[i] = 0xc2
	}
	if len(m.PeerKeyData) > 0 {
		i -= len(m.PeerKeyData)
		copy(dAtA[i:], m.PeerKeyData)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.PeerKeyData)))
		i--
		dAtA[i] = 0x1f
		i--
		dAtA[i] = 0xba
	}
	if len(m.PeerCertPath) > 0 {
		i -= len(m.PeerCertPath)
		copy(dAtA[i:], m.PeerCertPath)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.PeerCertPath)))
		i--
		dAtA[i] = 0x1f
		i--
		dAtA[i] = 0xb2
	}
	if len(m.PeerCertData) > 0 {
		i -= len(m.PeerCertData)
		copy(dAtA[i:], m.PeerCertData)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.PeerCertData)))
		i--
		dAtA[i] = 0x1f
		i--
		dAtA[i] = 0xaa
	}
	if len(m.ClientTrustedCAPath) > 0 {
		i -= len(m.ClientTrustedCAPath)
		copy(dAtA[i:], m.ClientTrustedCAPath)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.ClientTrustedCAPath)))
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0xb2
	}
	if len(m.ClientTrustedCAData) > 0 {
		i -= len(m.ClientTrustedCAData)
		copy(dAtA[i:], m.ClientTrustedCAData)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.ClientTrustedCAData)))
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0xaa
	}
	if len(m.ClientKeyPath) > 0 {
		i -= len(m.ClientKeyPath)
		copy(dAtA[i:], m.ClientKeyPath)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.ClientKeyPath)))
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0xa2
	}
	if len(m.ClientKeyData) > 0 {
		i -= len(m.ClientKeyData)
		copy(dAtA[i:], m.ClientKeyData)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.ClientKeyData)))
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0x9a
	}
	if len(m.ClientCertPath) > 0 {
		i -= len(m.ClientCertPath)
		copy(dAtA[i:], m.ClientCertPath)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.ClientCertPath)))
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0x92
	}
	if len(m.ClientCertData) > 0 {
		i -= len(m.ClientCertData)
		copy(dAtA[i:], m.ClientCertData)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.ClientCertData)))
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0x8a
	}
	if m.EtcdOnSnapshotRestore != nil {
		{
			size, err := m.EtcdOnSnapshotRestore.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
		i--
		dAtA[i] = 0xfa
	}
	if m.Etcd != nil {
		{
			size, err := m.Etcd.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
		i--
		dAtA[i] = 0xf2
	}
	if len(m.EtcdClientEndpoint) > 0 {
		i -= len(m.EtcdClientEndpoint)
		copy(dAtA[i:], m.EtcdClientEndpoint)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.EtcdClientEndpoint)))
		i--
		dAtA[i] = 0x12
		i--
		dAtA[i] = 0xea
	}
	if m.EtcdPeerProxy {
		i--
		if m.EtcdPeerProxy {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xd0
	}
	if m.EtcdClientProxy {
		i--
		if m.EtcdClientProxy {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xc8
	}
	if len(m.BaseDir) > 0 {
		i -= len(m.BaseDir)
		copy(dAtA[i:], m.BaseDir)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.BaseDir)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	if len(m.FailpointHTTPAddr) > 0 {
		i -= len(m.FailpointHTTPAddr)
		copy(dAtA[i:], m.FailpointHTTPAddr)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.FailpointHTTPAddr)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.AgentAddr) > 0 {
		i -= len(m.AgentAddr)
		copy(dAtA[i:], m.AgentAddr)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.AgentAddr)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.EtcdExec) > 0 {
		i -= len(m.EtcdExec)
		copy(dAtA[i:], m.EtcdExec)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.EtcdExec)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Tester) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tester) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tester) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.StressQPS != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.StressQPS))
		i--
		dAtA[i] = 0x12
		i--
		dAtA[i] = 0xf0
	}
	if m.StressClients != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.StressClients))
		i--
		dAtA[i] = 0x12
		i--
		dAtA[i] = 0xe8
	}
	if m.StressKeyTxnOps != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.StressKeyTxnOps))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xe8
	}
	if m.StressKeySuffixRangeTxn != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.StressKeySuffixRangeTxn))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xe0
	}
	if m.StressKeySuffixRange != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.StressKeySuffixRange))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xd8
	}
	if m.StressKeySizeLarge != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.StressKeySizeLarge))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xd0
	}
	if m.StressKeySize != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.StressKeySize))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xc8
	}
	if len(m.Checkers) > 0 {
		for iNdEx := len(m.Checkers) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Checkers[iNdEx])
			copy(dAtA[i:], m.Checkers[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.Checkers[iNdEx])))
			i--
			dAtA[i] = 0x6
			i--
			dAtA[i] = 0xb2
		}
	}
	if len(m.Stressers) > 0 {
		for iNdEx := len(m.Stressers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Stressers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x6
			i--
			dAtA[i] = 0xaa
		}
	}
	if len(m.ExternalExecPath) > 0 {
		i -= len(m.ExternalExecPath)
		copy(dAtA[i:], m.ExternalExecPath)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.ExternalExecPath)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xd2
	}
	if len(m.RunnerExecPath) > 0 {
		i -= len(m.RunnerExecPath)
		copy(dAtA[i:], m.RunnerExecPath)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.RunnerExecPath)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xca
	}
	if len(m.FailpointCommands) > 0 {
		for iNdEx := len(m.FailpointCommands) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.FailpointCommands[iNdEx])
			copy(dAtA[i:], m.FailpointCommands[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.FailpointCommands[iNdEx])))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x92
		}
	}
	if len(m.Cases) > 0 {
		for iNdEx := len(m.Cases) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Cases[iNdEx])
			copy(dAtA[i:], m.Cases[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.Cases[iNdEx])))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x8a
		}
	}
	if m.CaseShuffle {
		i--
		if m.CaseShuffle {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x80
	}
	if m.CaseDelayMs != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.CaseDelayMs))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf8
	}
	if m.EnablePprof {
		i--
		if m.EnablePprof {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if m.ExitOnCaseFail {
		i--
		if m.ExitOnCaseFail {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb0
	}
	if m.RoundLimit != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.RoundLimit))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa8
	}
	if m.UpdatedDelayLatencyMs != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.UpdatedDelayLatencyMs))
		i--
		dAtA[i] = 0x68
	}
	if m.DelayLatencyMsRv != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.DelayLatencyMsRv))
		i--
		dAtA[i] = 0x60
	}
	if m.DelayLatencyMs != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.DelayLatencyMs))
		i--
		dAtA[i] = 0x58
	}
	if len(m.Addr) > 0 {
		i -= len(m.Addr)
		copy(dAtA[i:], m.Addr)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Addr)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Network) > 0 {
		i -= len(m.Network)
		copy(dAtA[i:], m.Network)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Network)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DataDir) > 0 {
		i -= len(m.DataDir)
		copy(dAtA[i:], m.DataDir)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.DataDir)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Stresser) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Stresser) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Stresser) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Weight != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Weight))))
		i--
		dAtA[i] = 0x11
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Etcd) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Etcd) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Etcd) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.LogLevel) > 0 {
		i -= len(m.LogLevel)
		copy(dAtA[i:], m.LogLevel)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.LogLevel)))
		i--
		dAtA[i] = 0x4
		i--
		dAtA[i] = 0xca
	}
	if len(m.LogOutputs) > 0 {
		for iNdEx := len(m.LogOutputs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.LogOutputs[iNdEx])
			copy(dAtA[i:], m.LogOutputs[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.LogOutputs[iNdEx])))
			i--
			dAtA[i] = 0x4
			i--
			dAtA[i] = 0xc2
		}
	}
	if len(m.Logger) > 0 {
		i -= len(m.Logger)
		copy(dAtA[i:], m.Logger)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Logger)))
		i--
		dAtA[i] = 0x4
		i--
		dAtA[i] = 0xba
	}
	if m.InitialCorruptCheck {
		i--
		if m.InitialCorruptCheck {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x4
		i--
		dAtA[i] = 0x80
	}
	if m.PreVote {
		i--
		if m.PreVote {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xf8
	}
	if m.QuotaBackendBytes != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.QuotaBackendBytes))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xa0
	}
	if m.SnapshotCount != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.SnapshotCount))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x98
	}
	if len(m.InitialClusterToken) > 0 {
		i -= len(m.InitialClusterToken)
		copy(dAtA[i:], m.InitialClusterToken)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.InitialClusterToken)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xda
	}
	if len(m.InitialClusterState) > 0 {
		i -= len(m.InitialClusterState)
		copy(dAtA[i:], m.InitialClusterState)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.InitialClusterState)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xd2
	}
	if len(m.InitialCluster) > 0 {
		i -= len(m.InitialCluster)
		copy(dAtA[i:], m.InitialCluster)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.InitialCluster)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xca
	}
	if len(m.PeerTrustedCAFile) > 0 {
		i -= len(m.PeerTrustedCAFile)
		copy(dAtA[i:], m.PeerTrustedCAFile)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.PeerTrustedCAFile)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xaa
	}
	if len(m.PeerKeyFile) > 0 {
		i -= len(m.PeerKeyFile)
		copy(dAtA[i:], m.PeerKeyFile)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.PeerKeyFile)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xa2
	}
	if len(m.PeerCertFile) > 0 {
		i -= len(m.PeerCertFile)
		copy(dAtA[i:], m.PeerCertFile)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.PeerCertFile)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x9a
	}
	if m.PeerClientCertAuth {
		i--
		if m.PeerClientCertAuth {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x90
	}
	if m.PeerAutoTLS {
		i--
		if m.PeerAutoTLS {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x88
	}
	if len(m.AdvertisePeerURLs) > 0 {
		for iNdEx := len(m.AdvertisePeerURLs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AdvertisePeerURLs[iNdEx])
			copy(dAtA[i:], m.AdvertisePeerURLs[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.AdvertisePeerURLs[iNdEx])))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x82
		}
	}
	if len(m.ListenPeerURLs) > 0 {
		for iNdEx := len(m.ListenPeerURLs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ListenPeerURLs[iNdEx])
			copy(dAtA[i:], m.ListenPeerURLs[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.ListenPeerURLs[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xfa
		}
	}
	if len(m.ClientTrustedCAFile) > 0 {
		i -= len(m.ClientTrustedCAFile)
		copy(dAtA[i:], m.ClientTrustedCAFile)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.ClientTrustedCAFile)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xda
	}
	if len(m.ClientKeyFile) > 0 {
		i -= len(m.ClientKeyFile)
		copy(dAtA[i:], m.ClientKeyFile)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.ClientKeyFile)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd2
	}
	if len(m.ClientCertFile) > 0 {
		i -= len(m.ClientCertFile)
		copy(dAtA[i:], m.ClientCertFile)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.ClientCertFile)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xca
	}
	if m.ClientCertAuth {
		i--
		if m.ClientCertAuth {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc0
	}
	if m.ClientAutoTLS {
		i--
		if m.ClientAutoTLS {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if len(m.AdvertiseClientURLs) > 0 {
		for iNdEx := len(m.AdvertiseClientURLs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AdvertiseClientURLs[iNdEx])
			copy(dAtA[i:], m.AdvertiseClientURLs[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.AdvertiseClientURLs[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xb2
		}
	}
	if len(m.ListenClientURLs) > 0 {
		for iNdEx := len(m.ListenClientURLs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ListenClientURLs[iNdEx])
			copy(dAtA[i:], m.ListenClientURLs[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.ListenClientURLs[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xaa
		}
	}
	if m.ElectionTimeoutMs != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.ElectionTimeoutMs))
		i--
		dAtA[i] = 0x60
	}
	if m.HeartbeatIntervalMs != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.HeartbeatIntervalMs))
		i--
		dAtA[i] = 0x58
	}
	if len(m.WALDir) > 0 {
		i -= len(m.WALDir)
		copy(dAtA[i:], m.WALDir)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.WALDir)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DataDir) > 0 {
		i -= len(m.DataDir)
		copy(dAtA[i:], m.DataDir)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.DataDir)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintRpc(dAtA []byte, offset int, v uint64) int {
	offset -= sovRpc(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Operation != 0 {
		n += 1 + sovRpc(uint64(m.Operation))
	}
	if m.Member != nil {
		l = m.Member.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.Tester != nil {
		l = m.Tester.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SnapshotInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.MemberName)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if len(m.MemberClientURLs) > 0 {
		for _, s := range m.MemberClientURLs {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	l = len(m.SnapshotPath)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.SnapshotFileSize)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.SnapshotTotalSize)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.SnapshotTotalKey != 0 {
		n += 1 + sovRpc(uint64(m.SnapshotTotalKey))
	}
	if m.SnapshotHash != 0 {
		n += 1 + sovRpc(uint64(m.SnapshotHash))
	}
	if m.SnapshotRevision != 0 {
		n += 1 + sovRpc(uint64(m.SnapshotRevision))
	}
	l = len(m.Took)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Response) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Success {
		n += 2
	}
	l = len(m.Status)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.Member != nil {
		l = m.Member.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.SnapshotInfo != nil {
		l = m.SnapshotInfo.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Member) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.EtcdExec)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.AgentAddr)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.FailpointHTTPAddr)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.BaseDir)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	if m.EtcdClientProxy {
		n += 3
	}
	if m.EtcdPeerProxy {
		n += 3
	}
	l = len(m.EtcdClientEndpoint)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	if m.Etcd != nil {
		l = m.Etcd.Size()
		n += 2 + l + sovRpc(uint64(l))
	}
	if m.EtcdOnSnapshotRestore != nil {
		l = m.EtcdOnSnapshotRestore.Size()
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.ClientCertData)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.ClientCertPath)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.ClientKeyData)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.ClientKeyPath)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.ClientTrustedCAData)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.ClientTrustedCAPath)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.PeerCertData)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.PeerCertPath)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.PeerKeyData)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.PeerKeyPath)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.PeerTrustedCAData)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.PeerTrustedCAPath)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.SnapshotPath)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	if m.SnapshotInfo != nil {
		l = m.SnapshotInfo.Size()
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.Failpoints)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tester) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DataDir)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.Network)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.DelayLatencyMs != 0 {
		n += 1 + sovRpc(uint64(m.DelayLatencyMs))
	}
	if m.DelayLatencyMsRv != 0 {
		n += 1 + sovRpc(uint64(m.DelayLatencyMsRv))
	}
	if m.UpdatedDelayLatencyMs != 0 {
		n += 1 + sovRpc(uint64(m.UpdatedDelayLatencyMs))
	}
	if m.RoundLimit != 0 {
		n += 2 + sovRpc(uint64(m.RoundLimit))
	}
	if m.ExitOnCaseFail {
		n += 3
	}
	if m.EnablePprof {
		n += 3
	}
	if m.CaseDelayMs != 0 {
		n += 2 + sovRpc(uint64(m.CaseDelayMs))
	}
	if m.CaseShuffle {
		n += 3
	}
	if len(m.Cases) > 0 {
		for _, s := range m.Cases {
			l = len(s)
			n += 2 + l + sovRpc(uint64(l))
		}
	}
	if len(m.FailpointCommands) > 0 {
		for _, s := range m.FailpointCommands {
			l = len(s)
			n += 2 + l + sovRpc(uint64(l))
		}
	}
	l = len(m.RunnerExecPath)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.ExternalExecPath)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	if len(m.Stressers) > 0 {
		for _, e := range m.Stressers {
			l = e.Size()
			n += 2 + l + sovRpc(uint64(l))
		}
	}
	if len(m.Checkers) > 0 {
		for _, s := range m.Checkers {
			l = len(s)
			n += 2 + l + sovRpc(uint64(l))
		}
	}
	if m.StressKeySize != 0 {
		n += 2 + sovRpc(uint64(m.StressKeySize))
	}
	if m.StressKeySizeLarge != 0 {
		n += 2 + sovRpc(uint64(m.StressKeySizeLarge))
	}
	if m.StressKeySuffixRange != 0 {
		n += 2 + sovRpc(uint64(m.StressKeySuffixRange))
	}
	if m.StressKeySuffixRangeTxn != 0 {
		n += 2 + sovRpc(uint64(m.StressKeySuffixRangeTxn))
	}
	if m.StressKeyTxnOps != 0 {
		n += 2 + sovRpc(uint64(m.StressKeyTxnOps))
	}
	if m.StressClients != 0 {
		n += 2 + sovRpc(uint64(m.StressClients))
	}
	if m.StressQPS != 0 {
		n += 2 + sovRpc(uint64(m.StressQPS))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Stresser) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.Weight != 0 {
		n += 9
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Etcd) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.DataDir)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.WALDir)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.HeartbeatIntervalMs != 0 {
		n += 1 + sovRpc(uint64(m.HeartbeatIntervalMs))
	}
	if m.ElectionTimeoutMs != 0 {
		n += 1 + sovRpc(uint64(m.ElectionTimeoutMs))
	}
	if len(m.ListenClientURLs) > 0 {
		for _, s := range m.ListenClientURLs {
			l = len(s)
			n += 2 + l + sovRpc(uint64(l))
		}
	}
	if len(m.AdvertiseClientURLs) > 0 {
		for _, s := range m.AdvertiseClientURLs {
			l = len(s)
			n += 2 + l + sovRpc(uint64(l))
		}
	}
	if m.ClientAutoTLS {
		n += 3
	}
	if m.ClientCertAuth {
		n += 3
	}
	l = len(m.ClientCertFile)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.ClientKeyFile)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.ClientTrustedCAFile)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	if len(m.ListenPeerURLs) > 0 {
		for _, s := range m.ListenPeerURLs {
			l = len(s)
			n += 2 + l + sovRpc(uint64(l))
		}
	}
	if len(m.AdvertisePeerURLs) > 0 {
		for _, s := range m.AdvertisePeerURLs {
			l = len(s)
			n += 2 + l + sovRpc(uint64(l))
		}
	}
	if m.PeerAutoTLS {
		n += 3
	}
	if m.PeerClientCertAuth {
		n += 3
	}
	l = len(m.PeerCertFile)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.PeerKeyFile)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.PeerTrustedCAFile)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.InitialCluster)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.InitialClusterState)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	l = len(m.InitialClusterToken)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	if m.SnapshotCount != 0 {
		n += 2 + sovRpc(uint64(m.SnapshotCount))
	}
	if m.QuotaBackendBytes != 0 {
		n += 2 + sovRpc(uint64(m.QuotaBackendBytes))
	}
	if m.PreVote {
		n += 3
	}
	if m.InitialCorruptCheck {
		n += 3
	}
	l = len(m.Logger)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	if len(m.LogOutputs) > 0 {
		for _, s := range m.LogOutputs {
			l = len(s)
			n += 2 + l + sovRpc(uint64(l))
		}
	}
	l = len(m.LogLevel)
	if l > 0 {
		n += 2 + l + sovRpc(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovRpc(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRpc(x uint64) (n int) {
	return sovRpc(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operation", wireType)
			}
			m.Operation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Operation |= Operation(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Member", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Member == nil {
				m.Member = &Member{}
			}
			if err := m.Member.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tester", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tester == nil {
				m.Tester = &Tester{}
			}
			if err := m.Tester.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SnapshotInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SnapshotInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SnapshotInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemberName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MemberName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemberClientURLs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MemberClientURLs = append(m.MemberClientURLs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnapshotPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SnapshotPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnapshotFileSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SnapshotFileSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnapshotTotalSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SnapshotTotalSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnapshotTotalKey", wireType)
			}
			m.SnapshotTotalKey = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SnapshotTotalKey |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnapshotHash", wireType)
			}
			m.SnapshotHash = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SnapshotHash |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnapshotRevision", wireType)
			}
			m.SnapshotRevision = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SnapshotRevision |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Took", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Took = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Success", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Success = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Member", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Member == nil {
				m.Member = &Member{}
			}
			if err := m.Member.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnapshotInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SnapshotInfo == nil {
				m.SnapshotInfo = &SnapshotInfo{}
			}
			if err := m.SnapshotInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Member) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Member: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Member: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EtcdExec", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EtcdExec = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AgentAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailpointHTTPAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FailpointHTTPAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseDir", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BaseDir = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 201:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EtcdClientProxy", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EtcdClientProxy = bool(v != 0)
		case 202:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EtcdPeerProxy", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EtcdPeerProxy = bool(v != 0)
		case 301:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EtcdClientEndpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EtcdClientEndpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 302:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Etcd", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Etcd == nil {
				m.Etcd = &Etcd{}
			}
			if err := m.Etcd.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 303:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EtcdOnSnapshotRestore", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EtcdOnSnapshotRestore == nil {
				m.EtcdOnSnapshotRestore = &Etcd{}
			}
			if err := m.EtcdOnSnapshotRestore.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 401:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientCertData", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientCertData = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 402:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientCertPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientCertPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 403:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientKeyData", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientKeyData = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 404:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientKeyPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientKeyPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 405:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientTrustedCAData", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientTrustedCAData = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 406:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientTrustedCAPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientTrustedCAPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 501:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerCertData", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PeerCertData = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 502:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerCertPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PeerCertPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 503:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerKeyData", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PeerKeyData = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 504:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerKeyPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PeerKeyPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 505:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerTrustedCAData", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PeerTrustedCAData = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 506:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerTrustedCAPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PeerTrustedCAPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 601:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnapshotPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SnapshotPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 602:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnapshotInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SnapshotInfo == nil {
				m.SnapshotInfo = &SnapshotInfo{}
			}
			if err := m.SnapshotInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 701:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Failpoints", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Failpoints = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tester) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tester: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tester: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataDir", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataDir = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Network = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DelayLatencyMs", wireType)
			}
			m.DelayLatencyMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DelayLatencyMs |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DelayLatencyMsRv", wireType)
			}
			m.DelayLatencyMsRv = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DelayLatencyMsRv |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatedDelayLatencyMs", wireType)
			}
			m.UpdatedDelayLatencyMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UpdatedDelayLatencyMs |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RoundLimit", wireType)
			}
			m.RoundLimit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RoundLimit |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 22:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExitOnCaseFail", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ExitOnCaseFail = bool(v != 0)
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnablePprof", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnablePprof = bool(v != 0)
		case 31:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaseDelayMs", wireType)
			}
			m.CaseDelayMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CaseDelayMs |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 32:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaseShuffle", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CaseShuffle = bool(v != 0)
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cases", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cases = append(m.Cases, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailpointCommands", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FailpointCommands = append(m.FailpointCommands, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 41:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunnerExecPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunnerExecPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 42:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalExecPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExternalExecPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stressers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Stressers = append(m.Stressers, &Stresser{})
			if err := m.Stressers[len(m.Stressers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 102:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checkers", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Checkers = append(m.Checkers, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 201:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StressKeySize", wireType)
			}
			m.StressKeySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StressKeySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 202:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StressKeySizeLarge", wireType)
			}
			m.StressKeySizeLarge = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StressKeySizeLarge |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 203:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StressKeySuffixRange", wireType)
			}
			m.StressKeySuffixRange = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StressKeySuffixRange |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 204:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StressKeySuffixRangeTxn", wireType)
			}
			m.StressKeySuffixRangeTxn = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StressKeySuffixRangeTxn |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 205:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StressKeyTxnOps", wireType)
			}
			m.StressKeyTxnOps = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StressKeyTxnOps |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 301:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StressClients", wireType)
			}
			m.StressClients = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StressClients |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 302:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StressQPS", wireType)
			}
			m.StressQPS = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StressQPS |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Stresser) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Stresser: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Stresser: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weight", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Weight = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Etcd) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Etcd: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Etcd: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataDir", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataDir = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WALDir", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WALDir = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatIntervalMs", wireType)
			}
			m.HeartbeatIntervalMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HeartbeatIntervalMs |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ElectionTimeoutMs", wireType)
			}
			m.ElectionTimeoutMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ElectionTimeoutMs |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListenClientURLs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ListenClientURLs = append(m.ListenClientURLs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdvertiseClientURLs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AdvertiseClientURLs = append(m.AdvertiseClientURLs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientAutoTLS", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ClientAutoTLS = bool(v != 0)
		case 24:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientCertAuth", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ClientCertAuth = bool(v != 0)
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientCertFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientCertFile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientKeyFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientKeyFile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientTrustedCAFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientTrustedCAFile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListenPeerURLs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ListenPeerURLs = append(m.ListenPeerURLs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdvertisePeerURLs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AdvertisePeerURLs = append(m.AdvertisePeerURLs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 33:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerAutoTLS", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PeerAutoTLS = bool(v != 0)
		case 34:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerClientCertAuth", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PeerClientCertAuth = bool(v != 0)
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerCertFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PeerCertFile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerKeyFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PeerKeyFile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerTrustedCAFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PeerTrustedCAFile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 41:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InitialCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 42:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialClusterState", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InitialClusterState = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 43:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialClusterToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InitialClusterToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 51:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnapshotCount", wireType)
			}
			m.SnapshotCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SnapshotCount |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 52:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field QuotaBackendBytes", wireType)
			}
			m.QuotaBackendBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.QuotaBackendBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 63:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PreVote", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PreVote = bool(v != 0)
		case 64:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialCorruptCheck", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.InitialCorruptCheck = bool(v != 0)
		case 71:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Logger", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Logger = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 72:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogOutputs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LogOutputs = append(m.LogOutputs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 73:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogLevel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LogLevel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRpc(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRpc
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRpc
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRpc
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRpc        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRpc          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRpc = fmt.Errorf("proto: unexpected end of group")
)
