/*
Copyright 2019 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha2

import (
	conversion "k8s.io/apimachinery/pkg/conversion"
	config "sigs.k8s.io/kind/pkg/cluster/config"
)

func Convert_v1alpha2_Config_To_config_Cluster(in *Config, out *config.Cluster, s conversion.Scope) error {
	foundFirstControlPlane := false // in v1alpha2 the first control plane is special
	for _, node := range in.Nodes {
		// skip nodes with no replicas
		if node.Replicas != nil && *node.Replicas == 0 {
			continue
		}

		// skip now-implicit external load balancers
		if node.Role == ExternalLoadBalancerRole {
			continue
		}

		// the first control plane is treated specially
		if !foundFirstControlPlane {
			if node.Role == ControlPlaneRole {
				foundFirstControlPlane = true
				// in particular, the first control plane's patches were
				// respected properly when generating the kubeadm config
				for _, patch := range node.KubeadmConfigPatches {
					out.KubeadmConfigPatches = append(out.KubeadmConfigPatches, patch)
				}
				for _, patch := range node.KubeadmConfigPatchesJSON6902 {
					out.KubeadmConfigPatchesJSON6902 = append(out.KubeadmConfigPatchesJSON6902, patch)
				}
			}
		}

		// convert the node
		convertedNode := config.Node{}
		if err := Convert_v1alpha2_Node_To_config_Node(&node, &convertedNode, s); err != nil {
			return err
		}
		out.Nodes = append(out.Nodes, convertedNode)

		// handle additional replicas if any
		if node.Replicas != nil && *node.Replicas > 1 {
			for i := int32(1); i < *node.Replicas; i++ {
				out.Nodes = append(out.Nodes, *convertedNode.DeepCopy())
			}
		}
	}
	// handle different cluster-wide default behavior between versions
	// this was a bad default, but it is what we did in v1alpha2
	out.Networking.APIServerAddress = "0.0.0.0"
	return nil
}

func Convert_v1alpha2_Node_To_config_Node(in *Node, out *config.Node, s conversion.Scope) error {
	return autoConvert_v1alpha2_Node_To_config_Node(in, out, s)
}

func Convert_config_Cluster_To_v1alpha2_Config(in *config.Cluster, out *Config, s conversion.Scope) error {
	foundFirstControlPlane := false // in v1alpha2 the first control plane is special
	for _, node := range in.Nodes {
		convertedNode := Node{}
		if err := Convert_config_Node_To_v1alpha2_Node(&node, &convertedNode, s); err != nil {
			return err
		}
		// the first control plane is treated specially
		if !foundFirstControlPlane {
			if convertedNode.Role == ControlPlaneRole {
				foundFirstControlPlane = true
			}
			// in v1alpha2 mode the first control plane node is the only one
			// for which patches were respected properly
			for _, patch := range in.KubeadmConfigPatches {
				convertedNode.KubeadmConfigPatches = append(convertedNode.KubeadmConfigPatches, patch)
			}
			for _, patch := range in.KubeadmConfigPatchesJSON6902 {
				convertedNode.KubeadmConfigPatchesJSON6902 = append(convertedNode.KubeadmConfigPatchesJSON6902, patch)
			}
		}

		out.Nodes = append(out.Nodes, convertedNode)
	}
	return nil
}

func Convert_config_Node_To_v1alpha2_Node(in *config.Node, out *Node, s conversion.Scope) error {
	return autoConvert_config_Node_To_v1alpha2_Node(in, out, s)
}
