/*
Copyright 2019 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// this comment makes golint ignore this file, feel free to edit the file.
// Code generated by not-actually-generated-but-go-away-golint. DO NOT EDIT.
// https://github.com/kubernetes/code-generator/issues/30

package v1alpha3

import (
	"k8s.io/apimachinery/pkg/runtime"

	"sigs.k8s.io/kind/pkg/cluster/config/defaults"
)

func addDefaultingFuncs(scheme *runtime.Scheme) error {
	return RegisterDefaults(scheme)
}

// SetDefaults_Cluster sets uninitialized fields to their default value.
func SetDefaults_Cluster(obj *Cluster) {
	// default to a one node cluster
	if len(obj.Nodes) == 0 {
		obj.Nodes = []Node{
			{
				Image: defaults.Image,
				Role:  ControlPlaneRole,
			},
		}
	}
	if obj.Networking.IPFamily == "" {
		obj.Networking.IPFamily = "ipv4"
	}
	// default to listening on 127.0.0.1:randomPort on ipv4
	// and [::1]:randomPort on ipv6
	if obj.Networking.APIServerAddress == "" {
		obj.Networking.APIServerAddress = "127.0.0.1"
		if obj.Networking.IPFamily == "ipv6" {
			obj.Networking.APIServerAddress = "::1"
		}
	}
	// default the pod CIDR
	if obj.Networking.PodSubnet == "" {
		obj.Networking.PodSubnet = "10.244.0.0/16"
		if obj.Networking.IPFamily == "ipv6" {
			obj.Networking.PodSubnet = "fd00:10:244::/64"
		}
	}
	// default the service CIDR using the kubeadm default
	// https://github.com/kubernetes/kubernetes/blob/746404f82a28e55e0b76ffa7e40306fb88eb3317/cmd/kubeadm/app/apis/kubeadm/v1beta2/defaults.go#L32
	// Note: kubeadm is doing it already but this simplifies kind's logic
	if obj.Networking.ServiceSubnet == "" {
		obj.Networking.ServiceSubnet = "10.96.0.0/12"
		if obj.Networking.IPFamily == "ipv6" {
			obj.Networking.ServiceSubnet = "fd00:10:96::/112"
		}
	}
}

// SetDefaults_Node sets uninitialized fields to their default value.
func SetDefaults_Node(obj *Node) {
	if obj.Image == "" {
		obj.Image = defaults.Image
	}

	if obj.Role == "" {
		obj.Role = ControlPlaneRole
	}
}
