// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigFunction(t *testing.T) {
	for name, src := range genTestEncodingValuesFunction() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigFunction()
				CopyOrigFunction(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigFunction(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigFunctionUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigFunction()
	UnmarshalJSONOrigFunction(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigFunction(), dest)
}

func TestMarshalAndUnmarshalJSONOrigFunction(t *testing.T) {
	for name, src := range genTestEncodingValuesFunction() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigFunction(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigFunction()
				UnmarshalJSONOrigFunction(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigFunction(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigFunctionFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesFunction() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigFunction()
			require.Error(t, UnmarshalProtoOrigFunction(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigFunctionUnknown(t *testing.T) {
	dest := NewOrigFunction()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigFunction(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigFunction(), dest)
}

func TestMarshalAndUnmarshalProtoOrigFunction(t *testing.T) {
	for name, src := range genTestEncodingValuesFunction() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigFunction(src))
				gotSize := MarshalProtoOrigFunction(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigFunction()
				require.NoError(t, UnmarshalProtoOrigFunction(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigFunction(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufFunction(t *testing.T) {
	for name, src := range genTestEncodingValuesFunction() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigFunction(src))
			gotSize := MarshalProtoOrigFunction(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.Function{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigFunction()
			require.NoError(t, UnmarshalProtoOrigFunction(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesFunction() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                      {0x02},
		"NameStrindex/wrong_wire_type":       {0xc},
		"NameStrindex/missing_value":         {0x8},
		"SystemNameStrindex/wrong_wire_type": {0x14},
		"SystemNameStrindex/missing_value":   {0x10},
		"FilenameStrindex/wrong_wire_type":   {0x1c},
		"FilenameStrindex/missing_value":     {0x18},
		"StartLine/wrong_wire_type":          {0x24},
		"StartLine/missing_value":            {0x20},
	}
}

func genTestEncodingValuesFunction() map[string]*otlpprofiles.Function {
	return map[string]*otlpprofiles.Function{
		"empty":                   NewOrigFunction(),
		"NameStrindex/test":       {NameStrindex: int32(13)},
		"SystemNameStrindex/test": {SystemNameStrindex: int32(13)},
		"FilenameStrindex/test":   {FilenameStrindex: int32(13)},
		"StartLine/test":          {StartLine: int64(13)},
	}
}
