// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"iter"
	"sort"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

// ValueTypeSlice logically represents a slice of ValueType.
//
// This is a reference type. If passed by value and callee modifies it, the
// caller will see the modification.
//
// Must use NewValueTypeSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ValueTypeSlice struct {
	orig  *[]*otlpprofiles.ValueType
	state *internal.State
}

func newValueTypeSlice(orig *[]*otlpprofiles.ValueType, state *internal.State) ValueTypeSlice {
	return ValueTypeSlice{orig: orig, state: state}
}

// NewValueTypeSlice creates a ValueTypeSlice with 0 elements.
// Can use "EnsureCapacity" to initialize with a given capacity.
func NewValueTypeSlice() ValueTypeSlice {
	orig := []*otlpprofiles.ValueType(nil)
	state := internal.StateMutable
	return newValueTypeSlice(&orig, &state)
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewValueTypeSlice()".
func (es ValueTypeSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
//
//	for i := 0; i < es.Len(); i++ {
//	    e := es.At(i)
//	    ... // Do something with the element
//	}
func (es ValueTypeSlice) At(i int) ValueType {
	return newValueType((*es.orig)[i], es.state)
}

// All returns an iterator over index-value pairs in the slice.
//
//	for i, v := range es.All() {
//	    ... // Do something with index-value pair
//	}
func (es ValueTypeSlice) All() iter.Seq2[int, ValueType] {
	return func(yield func(int, ValueType) bool) {
		for i := 0; i < es.Len(); i++ {
			if !yield(i, es.At(i)) {
				return
			}
		}
	}
}

// EnsureCapacity is an operation that ensures the slice has at least the specified capacity.
// 1. If the newCap <= cap then no change in capacity.
// 2. If the newCap > cap then the slice capacity will be expanded to equal newCap.
//
// Here is how a new ValueTypeSlice can be initialized:
//
//	es := NewValueTypeSlice()
//	es.EnsureCapacity(4)
//	for i := 0; i < 4; i++ {
//	    e := es.AppendEmpty()
//	    // Here should set all the values for e.
//	}
func (es ValueTypeSlice) EnsureCapacity(newCap int) {
	es.state.AssertMutable()
	oldCap := cap(*es.orig)
	if newCap <= oldCap {
		return
	}

	newOrig := make([]*otlpprofiles.ValueType, len(*es.orig), newCap)
	copy(newOrig, *es.orig)
	*es.orig = newOrig
}

// AppendEmpty will append to the end of the slice an empty ValueType.
// It returns the newly added ValueType.
func (es ValueTypeSlice) AppendEmpty() ValueType {
	es.state.AssertMutable()
	*es.orig = append(*es.orig, &otlpprofiles.ValueType{})
	return es.At(es.Len() - 1)
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es ValueTypeSlice) MoveAndAppendTo(dest ValueTypeSlice) {
	es.state.AssertMutable()
	dest.state.AssertMutable()
	// If they point to the same data, they are the same, nothing to do.
	if es.orig == dest.orig {
		return
	}
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// RemoveIf calls f sequentially for each element present in the slice.
// If f returns true, the element is removed from the slice.
func (es ValueTypeSlice) RemoveIf(f func(ValueType) bool) {
	es.state.AssertMutable()
	newLen := 0
	for i := 0; i < len(*es.orig); i++ {
		if f(es.At(i)) {
			continue
		}
		if newLen == i {
			// Nothing to move, element is at the right place.
			newLen++
			continue
		}
		(*es.orig)[newLen] = (*es.orig)[i]
		newLen++
	}
	*es.orig = (*es.orig)[:newLen]
}

// CopyTo copies all elements from the current slice overriding the destination.
func (es ValueTypeSlice) CopyTo(dest ValueTypeSlice) {
	dest.state.AssertMutable()
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newValueType((*es.orig)[i], es.state).CopyTo(newValueType((*dest.orig)[i], dest.state))
		}
		return
	}
	origs := make([]otlpprofiles.ValueType, srcLen)
	wrappers := make([]*otlpprofiles.ValueType, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newValueType((*es.orig)[i], es.state).CopyTo(newValueType(wrappers[i], dest.state))
	}
	*dest.orig = wrappers
}

// Sort sorts the ValueType elements within ValueTypeSlice given the
// provided less function so that two instances of ValueTypeSlice
// can be compared.
func (es ValueTypeSlice) Sort(less func(a, b ValueType) bool) {
	es.state.AssertMutable()
	sort.SliceStable(*es.orig, func(i, j int) bool { return less(es.At(i), es.At(j)) })
}
