// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func CopyOrigExponentialHistogramDataPointSlice(dest, src []*otlpmetrics.ExponentialHistogramDataPoint) []*otlpmetrics.ExponentialHistogramDataPoint {
	var newDest []*otlpmetrics.ExponentialHistogramDataPoint
	if cap(dest) < len(src) {
		newDest = make([]*otlpmetrics.ExponentialHistogramDataPoint, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpmetrics.ExponentialHistogramDataPoint{}
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpmetrics.ExponentialHistogramDataPoint{}
		}
	}
	for i := range src {
		CopyOrigExponentialHistogramDataPoint(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestExponentialHistogramDataPointSlice() []*otlpmetrics.ExponentialHistogramDataPoint {
	orig := make([]*otlpmetrics.ExponentialHistogramDataPoint, 7)
	for i := 0; i < 7; i++ {
		orig[i] = &otlpmetrics.ExponentialHistogramDataPoint{}
		FillOrigTestExponentialHistogramDataPoint(orig[i])
	}
	return orig
}

// UnmarshalJSONOrigExponentialHistogramDataPointSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExponentialHistogramDataPointSlice(iter *json.Iterator) []*otlpmetrics.ExponentialHistogramDataPoint {
	var orig []*otlpmetrics.ExponentialHistogramDataPoint
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, &otlpmetrics.ExponentialHistogramDataPoint{})
		UnmarshalJSONOrigExponentialHistogramDataPoint(orig[len(orig)-1], iter)
		return true
	})
	return orig
}
