// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpcollectorprofile "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportProfilesPartialSuccess(t *testing.T) {
	src := &otlpcollectorprofile.ExportProfilesPartialSuccess{}
	dest := &otlpcollectorprofile.ExportProfilesPartialSuccess{}
	CopyOrigExportProfilesPartialSuccess(dest, src)
	assert.Equal(t, &otlpcollectorprofile.ExportProfilesPartialSuccess{}, dest)
	FillOrigTestExportProfilesPartialSuccess(src)
	CopyOrigExportProfilesPartialSuccess(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportProfilesPartialSuccessUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpcollectorprofile.ExportProfilesPartialSuccess{}
	UnmarshalJSONOrigExportProfilesPartialSuccess(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpcollectorprofile.ExportProfilesPartialSuccess{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportProfilesPartialSuccess(t *testing.T) {
	for name, src := range getEncodingTestValuesExportProfilesPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExportProfilesPartialSuccess(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpcollectorprofile.ExportProfilesPartialSuccess{}
			UnmarshalJSONOrigExportProfilesPartialSuccess(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportProfilesPartialSuccess(t *testing.T) {
	for name, src := range getEncodingTestValuesExportProfilesPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportProfilesPartialSuccess(src))
			gotSize := MarshalProtoOrigExportProfilesPartialSuccess(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpcollectorprofile.ExportProfilesPartialSuccess{}
			require.NoError(t, UnmarshalProtoOrigExportProfilesPartialSuccess(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExportProfilesPartialSuccess() map[string]*otlpcollectorprofile.ExportProfilesPartialSuccess {
	return map[string]*otlpcollectorprofile.ExportProfilesPartialSuccess{
		"empty": {},
		"fill_test": func() *otlpcollectorprofile.ExportProfilesPartialSuccess {
			src := &otlpcollectorprofile.ExportProfilesPartialSuccess{}
			FillOrigTestExportProfilesPartialSuccess(src)
			return src
		}(),
	}
}
