// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpcollectorprofile "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportProfilesServiceRequest(t *testing.T) {
	src := &otlpcollectorprofile.ExportProfilesServiceRequest{}
	dest := &otlpcollectorprofile.ExportProfilesServiceRequest{}
	CopyOrigExportProfilesServiceRequest(dest, src)
	assert.Equal(t, &otlpcollectorprofile.ExportProfilesServiceRequest{}, dest)
	FillOrigTestExportProfilesServiceRequest(src)
	CopyOrigExportProfilesServiceRequest(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportProfilesServiceRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpcollectorprofile.ExportProfilesServiceRequest{}
	UnmarshalJSONOrigExportProfilesServiceRequest(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpcollectorprofile.ExportProfilesServiceRequest{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportProfilesServiceRequest(t *testing.T) {
	for name, src := range getEncodingTestValuesExportProfilesServiceRequest() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExportProfilesServiceRequest(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpcollectorprofile.ExportProfilesServiceRequest{}
			UnmarshalJSONOrigExportProfilesServiceRequest(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportProfilesServiceRequest(t *testing.T) {
	for name, src := range getEncodingTestValuesExportProfilesServiceRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportProfilesServiceRequest(src))
			gotSize := MarshalProtoOrigExportProfilesServiceRequest(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpcollectorprofile.ExportProfilesServiceRequest{}
			require.NoError(t, UnmarshalProtoOrigExportProfilesServiceRequest(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExportProfilesServiceRequest() map[string]*otlpcollectorprofile.ExportProfilesServiceRequest {
	return map[string]*otlpcollectorprofile.ExportProfilesServiceRequest{
		"empty": {},
		"fill_test": func() *otlpcollectorprofile.ExportProfilesServiceRequest {
			src := &otlpcollectorprofile.ExportProfilesServiceRequest{}
			FillOrigTestExportProfilesServiceRequest(src)
			return src
		}(),
	}
}
