// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigFunction(dest, src *otlpprofiles.Function) {
	dest.NameStrindex = src.NameStrindex
	dest.SystemNameStrindex = src.SystemNameStrindex
	dest.FilenameStrindex = src.FilenameStrindex
	dest.StartLine = src.StartLine
}

func FillOrigTestFunction(orig *otlpprofiles.Function) {
	orig.NameStrindex = int32(13)
	orig.SystemNameStrindex = int32(13)
	orig.FilenameStrindex = int32(13)
	orig.StartLine = int64(13)
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigFunction(orig *otlpprofiles.Function, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.NameStrindex != int32(0) {
		dest.WriteObjectField("nameStrindex")
		dest.WriteInt32(orig.NameStrindex)
	}
	if orig.SystemNameStrindex != int32(0) {
		dest.WriteObjectField("systemNameStrindex")
		dest.WriteInt32(orig.SystemNameStrindex)
	}
	if orig.FilenameStrindex != int32(0) {
		dest.WriteObjectField("filenameStrindex")
		dest.WriteInt32(orig.FilenameStrindex)
	}
	if orig.StartLine != int64(0) {
		dest.WriteObjectField("startLine")
		dest.WriteInt64(orig.StartLine)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigFunction unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigFunction(orig *otlpprofiles.Function, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "nameStrindex", "name_strindex":
			orig.NameStrindex = iter.ReadInt32()
		case "systemNameStrindex", "system_name_strindex":
			orig.SystemNameStrindex = iter.ReadInt32()
		case "filenameStrindex", "filename_strindex":
			orig.FilenameStrindex = iter.ReadInt32()
		case "startLine", "start_line":
			orig.StartLine = iter.ReadInt64()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigFunction(orig *otlpprofiles.Function) int {
	var n int
	var l int
	_ = l
	if orig.NameStrindex != 0 {
		n += 1 + proto.Sov(uint64(orig.NameStrindex))
	}
	if orig.SystemNameStrindex != 0 {
		n += 1 + proto.Sov(uint64(orig.SystemNameStrindex))
	}
	if orig.FilenameStrindex != 0 {
		n += 1 + proto.Sov(uint64(orig.FilenameStrindex))
	}
	if orig.StartLine != 0 {
		n += 1 + proto.Sov(uint64(orig.StartLine))
	}
	return n
}

func MarshalProtoOrigFunction(orig *otlpprofiles.Function, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.NameStrindex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.NameStrindex))
		pos--
		buf[pos] = 0x8
	}
	if orig.SystemNameStrindex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.SystemNameStrindex))
		pos--
		buf[pos] = 0x10
	}
	if orig.FilenameStrindex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.FilenameStrindex))
		pos--
		buf[pos] = 0x18
	}
	if orig.StartLine != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.StartLine))
		pos--
		buf[pos] = 0x20
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigFunction(orig *otlpprofiles.Function, buf []byte) error {
	return orig.Unmarshal(buf)
}
