// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigInstrumentationScope(t *testing.T) {
	src := &otlpcommon.InstrumentationScope{}
	dest := &otlpcommon.InstrumentationScope{}
	CopyOrigInstrumentationScope(dest, src)
	assert.Equal(t, &otlpcommon.InstrumentationScope{}, dest)
	FillOrigTestInstrumentationScope(src)
	CopyOrigInstrumentationScope(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigInstrumentationScopeUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpcommon.InstrumentationScope{}
	UnmarshalJSONOrigInstrumentationScope(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpcommon.InstrumentationScope{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigInstrumentationScope(t *testing.T) {
	for name, src := range getEncodingTestValuesInstrumentationScope() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigInstrumentationScope(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpcommon.InstrumentationScope{}
			UnmarshalJSONOrigInstrumentationScope(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigInstrumentationScope(t *testing.T) {
	for name, src := range getEncodingTestValuesInstrumentationScope() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigInstrumentationScope(src))
			gotSize := MarshalProtoOrigInstrumentationScope(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpcommon.InstrumentationScope{}
			require.NoError(t, UnmarshalProtoOrigInstrumentationScope(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesInstrumentationScope() map[string]*otlpcommon.InstrumentationScope {
	return map[string]*otlpcommon.InstrumentationScope{
		"empty": {},
		"fill_test": func() *otlpcommon.InstrumentationScope {
			src := &otlpcommon.InstrumentationScope{}
			FillOrigTestInstrumentationScope(src)
			return src
		}(),
	}
}
