// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigLocation(t *testing.T) {
	src := &otlpprofiles.Location{}
	dest := &otlpprofiles.Location{}
	CopyOrigLocation(dest, src)
	assert.Equal(t, &otlpprofiles.Location{}, dest)
	FillOrigTestLocation(src)
	CopyOrigLocation(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigLocationUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpprofiles.Location{}
	UnmarshalJSONOrigLocation(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpprofiles.Location{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigLocation(t *testing.T) {
	for name, src := range getEncodingTestValuesLocation() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigLocation(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpprofiles.Location{}
			UnmarshalJSONOrigLocation(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigLocation(t *testing.T) {
	for name, src := range getEncodingTestValuesLocation() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigLocation(src))
			gotSize := MarshalProtoOrigLocation(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpprofiles.Location{}
			require.NoError(t, UnmarshalProtoOrigLocation(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesLocation() map[string]*otlpprofiles.Location {
	return map[string]*otlpprofiles.Location{
		"empty": {},
		"fill_test": func() *otlpprofiles.Location {
			src := &otlpprofiles.Location{}
			FillOrigTestLocation(src)
			return src
		}(),
		"default_mappingindex": {MappingIndex_: &otlpprofiles.Location_MappingIndex{MappingIndex: int32(0)}},
	}
}
