// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigResourceSpans(t *testing.T) {
	src := &otlptrace.ResourceSpans{}
	dest := &otlptrace.ResourceSpans{}
	CopyOrigResourceSpans(dest, src)
	assert.Equal(t, &otlptrace.ResourceSpans{}, dest)
	FillOrigTestResourceSpans(src)
	CopyOrigResourceSpans(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigResourceSpansUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlptrace.ResourceSpans{}
	UnmarshalJSONOrigResourceSpans(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlptrace.ResourceSpans{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigResourceSpans(t *testing.T) {
	for name, src := range getEncodingTestValuesResourceSpans() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigResourceSpans(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlptrace.ResourceSpans{}
			UnmarshalJSONOrigResourceSpans(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigResourceSpans(t *testing.T) {
	for name, src := range getEncodingTestValuesResourceSpans() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigResourceSpans(src))
			gotSize := MarshalProtoOrigResourceSpans(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlptrace.ResourceSpans{}
			require.NoError(t, UnmarshalProtoOrigResourceSpans(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesResourceSpans() map[string]*otlptrace.ResourceSpans {
	return map[string]*otlptrace.ResourceSpans{
		"empty": {},
		"fill_test": func() *otlptrace.ResourceSpans {
			src := &otlptrace.ResourceSpans{}
			FillOrigTestResourceSpans(src)
			return src
		}(),
	}
}
