// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func CopyOrigSpanSlice(dest, src []*otlptrace.Span) []*otlptrace.Span {
	var newDest []*otlptrace.Span
	if cap(dest) < len(src) {
		newDest = make([]*otlptrace.Span, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlptrace.Span{}
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlptrace.Span{}
		}
	}
	for i := range src {
		CopyOrigSpan(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestSpanSlice() []*otlptrace.Span {
	orig := make([]*otlptrace.Span, 7)
	for i := 0; i < 7; i++ {
		orig[i] = &otlptrace.Span{}
		FillOrigTestSpan(orig[i])
	}
	return orig
}

// UnmarshalJSONOrigSpanSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigSpanSlice(iter *json.Iterator) []*otlptrace.Span {
	var orig []*otlptrace.Span
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, &otlptrace.Span{})
		UnmarshalJSONOrigSpan(orig[len(orig)-1], iter)
		return true
	})
	return orig
}
