// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestLocation_MoveTo(t *testing.T) {
	ms := generateTestLocation()
	dest := NewLocation()
	ms.MoveTo(dest)
	assert.Equal(t, NewLocation(), ms)
	assert.Equal(t, generateTestLocation(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestLocation(), dest)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.MoveTo(newLocation(&otlpprofiles.Location{}, &sharedState)) })
	assert.Panics(t, func() { newLocation(&otlpprofiles.Location{}, &sharedState).MoveTo(dest) })
}

func TestLocation_CopyTo(t *testing.T) {
	ms := NewLocation()
	orig := NewLocation()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestLocation()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.CopyTo(newLocation(&otlpprofiles.Location{}, &sharedState)) })
}

func TestLocation_MappingIndex(t *testing.T) {
	ms := NewLocation()
	assert.Equal(t, int32(0), ms.MappingIndex())
	ms.SetMappingIndex(int32(13))
	assert.True(t, ms.HasMappingIndex())
	assert.Equal(t, int32(13), ms.MappingIndex())
	ms.RemoveMappingIndex()
	assert.False(t, ms.HasMappingIndex())
	dest := NewLocation()
	dest.SetMappingIndex(int32(13))
	ms.CopyTo(dest)
	assert.False(t, dest.HasMappingIndex())
}

func TestLocation_Address(t *testing.T) {
	ms := NewLocation()
	assert.Equal(t, uint64(0), ms.Address())
	ms.SetAddress(uint64(13))
	assert.Equal(t, uint64(13), ms.Address())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newLocation(&otlpprofiles.Location{}, &sharedState).SetAddress(uint64(13)) })
}

func TestLocation_Line(t *testing.T) {
	ms := NewLocation()
	assert.Equal(t, NewLineSlice(), ms.Line())
	ms.orig.Line = internal.GenerateOrigTestLineSlice()
	assert.Equal(t, generateTestLineSlice(), ms.Line())
}

func TestLocation_IsFolded(t *testing.T) {
	ms := NewLocation()
	assert.False(t, ms.IsFolded())
	ms.SetIsFolded(true)
	assert.True(t, ms.IsFolded())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newLocation(&otlpprofiles.Location{}, &sharedState).SetIsFolded(true) })
}

func TestLocation_AttributeIndices(t *testing.T) {
	ms := NewLocation()
	assert.Equal(t, pcommon.NewInt32Slice(), ms.AttributeIndices())
	ms.orig.AttributeIndices = internal.GenerateOrigTestInt32Slice()
	assert.Equal(t, pcommon.Int32Slice(internal.GenerateTestInt32Slice()), ms.AttributeIndices())
}

func generateTestLocation() Location {
	ms := NewLocation()
	internal.FillOrigTestLocation(ms.orig)
	return ms
}
