// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpcollectorprofile "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/profiles/v1development"
)

func TestProfiles_MoveTo(t *testing.T) {
	ms := generateTestProfiles()
	dest := NewProfiles()
	ms.MoveTo(dest)
	assert.Equal(t, NewProfiles(), ms)
	assert.Equal(t, generateTestProfiles(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestProfiles(), dest)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.MoveTo(newProfiles(&otlpcollectorprofile.ExportProfilesServiceRequest{}, &sharedState)) })
	assert.Panics(t, func() { newProfiles(&otlpcollectorprofile.ExportProfilesServiceRequest{}, &sharedState).MoveTo(dest) })
}

func TestProfiles_CopyTo(t *testing.T) {
	ms := NewProfiles()
	orig := NewProfiles()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestProfiles()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.CopyTo(newProfiles(&otlpcollectorprofile.ExportProfilesServiceRequest{}, &sharedState)) })
}

func TestProfiles_ResourceProfiles(t *testing.T) {
	ms := NewProfiles()
	assert.Equal(t, NewResourceProfilesSlice(), ms.ResourceProfiles())
	ms.getOrig().ResourceProfiles = internal.GenerateOrigTestResourceProfilesSlice()
	assert.Equal(t, generateTestResourceProfilesSlice(), ms.ResourceProfiles())
}

func TestProfiles_ProfilesDictionary(t *testing.T) {
	ms := NewProfiles()
	assert.Equal(t, NewProfilesDictionary(), ms.ProfilesDictionary())
	internal.FillOrigTestProfilesDictionary(&ms.getOrig().Dictionary)
	assert.Equal(t, generateTestProfilesDictionary(), ms.ProfilesDictionary())
}

func generateTestProfiles() Profiles {
	return Profiles(internal.GenerateTestProfiles())
}
