// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofileotlp

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpcollectorprofile "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/profiles/v1development"
)

func TestExportResponse_MoveTo(t *testing.T) {
	ms := generateTestExportResponse()
	dest := NewExportResponse()
	ms.MoveTo(dest)
	assert.Equal(t, NewExportResponse(), ms)
	assert.Equal(t, generateTestExportResponse(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestExportResponse(), dest)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() {
		ms.MoveTo(newExportResponse(&otlpcollectorprofile.ExportProfilesServiceResponse{}, &sharedState))
	})
	assert.Panics(t, func() {
		newExportResponse(&otlpcollectorprofile.ExportProfilesServiceResponse{}, &sharedState).MoveTo(dest)
	})
}

func TestExportResponse_CopyTo(t *testing.T) {
	ms := NewExportResponse()
	orig := NewExportResponse()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestExportResponse()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() {
		ms.CopyTo(newExportResponse(&otlpcollectorprofile.ExportProfilesServiceResponse{}, &sharedState))
	})
}

func TestExportResponse_PartialSuccess(t *testing.T) {
	ms := NewExportResponse()
	assert.Equal(t, NewExportPartialSuccess(), ms.PartialSuccess())
	internal.FillOrigTestExportProfilesPartialSuccess(&ms.orig.PartialSuccess)
	assert.Equal(t, generateTestExportPartialSuccess(), ms.PartialSuccess())
}

func generateTestExportResponse() ExportResponse {
	ms := NewExportResponse()
	internal.FillOrigTestExportProfilesServiceResponse(ms.orig)
	return ms
}
