// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type EntityRef struct {
	orig  *otlpcommon.EntityRef
	state *State
}

func GetOrigEntityRef(ms EntityRef) *otlpcommon.EntityRef {
	return ms.orig
}

func GetEntityRefState(ms EntityRef) *State {
	return ms.state
}

func NewEntityRef(orig *otlpcommon.EntityRef, state *State) EntityRef {
	return EntityRef{orig: orig, state: state}
}

func GenerateTestEntityRef() EntityRef {
	orig := otlpcommon.EntityRef{}
	FillOrigTestEntityRef(&orig)
	state := StateMutable
	return NewEntityRef(&orig, &state)
}

func CopyOrigEntityRef(dest, src *otlpcommon.EntityRef) {
	dest.SchemaUrl = src.SchemaUrl
	dest.Type = src.Type
	dest.IdKeys = CopyOrigStringSlice(dest.IdKeys, src.IdKeys)
	dest.DescriptionKeys = CopyOrigStringSlice(dest.DescriptionKeys, src.DescriptionKeys)
}

func FillOrigTestEntityRef(orig *otlpcommon.EntityRef) {
	orig.SchemaUrl = "test_schemaurl"
	orig.Type = "test_type"
	orig.IdKeys = GenerateOrigTestStringSlice()
	orig.DescriptionKeys = GenerateOrigTestStringSlice()
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigEntityRef(orig *otlpcommon.EntityRef, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	if orig.Type != "" {
		dest.WriteObjectField("type")
		dest.WriteString(orig.Type)
	}
	if len(orig.IdKeys) > 0 {
		dest.WriteObjectField("idKeys")
		dest.WriteArrayStart()
		dest.WriteString(orig.IdKeys[0])
		for i := 1; i < len(orig.IdKeys); i++ {
			dest.WriteMore()
			dest.WriteString(orig.IdKeys[i])
		}
		dest.WriteArrayEnd()
	}
	if len(orig.DescriptionKeys) > 0 {
		dest.WriteObjectField("descriptionKeys")
		dest.WriteArrayStart()
		dest.WriteString(orig.DescriptionKeys[0])
		for i := 1; i < len(orig.DescriptionKeys); i++ {
			dest.WriteMore()
			dest.WriteString(orig.DescriptionKeys[i])
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigEntityRef unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigEntityRef(orig *otlpcommon.EntityRef, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		case "type":
			orig.Type = iter.ReadString()
		case "idKeys", "id_keys":
			orig.IdKeys = UnmarshalJSONOrigStringSlice(iter)
		case "descriptionKeys", "description_keys":
			orig.DescriptionKeys = UnmarshalJSONOrigStringSlice(iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigEntityRef(orig *otlpcommon.EntityRef) int {
	var n int
	var l int
	_ = l
	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.Type)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for _, s := range orig.IdKeys {
		l = len(s)
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for _, s := range orig.DescriptionKeys {
		l = len(s)
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigEntityRef(orig *otlpcommon.EntityRef, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	l = len(orig.Type)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Type)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	for i := len(orig.IdKeys) - 1; i >= 0; i-- {
		l = len(orig.IdKeys[i])
		pos -= l
		copy(buf[pos:], orig.IdKeys[i])
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	for i := len(orig.DescriptionKeys) - 1; i >= 0; i-- {
		l = len(orig.DescriptionKeys[i])
		pos -= l
		copy(buf[pos:], orig.DescriptionKeys[i])
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x22
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigEntityRef(orig *otlpcommon.EntityRef, buf []byte) error {
	return orig.Unmarshal(buf)
}
