// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcollectorlog "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type Logs struct {
	orig  *otlpcollectorlog.ExportLogsServiceRequest
	state *State
}

func GetOrigLogs(ms Logs) *otlpcollectorlog.ExportLogsServiceRequest {
	return ms.orig
}

func GetLogsState(ms Logs) *State {
	return ms.state
}

func NewLogs(orig *otlpcollectorlog.ExportLogsServiceRequest, state *State) Logs {
	return Logs{orig: orig, state: state}
}

func GenerateTestLogs() Logs {
	orig := otlpcollectorlog.ExportLogsServiceRequest{}
	FillOrigTestExportLogsServiceRequest(&orig)
	state := StateMutable
	return NewLogs(&orig, &state)
}

func CopyOrigExportLogsServiceRequest(dest, src *otlpcollectorlog.ExportLogsServiceRequest) {
	dest.ResourceLogs = CopyOrigResourceLogsSlice(dest.ResourceLogs, src.ResourceLogs)
}

func FillOrigTestExportLogsServiceRequest(orig *otlpcollectorlog.ExportLogsServiceRequest) {
	orig.ResourceLogs = GenerateOrigTestResourceLogsSlice()
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportLogsServiceRequest(orig *otlpcollectorlog.ExportLogsServiceRequest, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.ResourceLogs) > 0 {
		dest.WriteObjectField("resourceLogs")
		dest.WriteArrayStart()
		MarshalJSONOrigResourceLogs(orig.ResourceLogs[0], dest)
		for i := 1; i < len(orig.ResourceLogs); i++ {
			dest.WriteMore()
			MarshalJSONOrigResourceLogs(orig.ResourceLogs[i], dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigLogs unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportLogsServiceRequest(orig *otlpcollectorlog.ExportLogsServiceRequest, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "resourceLogs", "resource_logs":
			orig.ResourceLogs = UnmarshalJSONOrigResourceLogsSlice(iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigExportLogsServiceRequest(orig *otlpcollectorlog.ExportLogsServiceRequest) int {
	var n int
	var l int
	_ = l
	for i := range orig.ResourceLogs {
		l = SizeProtoOrigResourceLogs(orig.ResourceLogs[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigExportLogsServiceRequest(orig *otlpcollectorlog.ExportLogsServiceRequest, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := range orig.ResourceLogs {
		l = MarshalProtoOrigResourceLogs(orig.ResourceLogs[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigExportLogsServiceRequest(orig *otlpcollectorlog.ExportLogsServiceRequest, buf []byte) error {
	return orig.Unmarshal(buf)
}
