// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpcollectormetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportMetricsServiceRequest(t *testing.T) {
	src := &otlpcollectormetrics.ExportMetricsServiceRequest{}
	dest := &otlpcollectormetrics.ExportMetricsServiceRequest{}
	CopyOrigExportMetricsServiceRequest(dest, src)
	assert.Equal(t, &otlpcollectormetrics.ExportMetricsServiceRequest{}, dest)
	FillOrigTestExportMetricsServiceRequest(src)
	CopyOrigExportMetricsServiceRequest(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportMetricsServiceRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpcollectormetrics.ExportMetricsServiceRequest{}
	UnmarshalJSONOrigExportMetricsServiceRequest(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpcollectormetrics.ExportMetricsServiceRequest{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportMetricsServiceRequest(t *testing.T) {
	for name, src := range getEncodingTestValuesExportMetricsServiceRequest() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExportMetricsServiceRequest(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpcollectormetrics.ExportMetricsServiceRequest{}
			UnmarshalJSONOrigExportMetricsServiceRequest(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportMetricsServiceRequest(t *testing.T) {
	for name, src := range getEncodingTestValuesExportMetricsServiceRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportMetricsServiceRequest(src))
			gotSize := MarshalProtoOrigExportMetricsServiceRequest(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpcollectormetrics.ExportMetricsServiceRequest{}
			require.NoError(t, UnmarshalProtoOrigExportMetricsServiceRequest(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExportMetricsServiceRequest() map[string]*otlpcollectormetrics.ExportMetricsServiceRequest {
	return map[string]*otlpcollectormetrics.ExportMetricsServiceRequest{
		"empty": {},
		"fill_test": func() *otlpcollectormetrics.ExportMetricsServiceRequest {
			src := &otlpcollectormetrics.ExportMetricsServiceRequest{}
			FillOrigTestExportMetricsServiceRequest(src)
			return src
		}(),
	}
}
