// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpcollectormetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportMetricsServiceResponse(t *testing.T) {
	src := &otlpcollectormetrics.ExportMetricsServiceResponse{}
	dest := &otlpcollectormetrics.ExportMetricsServiceResponse{}
	CopyOrigExportMetricsServiceResponse(dest, src)
	assert.Equal(t, &otlpcollectormetrics.ExportMetricsServiceResponse{}, dest)
	FillOrigTestExportMetricsServiceResponse(src)
	CopyOrigExportMetricsServiceResponse(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportMetricsServiceResponseUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpcollectormetrics.ExportMetricsServiceResponse{}
	UnmarshalJSONOrigExportMetricsServiceResponse(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpcollectormetrics.ExportMetricsServiceResponse{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportMetricsServiceResponse(t *testing.T) {
	for name, src := range getEncodingTestValuesExportMetricsServiceResponse() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExportMetricsServiceResponse(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpcollectormetrics.ExportMetricsServiceResponse{}
			UnmarshalJSONOrigExportMetricsServiceResponse(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportMetricsServiceResponse(t *testing.T) {
	for name, src := range getEncodingTestValuesExportMetricsServiceResponse() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportMetricsServiceResponse(src))
			gotSize := MarshalProtoOrigExportMetricsServiceResponse(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpcollectormetrics.ExportMetricsServiceResponse{}
			require.NoError(t, UnmarshalProtoOrigExportMetricsServiceResponse(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExportMetricsServiceResponse() map[string]*otlpcollectormetrics.ExportMetricsServiceResponse {
	return map[string]*otlpcollectormetrics.ExportMetricsServiceResponse{
		"empty": {},
		"fill_test": func() *otlpcollectormetrics.ExportMetricsServiceResponse {
			src := &otlpcollectormetrics.ExportMetricsServiceResponse{}
			FillOrigTestExportMetricsServiceResponse(src)
			return src
		}(),
	}
}
