// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcollectorprofile "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigExportProfilesPartialSuccess(dest, src *otlpcollectorprofile.ExportProfilesPartialSuccess) {
	dest.RejectedProfiles = src.RejectedProfiles
	dest.ErrorMessage = src.ErrorMessage
}

func FillOrigTestExportProfilesPartialSuccess(orig *otlpcollectorprofile.ExportProfilesPartialSuccess) {
	orig.RejectedProfiles = int64(13)
	orig.ErrorMessage = "test_errormessage"
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportProfilesPartialSuccess(orig *otlpcollectorprofile.ExportProfilesPartialSuccess, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.RejectedProfiles != int64(0) {
		dest.WriteObjectField("rejectedProfiles")
		dest.WriteInt64(orig.RejectedProfiles)
	}
	if orig.ErrorMessage != "" {
		dest.WriteObjectField("errorMessage")
		dest.WriteString(orig.ErrorMessage)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigExportPartialSuccess unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportProfilesPartialSuccess(orig *otlpcollectorprofile.ExportProfilesPartialSuccess, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "rejectedProfiles", "rejected_profiles":
			orig.RejectedProfiles = iter.ReadInt64()
		case "errorMessage", "error_message":
			orig.ErrorMessage = iter.ReadString()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigExportProfilesPartialSuccess(orig *otlpcollectorprofile.ExportProfilesPartialSuccess) int {
	var n int
	var l int
	_ = l
	if orig.RejectedProfiles != 0 {
		n += 1 + proto.Sov(uint64(orig.RejectedProfiles))
	}
	l = len(orig.ErrorMessage)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigExportProfilesPartialSuccess(orig *otlpcollectorprofile.ExportProfilesPartialSuccess, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.RejectedProfiles != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.RejectedProfiles))
		pos--
		buf[pos] = 0x8
	}
	l = len(orig.ErrorMessage)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.ErrorMessage)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigExportProfilesPartialSuccess(orig *otlpcollectorprofile.ExportProfilesPartialSuccess, buf []byte) error {
	return orig.Unmarshal(buf)
}
