// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func CopyOrigHistogramDataPointSlice(dest, src []*otlpmetrics.HistogramDataPoint) []*otlpmetrics.HistogramDataPoint {
	var newDest []*otlpmetrics.HistogramDataPoint
	if cap(dest) < len(src) {
		newDest = make([]*otlpmetrics.HistogramDataPoint, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpmetrics.HistogramDataPoint{}
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpmetrics.HistogramDataPoint{}
		}
	}
	for i := range src {
		CopyOrigHistogramDataPoint(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestHistogramDataPointSlice() []*otlpmetrics.HistogramDataPoint {
	orig := make([]*otlpmetrics.HistogramDataPoint, 7)
	for i := 0; i < 7; i++ {
		orig[i] = &otlpmetrics.HistogramDataPoint{}
		FillOrigTestHistogramDataPoint(orig[i])
	}
	return orig
}

// UnmarshalJSONOrigHistogramDataPointSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigHistogramDataPointSlice(iter *json.Iterator) []*otlpmetrics.HistogramDataPoint {
	var orig []*otlpmetrics.HistogramDataPoint
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, &otlpmetrics.HistogramDataPoint{})
		UnmarshalJSONOrigHistogramDataPoint(orig[len(orig)-1], iter)
		return true
	})
	return orig
}
