// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigNumberDataPoint(t *testing.T) {
	src := &otlpmetrics.NumberDataPoint{}
	dest := &otlpmetrics.NumberDataPoint{}
	CopyOrigNumberDataPoint(dest, src)
	assert.Equal(t, &otlpmetrics.NumberDataPoint{}, dest)
	FillOrigTestNumberDataPoint(src)
	CopyOrigNumberDataPoint(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigNumberDataPointUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.NumberDataPoint{}
	UnmarshalJSONOrigNumberDataPoint(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.NumberDataPoint{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigNumberDataPoint(t *testing.T) {
	for name, src := range getEncodingTestValuesNumberDataPoint() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigNumberDataPoint(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.NumberDataPoint{}
			UnmarshalJSONOrigNumberDataPoint(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigNumberDataPoint(t *testing.T) {
	for name, src := range getEncodingTestValuesNumberDataPoint() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigNumberDataPoint(src))
			gotSize := MarshalProtoOrigNumberDataPoint(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.NumberDataPoint{}
			require.NoError(t, UnmarshalProtoOrigNumberDataPoint(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesNumberDataPoint() map[string]*otlpmetrics.NumberDataPoint {
	return map[string]*otlpmetrics.NumberDataPoint{
		"empty": {},
		"fill_test": func() *otlpmetrics.NumberDataPoint {
			src := &otlpmetrics.NumberDataPoint{}
			FillOrigTestNumberDataPoint(src)
			return src
		}(),
		"oneof_double": {Value: &otlpmetrics.NumberDataPoint_AsDouble{AsDouble: float64(0)}},
		"oneof_int":    {Value: &otlpmetrics.NumberDataPoint_AsInt{AsInt: int64(0)}},
	}
}
